/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.Map;

public class Bug21240Test
extends CardDAVTest {
    public Bug21240Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        super.getWebDAVClient().setUserAgent("Address%20Book/883 CFNetwork/454.12.4 Darwin/10.8.0 (i386)");
    }

    public void testDeleteContact() throws Exception {
        String uid = Bug21240Test.randomUID() + "-ABSPlugin";
        String pathUid = Bug21240Test.randomUID() + "-ABSPlugin";
        String firstName = "test";
        String lastName = "hannes";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:hannes;test;;;\r\nFN:test hannes\r\nCATEGORIES:Kontakte\r\nX-ABUID:A33920F3-656F-47B7-A335-2C603DA3F324\\:ABPerson\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "END:VCARD" + "\r\n";
        Bug21240Test.assertEquals((String)"response code wrong", (int)201, (int)super.putVCard(pathUid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Bug21240Test.assertEquals((String)"uid wrong", (String)uid, (String)contact.getUid());
        Bug21240Test.assertEquals((String)"firstname wrong", (String)"test", (String)contact.getGivenName());
        Bug21240Test.assertEquals((String)"lastname wrong", (String)"hannes", (String)contact.getSurName());
        Bug21240Test.assertEquals((String)"response code wrong", (int)200, (int)super.delete(pathUid));
        Bug21240Test.assertNull((String)"contact not deleted", (Object)super.getContact(uid));
        Map<String, String> allETags = super.getAllETags();
        for (String href : allETags.values()) {
            Bug21240Test.assertFalse((String)"resource still present", (boolean)href.contains(pathUid));
        }
    }
}

