/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav;

import com.openexchange.dav.caldav.ical.ICalUtils;
import com.openexchange.dav.caldav.ical.SimpleICal;
import java.io.IOException;
import java.util.List;

public class ICalResource {
    public static final String VFREEBUSY = "VFREEBUSY";
    public static final String VCALENDAR = "VCALENDAR";
    public static final String VEVENT = "VEVENT";
    public static final String VALARM = "VALARM";
    public static final String VTODO = "VTODO";
    public static final String VTIMEZONE = "VTIMEZONE";
    private String eTag;
    private String href;
    private final SimpleICal.Component vCalendar;

    public ICalResource(String iCalString, String href, String eTag) throws IOException, SimpleICal.SimpleICalException {
        this.href = href;
        this.eTag = eTag;
        this.vCalendar = SimpleICal.parse(iCalString);
    }

    public ICalResource(String iCalString) throws IOException, SimpleICal.SimpleICalException {
        this(iCalString, null, null);
    }

    public SimpleICal.Component getVEvent() {
        List<SimpleICal.Component> components = this.vCalendar.getComponents(VEVENT);
        return 0 < components.size() ? components.get(0) : null;
    }

    public SimpleICal.Component getVFreeBusy() {
        List<SimpleICal.Component> components = this.vCalendar.getComponents(VFREEBUSY);
        return 0 < components.size() ? components.get(0) : null;
    }

    public List<SimpleICal.Component> getVEvents() {
        return this.vCalendar.getComponents(VEVENT);
    }

    public List<SimpleICal.Component> getVFreeBusys() {
        return this.vCalendar.getComponents(VFREEBUSY);
    }

    public void addComponent(SimpleICal.Component component) {
        this.vCalendar.getComponents().add(component);
    }

    public String toString() {
        return ICalUtils.fold(this.vCalendar.toString());
    }

    public String getETag() {
        return this.eTag;
    }

    public void setEtag(String eTag) {
        this.eTag = eTag;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }
}

