/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.xing.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.xing.actions.AbstractXingRequest;
import com.openexchange.ajax.xing.actions.UserFeedActionParser;
import com.openexchange.ajax.xing.actions.UserFeedResponse;
import java.io.IOException;
import java.util.List;
import org.json.JSONException;

public class UserFeedRequest
extends AbstractXingRequest<UserFeedResponse> {
    private final String email;
    private final long since;
    private final long until;
    private final int[] fields;

    public UserFeedRequest(String email, long since, long until, int[] fields, boolean foe) {
        super(foe);
        this.email = email;
        this.since = since;
        this.until = until;
        this.fields = fields;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AbstractAJAXParser<? extends UserFeedResponse> getParser() {
        return new UserFeedActionParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }

    @Override
    protected void setMoreParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "userfeed"));
        params.add(new AJAXRequest.Parameter("email", this.email));
        if (this.since > 0L) {
            params.add(new AJAXRequest.Parameter("since", this.since));
        }
        if (this.until > 0L) {
            params.add(new AJAXRequest.Parameter("until", this.until));
        }
        if (this.fields.length > 0) {
            params.add(new AJAXRequest.Parameter("user_fields", this.fields));
        }
    }
}

