/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.ArchiveResponse;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;

public class ArchiveRequest
extends AbstractMailRequest<ArchiveResponse> {
    private final String sourceFolderID;
    private final boolean failOnError = true;
    private final String[] mailIDs;
    private Boolean useDefaultName;
    private Boolean createIfAbsent;

    public ArchiveRequest(String[] mailIDs, String sourceFolderID) {
        this.mailIDs = mailIDs;
        this.sourceFolderID = sourceFolderID;
    }

    public void setCreateIfAbsent(boolean createIfAbsent) {
        this.createIfAbsent = createIfAbsent;
    }

    public void setUseDefaultName(boolean useDefaultName) {
        this.useDefaultName = useDefaultName;
    }

    @Override
    public Object getBody() throws JSONException {
        int length = this.mailIDs.length;
        JSONArray jso = new JSONArray(length);
        for (int i = 0; i < length; ++i) {
            jso.put((Object)this.mailIDs[i]);
        }
        return jso;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "archive"));
        list.add(new AJAXRequest.Parameter("folder", this.sourceFolderID));
        if (null != this.useDefaultName) {
            list.add(new AJAXRequest.Parameter("useDefaultName", this.useDefaultName.toString()));
        }
        if (null != this.createIfAbsent) {
            list.add(new AJAXRequest.Parameter("createIfAbsent", this.createIfAbsent.toString()));
        }
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends ArchiveResponse> getParser() {
        return new AbstractAJAXParser<ArchiveResponse>(true){

            @Override
            protected ArchiveResponse createResponse(Response response) throws JSONException {
                return new ArchiveResponse(response);
            }
        };
    }
}

