/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.mail.TestMails;
import com.openexchange.ajax.mail.actions.DeleteRequest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.ImportMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import com.openexchange.ajax.mail.actions.ListRequest;
import com.openexchange.java.Charsets;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.dataobjects.MailMessage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.TimeZone;

public class Bug15608Test
extends AbstractAJAXSession {
    private static final int ORIG_FLAGS = 32;
    private static final int[] ATTRIBUTES = new int[]{MailListField.ID.getField(), MailListField.FLAGS.getField()};
    private AJAXClient client;
    private TimeZone timeZone;
    private String folder;
    private String address;
    private String[][] ids;

    public Bug15608Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.folder = this.client.getValues().getInboxFolder();
        this.address = this.client.getValues().getSendAddress();
        String mail = TestMails.replaceAddresses("From: #ADDR#\nTo: #ADDR#\nSubject: Test for bug 15608\nMime-Version: 1.0\nContent-Type: text/plain; charset=\"UTF-8\"\nContent-Transfer-Encoding: 8bit\n\nTest for bug 15608\n\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df\n", this.address);
        InputStream[] massMails = new ByteArrayInputStream[100];
        for (int i = 0; i < massMails.length; ++i) {
            massMails[i] = new ByteArrayInputStream(mail.getBytes(Charsets.UTF_8));
        }
        ImportMailRequest request = new ImportMailRequest(this.folder, 32, massMails);
        ImportMailResponse response = this.client.execute(request);
        this.ids = response.getIds();
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.ids, true));
        super.tearDown();
    }

    public void testFlags() throws Throwable {
        ListRequest request = new ListRequest(this.ids, ATTRIBUTES);
        CommonListResponse response = this.client.execute(request);
        int flagsPos = response.getColumnPos(MailListField.FLAGS.getField());
        for (Object[] mail : response) {
            int testFlags = (Integer)mail[flagsPos];
            Bug15608Test.assertEquals((String)"Wanted flags are not set.", (int)32, (int)testFlags);
        }
        for (String[] folderAndId : this.ids) {
            String mailId = folderAndId[1];
            if (null == mailId) continue;
            GetRequest request2 = new GetRequest(this.folder, mailId);
            request2.setUnseen(true);
            GetResponse response2 = this.client.execute(request2);
            MailMessage mail = response2.getMail(this.timeZone);
            int testFlags = mail.getFlags();
            Bug15608Test.assertEquals((String)"Wanted flags are not set.", (int)32, (int)testFlags);
        }
    }
}

