/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.ClearRequest;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import org.json.JSONArray;

public class ClearTest
extends AbstractAJAXSession {
    private AJAXClient client;

    public ClearTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testClearPrivate() throws Throwable {
        String newId = null;
        try {
            String protocol;
            FolderObject fo = new FolderObject();
            fo.setParentFolderID(1);
            fo.setFolderName("testCalendarFolder" + System.currentTimeMillis());
            fo.setModule(2);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest request = new InsertRequest(EnumAPI.OUTLOOK, fo);
            InsertResponse response = this.client.execute(request);
            newId = (String)response.getResponse().getData();
            ClearTest.assertNotNull((String)"New ID must not be null!", (Object)newId);
            String string = protocol = null == this.client.getProtocol() ? AJAXConfig.getProperty(AJAXConfig.Property.PROTOCOL) : this.client.getProtocol();
            if (!protocol.endsWith("://")) {
                protocol = protocol + "://";
            }
            String hostname = null == this.client.getHostname() ? AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME) : this.client.getHostname();
            AJAXSession session = this.client.getSession();
            UserValues values = this.client.getValues();
            long s = System.currentTimeMillis();
            Appointment appointmentObj = new Appointment();
            appointmentObj.setTitle("test1Simple" + s);
            appointmentObj.setStartDate(new Date(s));
            appointmentObj.setEndDate(new Date(s + 3600000L));
            appointmentObj.setShownAs(3);
            appointmentObj.setParentFolderID(Integer.parseInt(newId));
            appointmentObj.setIgnoreConflicts(true);
            AppointmentTest.insertAppointment(session.getConversation(), appointmentObj, values.getTimeZone(), protocol + hostname, session.getId());
            appointmentObj = new Appointment();
            appointmentObj.setTitle("test2Simple" + System.currentTimeMillis());
            appointmentObj.setStartDate(new Date(s + 0x6DDD00L));
            appointmentObj.setEndDate(new Date(s + 10800000L));
            appointmentObj.setShownAs(3);
            appointmentObj.setParentFolderID(Integer.parseInt(newId));
            appointmentObj.setIgnoreConflicts(true);
            AppointmentTest.insertAppointment(session.getConversation(), appointmentObj, values.getTimeZone(), protocol + hostname, session.getId());
            CalendarTestManager calendarTestManager = new CalendarTestManager(this.client);
            Appointment[] appointments = calendarTestManager.all(Integer.parseInt(newId), new Date(s - 604800000L), new Date(s + 604800000L));
            ClearTest.assertTrue((String)"Appointments were not created.", (null != appointments && appointments.length == 2 ? 1 : 0) != 0);
            ClearRequest clearRequest = new ClearRequest((API)EnumAPI.OUTLOOK, newId);
            CommonDeleteResponse clearResponse = this.client.execute(clearRequest);
            JSONArray nonClearedIDs = (JSONArray)clearResponse.getResponse().getData();
            ClearTest.assertEquals((String)"Folder could not be cleared.", (int)0, (int)nonClearedIDs.length());
            Appointment[] emptyAppointments = calendarTestManager.all(Integer.parseInt(newId), new Date(s - 604800000L), new Date(s + 604800000L));
            ClearTest.assertTrue((String)"Appointments were not cleared.", (null == emptyAppointments || emptyAppointments.length == 0 ? 1 : 0) != 0);
            if (null == newId) return;
        }
        catch (Throwable throwable) {
            if (null == newId) throw throwable;
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                this.client.execute(deleteRequest);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
            this.client.execute(deleteRequest);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

