/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.java.Strings;
import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Arrays;

public class SortingInJapanTest
extends AbstractManagedContactTest {
    private String originalLocale;

    public SortingInJapanTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.originalLocale = this.client.execute(new GetRequest(Tree.Language)).getString();
        if (Strings.isEmpty((String)this.originalLocale)) {
            SortingInJapanTest.fail((String)"no locale found");
        }
        this.client.execute(new SetRequest(Tree.Language, "ja-JP"));
    }

    @Override
    public void tearDown() throws Exception {
        if (null != this.originalLocale) {
            this.client.execute(new SetRequest(Tree.Language, this.originalLocale));
        }
        super.tearDown();
    }

    public void testCustomSortingForJapan() throws Exception {
        Contact[] orderedContacts = new Contact[]{this.generateContact("\u30a1"), this.generateContact("\u30a3"), this.generateContact("\u30a6"), this.generateContact("\u30ac"), this.generateContact("#*+$&& ASCII Art"), this.generateContact("012345"), this.generateContact("AAAAA"), this.generateContact("Hans Dampf"), this.generateContact("Max Mustermann")};
        ArrayList<Contact> unorderedContacts = new ArrayList<Contact>(Arrays.asList(orderedContacts));
        Collections.shuffle(unorderedContacts);
        this.manager.newActionMultiple(unorderedContacts.toArray(new Contact[unorderedContacts.size()]));
        Contact[] receivedContacts = this.manager.allAction(this.folderID);
        SortingInJapanTest.assertNotNull((String)"no contacts received", (Object)receivedContacts);
        SortingInJapanTest.assertEquals((String)"wrong number of contacts received", (int)orderedContacts.length, (int)receivedContacts.length);
        for (int i = 0; i < receivedContacts.length; ++i) {
            SortingInJapanTest.assertEquals((String)"contact order wrong", (String)orderedContacts[i].getSurName(), (String)receivedContacts[i].getSurName());
        }
    }
}

