/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.util.Date;
import org.junit.Test;

public class DeleteMultipleContactsTest
extends AbstractContactTest {
    private Contact c1;
    private Contact c2;
    private Contact c3;
    private boolean needCleanup = true;

    public DeleteMultipleContactsTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.c1 = new Contact();
        this.c1.setGivenName("Test 1");
        this.c1.setSurName("User");
        this.c1.setDisplayName("Test 1 User");
        this.c1.setEmail1("testuser1@example.org");
        this.c1.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        this.c1.setCreationDate(new Date());
        this.c2 = new Contact();
        this.c2.setGivenName("Test 2");
        this.c2.setSurName("User");
        this.c2.setDisplayName("Test 2 User");
        this.c2.setEmail1("testuser2@example.org");
        this.c2.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        this.c2.setCreationDate(new Date());
        this.c3 = new Contact();
        this.c3.setGivenName("Test 3");
        this.c3.setSurName("User");
        this.c3.setDisplayName("Test 3 User");
        this.c3.setEmail1("testuser3@example.org");
        this.c3.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        this.c3.setCreationDate(new Date());
        InsertRequest in1 = new InsertRequest(this.c1);
        InsertResponse res1 = this.client.execute(in1);
        res1.fillObject((DataObject)this.c1);
        InsertRequest in2 = new InsertRequest(this.c2);
        InsertResponse res2 = this.client.execute(in2);
        res2.fillObject((DataObject)this.c2);
        InsertRequest in3 = new InsertRequest(this.c3);
        InsertResponse res3 = this.client.execute(in3);
        res3.fillObject((DataObject)this.c3);
    }

    @Test
    public void testDeleteMultipleContacts() throws Exception {
        int[] cids = new int[]{this.c1.getObjectID(), this.c2.getObjectID(), this.c3.getObjectID()};
        DeleteRequest delReq = new DeleteRequest(this.client.getValues().getPrivateContactFolder(), cids, new Date());
        CommonDeleteResponse delRes = this.client.execute(delReq);
        DeleteMultipleContactsTest.assertFalse((String)("Delete of multiple contacts failed: " + delRes.getErrorMessage()), (boolean)delRes.hasError());
        this.needCleanup = false;
    }

    @Override
    public void tearDown() throws Exception {
        if (this.needCleanup) {
            try {
                DeleteRequest delReq = new DeleteRequest(this.c1);
                this.client.execute(delReq);
                delReq = new DeleteRequest(this.c2);
                this.client.execute(delReq);
                delReq = new DeleteRequest(this.c3);
                this.client.execute(delReq);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.tearDown();
    }
}

