/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.BetaWriter;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.SetResponse;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttributeWriter
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(BetaWriter.class);
    private Tree param;
    private final AJAXClient.User user;
    private boolean run = true;
    private Throwable t;

    public AttributeWriter(Tree param, AJAXClient.User user) {
        this.param = param;
        this.user = user;
    }

    public void stop() {
        this.run = false;
    }

    public Throwable getThrowable() {
        return this.t;
    }

    @Override
    public void run() {
        try {
            AJAXClient client = new AJAXClient(this.user);
            while (this.run) {
                try {
                    SetResponse response = client.execute(new SetRequest(this.param, this.getValue(), false));
                    OXException exception = response.getException();
                    if (exception == null) continue;
                    throw exception;
                }
                catch (Throwable t) {
                    Throwable handled = this.handleError(t);
                    if (handled == null) continue;
                    LOG.error(handled.getMessage(), handled);
                    t = handled;
                    break;
                }
            }
            client.logout();
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            this.t = e;
        }
    }

    protected abstract Object getValue();

    protected Throwable handleError(Throwable t) {
        return t;
    }
}

