/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AllRequest;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.UserParticipant;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONException;

public class Bug21614Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private AJAXClient clientA;
    private AJAXClient clientB;

    public Bug21614Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        UserParticipant p = new UserParticipant(this.clientB.getValues().getUserId());
        participants.add(p);
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.clientA.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("Bug 21614");
        this.appointment.setStartDate(TimeTools.D("16.04.2012 08:00"));
        this.appointment.setEndDate(TimeTools.D("16.04.2012 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setOccurrence(5);
        this.appointment.setInterval(1);
        this.appointment.setParticipants(participants);
    }

    public void testBug21614() throws Exception {
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
        DeleteRequest deleteRequest = new DeleteRequest(this.appointment.getObjectID(), this.clientA.getValues().getPrivateAppointmentFolder(), 5, this.appointment.getLastModified());
        CommonDeleteResponse deleteResponse = this.clientA.execute(deleteRequest);
        this.appointment.setLastModified(deleteResponse.getTimestamp());
        this.assertNotFind(this.clientA);
        this.assertNotFind(this.clientB);
        deleteRequest = new DeleteRequest(this.appointment.getObjectID(), this.clientB.getValues().getPrivateAppointmentFolder(), 2, this.appointment.getLastModified());
        try {
            deleteResponse = this.clientB.execute(deleteRequest);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        this.assertNotFind(this.clientA);
        this.assertNotFind(this.clientB);
    }

    private void assertNotFind(AJAXClient c) throws IOException, JSONException, OXException {
        Object[][] objects;
        AllRequest allRequest = new AllRequest(c.getValues().getPrivateAppointmentFolder(), new int[]{1}, new Date(1334880000000L), new Date(1334966400000L), TimeZone.getTimeZone("UTC"), false);
        CommonAllResponse allResponse = c.execute(allRequest);
        boolean found = false;
        for (Object[] object : objects = allResponse.getArray()) {
            if (((Integer)object[0]).intValue() != this.appointment.getObjectID()) continue;
            found = true;
        }
        Bug21614Test.assertFalse((String)"Should not find the appointment.", (boolean)found);
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }
}

