/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.participant.ParticipantTools;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class Bug13505Test
extends AbstractAJAXSession {
    private int userId;
    private Appointment appointment;
    private Appointment updateAppointment;
    private TimeZone tz;

    public Bug13505Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.userId = this.getClient().getValues().getUserId();
        this.tz = this.getClient().getValues().getTimeZone();
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.getClient().getValues().getPrivateAppointmentFolder());
        this.appointment.setTitle("Bug 13505 Test");
        this.appointment.setStartDate(TimeTools.createCalendar(this.tz, 2009, 6, 6, 12).getTime());
        this.appointment.setEndDate(TimeTools.createCalendar(this.tz, 2009, 6, 6, 13).getTime());
        this.appointment.setParticipants(ParticipantTools.createParticipants(this.userId));
        this.appointment.setRecurrenceType(2);
        this.appointment.setDays(2);
        this.appointment.setInterval(1);
        this.appointment.setOccurrence(3);
        this.appointment.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.appointment, this.getClient().getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.getClient().execute(request);
        insertResponse.fillObject((DataObject)this.appointment);
        this.updateAppointment = new Appointment();
        insertResponse.fillObject((DataObject)this.updateAppointment);
        this.updateAppointment.setParentFolderID(this.appointment.getParentFolderID());
        this.updateAppointment.setRecurrenceType(3);
        this.updateAppointment.setInterval(1);
        this.updateAppointment.setDayInMonth(1);
        this.updateAppointment.setOccurrence(3);
        this.updateAppointment.setIgnoreConflicts(true);
    }

    public void testBug13505() throws Exception {
        SpecialUpdateRequest updateRequest = new SpecialUpdateRequest(this.updateAppointment, this.tz);
        try {
            UpdateResponse updateResponse = this.client.execute(updateRequest);
            this.appointment.setLastModified(updateResponse.getTimestamp());
        }
        catch (Exception e) {
            Bug13505Test.fail((String)e.getMessage());
        }
        GetRequest get = new GetRequest(this.appointment.getParentFolderID(), this.appointment.getObjectID());
        Appointment loadA = this.getClient().execute(get).getAppointment(this.tz);
        Bug13505Test.assertFalse((String)"No days values expected", (boolean)loadA.containsDays());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment.getObjectID(), this.appointment.getParentFolderID(), this.appointment.getLastModified()));
        super.tearDown();
    }

    protected class SpecialUpdateRequest
    extends UpdateRequest {
        public SpecialUpdateRequest(Appointment appointmentObj, TimeZone timeZone) {
            super(appointmentObj, timeZone);
        }

        public SpecialUpdateRequest(Appointment appointment, TimeZone timezone, boolean failOnError) {
            super(appointment, timezone, failOnError);
        }

        public SpecialUpdateRequest(int originFolder, Appointment appointment, TimeZone timezone, boolean failOnError) {
            super(originFolder, appointment, timezone, failOnError);
        }

        @Override
        public JSONObject getBody() throws JSONException {
            JSONObject retval = super.getBody();
            if (retval.has("days")) {
                retval.remove("days");
                retval.put("days", JSONObject.NULL);
            }
            return retval;
        }
    }
}

