/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.osgi;

import com.openexchange.ajax.Attachment;
import com.openexchange.ajax.ConfigJump;
import com.openexchange.ajax.Folder;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.MailAttachment;
import com.openexchange.ajax.Multiple;
import com.openexchange.ajax.SyncServlet;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.osgi.FolderFieldCollector;
import com.openexchange.ajax.meta.MetaContributorRegistry;
import com.openexchange.ajax.requesthandler.AJAXRequestHandler;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.auth.Authenticator;
import com.openexchange.auth.mbean.AuthenticatorMBean;
import com.openexchange.auth.mbean.impl.AuthenticatorMBeanImpl;
import com.openexchange.cache.registry.CacheAvailabilityRegistry;
import com.openexchange.caching.CacheService;
import com.openexchange.capabilities.CapabilityService;
import com.openexchange.charset.CustomCharsetProvider;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.config.cascade.ConfigViewFactory;
import com.openexchange.configjump.ConfigJumpService;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.configuration.SystemConfig;
import com.openexchange.contactcollector.ContactCollectorService;
import com.openexchange.context.ContextService;
import com.openexchange.conversion.ConversionService;
import com.openexchange.conversion.DataHandler;
import com.openexchange.conversion.DataSource;
import com.openexchange.counter.MailCounter;
import com.openexchange.counter.MailIdleCounter;
import com.openexchange.crypto.CryptoService;
import com.openexchange.data.conversion.ical.ICalEmitter;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.databaseold.Database;
import com.openexchange.dataretention.DataRetentionService;
import com.openexchange.event.EventFactoryService;
import com.openexchange.event.impl.EventFactoryServiceImpl;
import com.openexchange.event.impl.EventQueue;
import com.openexchange.event.impl.osgi.EventHandlerRegistration;
import com.openexchange.event.impl.osgi.OSGiEventDispatcher;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.composition.IDBasedFileAccessFactory;
import com.openexchange.file.storage.parse.FileMetadataParserService;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.filemanagement.DistributedFileManagement;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.folder.FolderDeleteListenerService;
import com.openexchange.folder.FolderService;
import com.openexchange.folder.internal.FolderDeleteListenerServiceTrackerCustomizer;
import com.openexchange.folder.internal.FolderServiceImpl;
import com.openexchange.folderstorage.osgi.FolderStorageActivator;
import com.openexchange.group.GroupService;
import com.openexchange.group.internal.GroupServiceImpl;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarAdministrationService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.contact.datahandler.ContactInsertDataHandler;
import com.openexchange.groupware.contact.datahandler.ContactJSONDataHandler;
import com.openexchange.groupware.contact.datasource.ContactDataSource;
import com.openexchange.groupware.datahandler.ICalInsertDataHandler;
import com.openexchange.groupware.datahandler.ICalJSONDataHandler;
import com.openexchange.groupware.delete.DeleteListener;
import com.openexchange.groupware.impl.id.CreateIDSequenceTable;
import com.openexchange.groupware.importexport.importers.ExtraneousSeriesMasterRecoveryParser;
import com.openexchange.groupware.infostore.EventFiringInfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.notify.hostname.HostnameService;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.userconfiguration.osgi.CapabilityRegistrationListener;
import com.openexchange.html.HtmlService;
import com.openexchange.i18n.I18nService;
import com.openexchange.id.IDGeneratorService;
import com.openexchange.index.IndexFacadeService;
import com.openexchange.lock.LockService;
import com.openexchange.lock.impl.LockServiceImpl;
import com.openexchange.log.Slf4jLogger;
import com.openexchange.login.BlockingLoginHandlerService;
import com.openexchange.login.LoginHandlerService;
import com.openexchange.mail.MailCounterImpl;
import com.openexchange.mail.MailIdleCounterImpl;
import com.openexchange.mail.MailQuotaProvider;
import com.openexchange.mail.api.MailProvider;
import com.openexchange.mail.api.unified.UnifiedViewService;
import com.openexchange.mail.cache.MailAccessCacheEventListener;
import com.openexchange.mail.cache.MailSessionEventHandler;
import com.openexchange.mail.conversion.ICalMailPartDataSource;
import com.openexchange.mail.conversion.VCardAttachMailDataHandler;
import com.openexchange.mail.conversion.VCardMailPartDataSource;
import com.openexchange.mail.loginhandler.MailLoginHandler;
import com.openexchange.mail.loginhandler.TransportLoginHandler;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.osgi.MailCapabilityServiceTracker;
import com.openexchange.mail.osgi.MailProviderServiceTracker;
import com.openexchange.mail.osgi.MailcapServiceTracker;
import com.openexchange.mail.osgi.TransportProviderServiceTracker;
import com.openexchange.mail.service.MailService;
import com.openexchange.mail.service.impl.MailServiceImpl;
import com.openexchange.mail.transport.TransportProvider;
import com.openexchange.mailaccount.MailAccountDeleteListener;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.CreateMailAccountTables;
import com.openexchange.mailaccount.internal.DeleteListenerServiceTracker;
import com.openexchange.management.ManagementService;
import com.openexchange.management.Managements;
import com.openexchange.messaging.registry.MessagingServiceRegistry;
import com.openexchange.mime.MimeTypeMap;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.multiple.internal.MultipleHandlerServiceTracker;
import com.openexchange.osgi.BundleServiceTracker;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.osgi.SimpleRegistryListener;
import com.openexchange.passwordchange.PasswordChangeService;
import com.openexchange.preview.PreviewService;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.resource.ResourceService;
import com.openexchange.search.SearchService;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretService;
import com.openexchange.secret.osgi.tools.WhiteboardSecretService;
import com.openexchange.server.ServiceHolder;
import com.openexchange.server.impl.Starter;
import com.openexchange.server.osgi.AJAXRequestHandlerCustomizer;
import com.openexchange.server.osgi.AttachmentAuthorizationTracker;
import com.openexchange.server.osgi.AttachmentListenerTracker;
import com.openexchange.server.osgi.BlockingLoginHandlerCustomizer;
import com.openexchange.server.osgi.ConfigurationCustomizer;
import com.openexchange.server.osgi.DeleteListenerServiceTrackerCustomizer;
import com.openexchange.server.osgi.DistributedFilesListener;
import com.openexchange.server.osgi.HostnameServiceCustomizer;
import com.openexchange.server.osgi.I18nServiceListener;
import com.openexchange.server.osgi.IndexFacadeCustomizer;
import com.openexchange.server.osgi.LoginHandlerCustomizer;
import com.openexchange.server.osgi.ManagementServiceTracker;
import com.openexchange.server.osgi.PasswordChangeCustomizer;
import com.openexchange.server.osgi.PreferencesCustomizer;
import com.openexchange.server.osgi.PublicationTargetDiscoveryServiceTrackerCustomizer;
import com.openexchange.server.osgi.RegistryCustomizer;
import com.openexchange.server.reloadable.GenericReloadable;
import com.openexchange.server.services.MetaContributors;
import com.openexchange.server.services.ServerRequestHandlerRegistry;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.sessiond.impl.ThreadLocalSessionHolder;
import com.openexchange.spamhandler.SpamHandler;
import com.openexchange.spamhandler.osgi.SpamHandlerServiceTracker;
import com.openexchange.systemname.SystemNameService;
import com.openexchange.textxtraction.TextXtractService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.timer.TimerService;
import com.openexchange.tools.file.external.FileStorageFactoryCandidate;
import com.openexchange.tools.file.internal.CompositeFileStorageFactory;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.session.SessionHolder;
import com.openexchange.tools.strings.StringParser;
import com.openexchange.user.UserService;
import com.openexchange.user.UserServiceInterceptor;
import com.openexchange.user.UserServiceInterceptorRegistry;
import com.openexchange.user.internal.UserServiceImpl;
import com.openexchange.userconf.UserConfigurationService;
import com.openexchange.userconf.UserPermissionService;
import com.openexchange.userconf.internal.UserConfigurationServiceImpl;
import com.openexchange.userconf.internal.UserPermissionServiceImpl;
import com.openexchange.webdav.Infostore;
import com.openexchange.webdav.attachments;
import com.openexchange.webdav.calendar;
import com.openexchange.webdav.contacts;
import com.openexchange.webdav.folders;
import com.openexchange.webdav.freebusy;
import com.openexchange.webdav.groupuser;
import com.openexchange.webdav.ical;
import com.openexchange.webdav.tasks;
import com.openexchange.webdav.vcard;
import com.openexchange.webdav.version;
import com.openexchange.xml.jdom.JDOMParser;
import com.openexchange.xml.spring.SpringParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.spi.CharsetProvider;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import javax.activation.MailcapCommandMap;
import javax.management.ObjectName;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import net.htmlparser.jericho.Config;
import net.htmlparser.jericho.LoggerProvider;
import org.json.JSONObject;
import org.json.JSONValue;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerActivator
extends HousekeepingActivator {
    static final Logger LOG = LoggerFactory.getLogger(ServerActivator.class);
    private static final String STR_IDENTIFIER = "identifier";
    private static final Class<?>[] NEEDED_SERVICES_SERVER = new Class[]{ConfigurationService.class, DatabaseService.class, CacheService.class, EventAdmin.class, SessiondService.class, SpringParser.class, JDOMParser.class, TimerService.class, ThreadPoolService.class, CalendarAdministrationService.class, AppointmentSqlFactoryService.class, CalendarCollectionService.class, MessagingServiceRegistry.class, HtmlService.class, IDBasedFileAccessFactory.class, FileStorageServiceRegistry.class, FileStorageAccountManagerLookupService.class, CryptoService.class, HttpService.class, SystemNameService.class, ImageTransformationService.class, ConfigViewFactory.class, StringParser.class, PreviewService.class, TextXtractService.class, SecretEncryptionFactoryService.class, SearchService.class};
    private static volatile BundleContext CONTEXT;
    private final List<ServiceTracker<?, ?>> serviceTrackerList;
    private final List<EventHandlerRegistration> eventHandlerList;
    private final List<BundleActivator> activators;
    private final Starter starter = new Starter();
    private WhiteboardSecretService secretService;

    public static BundleContext getContext() {
        return CONTEXT;
    }

    public ServerActivator() {
        this.serviceTrackerList = new ArrayList();
        this.eventHandlerList = new ArrayList<EventHandlerRegistration>();
        this.activators = new ArrayList<BundleActivator>(8);
    }

    protected Class<?>[] getNeededServices() {
        return NEEDED_SERVICES_SERVER;
    }

    protected void handleUnavailability(Class<?> clazz) {
        CacheAvailabilityRegistry reg;
        LOG.warn("Absent service: {}", (Object)clazz.getName());
        if (CacheService.class.equals(clazz) && null != (reg = CacheAvailabilityRegistry.getInstance())) {
            try {
                reg.notifyAbsence();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
        ServerServiceRegistry.getInstance().removeService(clazz);
    }

    protected void handleAvailability(Class<?> clazz) {
        CacheAvailabilityRegistry reg;
        LOG.info("Re-available service: {}", (Object)clazz.getName());
        ServerServiceRegistry.getInstance().addService(clazz, this.getService(clazz));
        if (CacheService.class.equals(clazz) && null != (reg = CacheAvailabilityRegistry.getInstance())) {
            try {
                reg.notifyAvailability();
            }
            catch (OXException e) {
                LOG.error("", (Throwable)e);
            }
        }
    }

    private static int parseInt(int index, String[] sa, int defaultValue) {
        if (null == sa) {
            return defaultValue;
        }
        if (index >= sa.length) {
            return defaultValue;
        }
        String toParse = sa[index];
        if (null == toParse) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(toParse.trim());
        }
        catch (NumberFormatException e) {
            LOG.error("Not an integer: {}", (Object)toParse, (Object)e);
            return defaultValue;
        }
    }

    protected void startBundle() throws Exception {
        BundleContext context;
        CONTEXT = context = this.context;
        JSONObject.setLogger((java.util.logging.Logger)new Slf4jLogger(JSONValue.class));
        ConfigurationService service = (ConfigurationService)this.getService(ConfigurationService.class);
        JSONObject.setMaxSize((int)service.getIntProperty("com.openexchange.json.maxSize", 2500));
        Config.LoggerProvider = LoggerProvider.DISABLED;
        ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
        registry.clearRegistry();
        Class<?>[] classes = this.getNeededServices();
        for (int i = 0; i < classes.length; ++i) {
            Object service2 = this.getService(classes[i]);
            if (null == service2) continue;
            registry.addService(classes[i], service2);
        }
        Database.setDatabaseService((DatabaseService)this.getService(DatabaseService.class));
        LOG.info("starting bundle: com.openexchange.server");
        ServiceTracker confTracker = new ServiceTracker(context, ConfigurationService.class, (ServiceTrackerCustomizer)new ConfigurationCustomizer(context));
        confTracker.open();
        this.serviceTrackerList.add(confTracker);
        this.track(I18nService.class, new I18nServiceListener(context));
        this.track(MailAccountDeleteListener.class, new DeleteListenerServiceTracker(context));
        this.track(MailProvider.class, new MailProviderServiceTracker(context));
        this.track(MailcapCommandMap.class, new MailcapServiceTracker(context));
        this.track(CapabilityService.class, new MailCapabilityServiceTracker(context));
        this.track(TransportProvider.class, new TransportProviderServiceTracker(context));
        this.track(SpamHandler.class, new SpamHandlerServiceTracker(context));
        this.track(AJAXRequestHandler.class, new AJAXRequestHandlerCustomizer(context));
        this.track(ICalParser.class, new RegistryCustomizer<ICalParser>(context, ICalParser.class){

            @Override
            protected ICalParser customize(ICalParser service) {
                return new ExtraneousSeriesMasterRecoveryParser(service, ServerServiceRegistry.getInstance());
            }
        });
        this.track(ICalEmitter.class, new RegistryCustomizer<ICalEmitter>(context, ICalEmitter.class));
        this.track(DataRetentionService.class, new RegistryCustomizer<DataRetentionService>(context, DataRetentionService.class));
        this.track(DeleteListener.class, new DeleteListenerServiceTrackerCustomizer(context));
        this.track(FolderDeleteListenerService.class, new FolderDeleteListenerServiceTrackerCustomizer(context));
        this.track(DistributedFileManagement.class, new DistributedFilesListener());
        this.track(CapabilityService.class, new CapabilityRegistrationListener());
        this.track(Authenticator.class, new RegistryCustomizer<Authenticator>(context, Authenticator.class));
        this.track(ManagementService.class, (SimpleRegistryListener)new SimpleRegistryListener<ManagementService>(){

            public void added(ServiceReference<ManagementService> ref, ManagementService management) {
                try {
                    ObjectName objectName = Managements.getObjectName((String)AuthenticatorMBean.class.getName(), (String)"com.openexchange.auth");
                    management.registerMBean(objectName, (Object)new AuthenticatorMBeanImpl());
                }
                catch (Exception e) {
                    LOG.warn("Could not register MBean {}", (Object)AuthenticatorMBean.class.getName());
                }
            }

            public void removed(ServiceReference<ManagementService> ref, ManagementService management) {
                try {
                    management.unregisterMBean(Managements.getObjectName((String)AuthenticatorMBean.class.getName(), (String)"com.openexchange.auth"));
                }
                catch (Exception e) {
                    LOG.warn("Could not un-register MBean {}", (Object)AuthenticatorMBean.class.getName());
                }
            }
        });
        class MetaContributorRegistryCustomizer
        extends RegistryCustomizer<MetaContributorRegistry> {
            public MetaContributorRegistryCustomizer(BundleContext context) {
                super(context, MetaContributorRegistry.class);
            }

            @Override
            public MetaContributorRegistry addingService(ServiceReference<MetaContributorRegistry> serviceReference) {
                MetaContributorRegistry registry = super.addingService(serviceReference);
                MetaContributors.setRegistry(registry);
                return registry;
            }

            @Override
            public void removedService(ServiceReference<MetaContributorRegistry> serviceReference, MetaContributorRegistry o) {
                MetaContributors.setRegistry(null);
                super.removedService(serviceReference, o);
            }
        }
        this.track(MetaContributorRegistry.class, new MetaContributorRegistryCustomizer(context));
        OSGiEventDispatcher dispatcher = new OSGiEventDispatcher();
        EventQueue.setNewEventDispatcher(dispatcher);
        this.eventHandlerList.add(dispatcher);
        this.eventHandlerList.add(new MailAccessCacheEventListener());
        for (EventHandlerRegistration ehr : this.eventHandlerList) {
            ehr.registerService(context);
        }
        this.track(ManagementService.class, (ServiceTrackerCustomizer)new ManagementServiceTracker(context));
        this.track(ConfigJumpService.class, (ServiceTrackerCustomizer)new BundleServiceTracker(context, (ServiceHolder)com.openexchange.configjump.client.ConfigJump.getHolder(), ConfigJumpService.class));
        this.track(PreferencesItemService.class, new PreferencesCustomizer(context));
        this.track(PasswordChangeService.class, new PasswordChangeCustomizer(context));
        this.track(HostnameService.class, new HostnameServiceCustomizer(context));
        this.track(ConversionService.class, new RegistryCustomizer<ConversionService>(context, ConversionService.class));
        this.track(ContactCollectorService.class, new RegistryCustomizer<ContactCollectorService>(context, ContactCollectorService.class));
        this.track(LoginHandlerService.class, new LoginHandlerCustomizer(context));
        this.track(BlockingLoginHandlerService.class, new BlockingLoginHandlerCustomizer(context));
        this.track(MultipleHandlerFactoryService.class, new MultipleHandlerServiceTracker(context));
        this.serviceTrackerList.add(new AttachmentAuthorizationTracker(context));
        this.serviceTrackerList.add(new AttachmentListenerTracker(context));
        this.track(PublicationTargetDiscoveryService.class, new PublicationTargetDiscoveryServiceTrackerCustomizer(context));
        this.track(AdditionalFolderField.class, new FolderFieldCollector(context, Folder.getAdditionalFields()));
        this.track(FileMetadataParserService.class, new ServiceAdderTrackerCustomizer(context));
        this.track(IndexFacadeService.class, new IndexFacadeCustomizer(context));
        this.track(FileStorageFactoryCandidate.class, new CompositeFileStorageFactory());
        this.track(ManagedFileManagement.class, new RegistryCustomizer<ManagedFileManagement>(context, ManagedFileManagement.class));
        this.track(UnifiedViewService.class, new RegistryCustomizer<UnifiedViewService>(context, UnifiedViewService.class));
        UserServiceInterceptorRegistry interceptorRegistry = new UserServiceInterceptorRegistry(context);
        this.track(UserServiceInterceptor.class, interceptorRegistry);
        UserServiceImpl userService = new UserServiceImpl(interceptorRegistry);
        ServerServiceRegistry.getInstance().addService(UserService.class, userService);
        this.starter.start();
        for (ServiceTracker<?, ?> tracker : this.serviceTrackerList) {
            tracker.open();
        }
        this.openTrackers();
        this.registerService(UserService.class, userService);
        this.registerService(Reloadable.class, ServerConfig.getInstance());
        this.registerService(Reloadable.class, SystemConfig.getInstance());
        this.registerService(Reloadable.class, GenericReloadable.getInstance());
        this.registerService(CharsetProvider.class, new CustomCharsetProvider());
        GroupServiceImpl groupService = new GroupServiceImpl();
        this.registerService(GroupService.class, groupService);
        ServerServiceRegistry.getInstance().addService(GroupService.class, groupService);
        this.registerService(ResourceService.class, ServerServiceRegistry.getInstance().getService(ResourceService.class, true));
        ServerServiceRegistry.getInstance().addService(UserConfigurationService.class, new UserConfigurationServiceImpl());
        this.registerService(UserConfigurationService.class, ServerServiceRegistry.getInstance().getService(UserConfigurationService.class, true));
        ServerServiceRegistry.getInstance().addService(UserPermissionService.class, new UserPermissionServiceImpl());
        this.registerService(UserPermissionService.class, ServerServiceRegistry.getInstance().getService(UserPermissionService.class, true));
        this.registerService(ContextService.class, ServerServiceRegistry.getInstance().getService(ContextService.class, true));
        MailServiceImpl mailService = new MailServiceImpl();
        this.registerService(MailService.class, mailService);
        Hashtable<String, String[]> serviceProperties = new Hashtable<String, String[]>(1);
        ((Dictionary)serviceProperties).put("event.topics", MailSessionEventHandler.getTopics());
        this.registerService(EventHandler.class, new MailSessionEventHandler(), serviceProperties);
        this.registerService(MailCounter.class, new MailCounterImpl());
        this.registerService(MailIdleCounter.class, new MailIdleCounterImpl());
        this.registerService(MimeTypeMap.class, new MimeTypeMap(){

            public String getContentType(File file) {
                return MimeType2ExtMap.getContentType(file);
            }

            public String getContentType(String fileName) {
                return MimeType2ExtMap.getContentType(fileName);
            }

            public String getContentTypeByExtension(String extension) {
                return MimeType2ExtMap.getContentTypeByExtension(extension);
            }

            public List<String> getFileExtensions(String mime) {
                return MimeType2ExtMap.getFileExtensions(mime);
            }
        });
        this.registerService(LoginHandlerService.class, new MailLoginHandler());
        this.registerService(LoginHandlerService.class, new TransportLoginHandler());
        this.registerService(CreateTableService.class, (Object)new CreateMailAccountTables());
        this.registerService(CreateTableService.class, (Object)new CreateIDSequenceTable());
        MailAccountStorageService mailAccountStorageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class);
        this.registerService(MailAccountStorageService.class, mailAccountStorageService);
        this.registerService(UnifiedInboxManagement.class, ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class));
        this.registerService(QuotaProvider.class, new MailQuotaProvider(mailAccountStorageService, mailService));
        this.registerService(IDGeneratorService.class, ServerServiceRegistry.getInstance().getService(IDGeneratorService.class));
        Hashtable<String, String> props = new Hashtable<String, String>(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.mail.vcard");
        this.registerService(DataSource.class, new VCardMailPartDataSource(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.mail.ical");
        this.registerService(DataSource.class, new ICalMailPartDataSource(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.contact");
        this.registerService(DataSource.class, new ContactDataSource(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.contact");
        this.registerService(DataHandler.class, new ContactInsertDataHandler(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.contact.json");
        this.registerService(DataHandler.class, new ContactJSONDataHandler(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.ical");
        this.registerService(DataHandler.class, new ICalInsertDataHandler(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.ical.json");
        this.registerService(DataHandler.class, new ICalJSONDataHandler(), props);
        props = new Hashtable(1);
        ((Dictionary)props).put(STR_IDENTIFIER, "com.openexchange.mail.vcard");
        this.registerService(DataHandler.class, new VCardAttachMailDataHandler(), props);
        this.registerService(DBProvider.class, new DBPoolProvider());
        this.registerService(InfostoreFacade.class, com.openexchange.ajax.Infostore.FACADE);
        this.registerService(EventFiringInfostoreFacade.class, com.openexchange.ajax.Infostore.EVENT_FIRING_FACADE);
        this.registerService(InfostoreSearchEngine.class, com.openexchange.ajax.Infostore.SEARCH_ENGINE);
        this.registerService(AttachmentBase.class, Attachment.ATTACHMENT_BASE);
        EventFactoryServiceImpl eventFactoryServiceImpl = new EventFactoryServiceImpl();
        this.registerService(EventFactoryService.class, eventFactoryServiceImpl);
        ServerServiceRegistry.getInstance().addService(EventFactoryService.class, eventFactoryServiceImpl);
        FolderServiceImpl folderService = new FolderServiceImpl();
        this.registerService(FolderService.class, folderService);
        ServerServiceRegistry.getInstance().addService(FolderService.class, folderService);
        this.registerService(SessionHolder.class, ThreadLocalSessionHolder.getInstance());
        ServerServiceRegistry.getInstance().addService(SessionHolder.class, ThreadLocalSessionHolder.getInstance());
        this.activators.add(new FolderStorageActivator());
        for (BundleActivator activator : this.activators) {
            activator.start(context);
        }
        this.secretService = new WhiteboardSecretService(context);
        ServerServiceRegistry.getInstance().addService(SecretService.class, this.secretService);
        this.secretService.open();
        String regionName = "GenLocks";
        byte[] ccf = "jcs.region.GenLocks=\njcs.region.GenLocks.cacheattributes=org.apache.jcs.engine.CompositeCacheAttributes\njcs.region.GenLocks.cacheattributes.MaxObjects=1000000\njcs.region.GenLocks.cacheattributes.MemoryCacheName=org.apache.jcs.engine.memory.lru.LRUMemoryCache\njcs.region.GenLocks.cacheattributes.UseMemoryShrinker=true\njcs.region.GenLocks.cacheattributes.MaxMemoryIdleTimeSeconds=150\njcs.region.GenLocks.cacheattributes.ShrinkerIntervalSeconds=30\njcs.region.GenLocks.elementattributes=org.apache.jcs.engine.ElementAttributes\njcs.region.GenLocks.elementattributes.IsEternal=false\njcs.region.GenLocks.elementattributes.MaxLifeSeconds=-1\njcs.region.GenLocks.elementattributes.IdleTime=150\njcs.region.GenLocks.elementattributes.IsSpool=false\njcs.region.GenLocks.elementattributes.IsRemote=false\njcs.region.GenLocks.elementattributes.IsLateral=false\n".getBytes();
        ((CacheService)this.getService(CacheService.class)).loadConfiguration((InputStream)new ByteArrayInputStream(ccf), true);
        LockServiceImpl lockService = new LockServiceImpl();
        ServerServiceRegistry.getInstance().addService(LockService.class, lockService);
        this.registerService(LockService.class, lockService);
        this.registerServlets((HttpService)this.getService(HttpService.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopBundle() throws Exception {
        LOG.info("stopping bundle: com.openexchange.server");
        try {
            for (BundleActivator bundleActivator : this.activators) {
                bundleActivator.stop(this.context);
            }
            this.activators.clear();
            this.unregisterServices();
            for (ServiceTracker serviceTracker : this.serviceTrackerList) {
                serviceTracker.close();
            }
            this.closeTrackers();
            this.serviceTrackerList.clear();
            ServerRequestHandlerRegistry.getInstance().clearRegistry();
            for (EventHandlerRegistration eventHandlerRegistration : this.eventHandlerList) {
                eventHandlerRegistration.unregisterService();
            }
            this.eventHandlerList.clear();
            this.starter.stop();
            ServerServiceRegistry.getInstance().clearRegistry();
            if (null != this.secretService) {
                this.secretService.close();
                this.secretService = null;
            }
            LoginServlet.setRampUpServices(null);
        }
        finally {
            this.started.set(false);
            CONTEXT = null;
        }
    }

    private void registerServlets(HttpService http) throws ServletException, NamespaceException {
        http.registerServlet("/infostore", (Servlet)new Infostore(), null, null);
        http.registerServlet("/files", (Servlet)new Infostore(), null, null);
        http.registerServlet("/drive", (Servlet)new Infostore(), null, null);
        http.registerServlet("/servlet/webdav.ical", (Servlet)new ical(), null, null);
        http.registerServlet("/servlet/webdav.vcard", (Servlet)new vcard(), null, null);
        http.registerServlet("/servlet/webdav.version", (Servlet)new version(), null, null);
        http.registerServlet("/servlet/webdav.folders", (Servlet)new folders(), null, null);
        http.registerServlet("/servlet/webdav.calendar", (Servlet)new calendar(), null, null);
        http.registerServlet("/servlet/webdav.contacts", (Servlet)new contacts(), null, null);
        http.registerServlet("/servlet/webdav.tasks", (Servlet)new tasks(), null, null);
        http.registerServlet("/servlet/webdav.groupuser", (Servlet)new groupuser(), null, null);
        http.registerServlet("/servlet/webdav.attachments", (Servlet)new attachments(), null, null);
        http.registerServlet("/servlet/webdav.infostore", (Servlet)new Infostore(), null, null);
        http.registerServlet("/servlet/webdav.drive", (Servlet)new Infostore(), null, null);
        http.registerServlet("/servlet/webdav.freebusy", (Servlet)new freebusy(), null, null);
        String prefix = Dispatcher.PREFIX.get();
        http.registerServlet(prefix + "mail.attachment", (Servlet)new MailAttachment(), null, null);
        http.registerServlet(prefix + "multiple", (Servlet)new Multiple(), null, null);
        http.registerServlet(prefix + "control", (Servlet)new ConfigJump(), null, null);
        http.registerServlet(prefix + "sync", (Servlet)new SyncServlet(), null, null);
    }

    private static final class ServiceAdderTrackerCustomizer
    implements ServiceTrackerCustomizer<FileMetadataParserService, FileMetadataParserService> {
        private final BundleContext context;

        public ServiceAdderTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public void removedService(ServiceReference<FileMetadataParserService> reference, FileMetadataParserService service) {
            ServerServiceRegistry.getInstance().removeService(FileMetadataParserService.class);
            this.context.ungetService(reference);
        }

        public void modifiedService(ServiceReference<FileMetadataParserService> reference, FileMetadataParserService service) {
        }

        public FileMetadataParserService addingService(ServiceReference<FileMetadataParserService> reference) {
            FileMetadataParserService service = (FileMetadataParserService)this.context.getService(reference);
            ServerServiceRegistry.getInstance().addService(FileMetadataParserService.class, service);
            return service;
        }
    }
}

