/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountTreeAction;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import org.json.JSONException;
import org.json.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GetTreeAction
extends AbstractMailAccountTreeAction {
    private static final Logger LOG = LoggerFactory.getLogger(GetTreeAction.class);
    public static final String ACTION = "get_tree";

    @Override
    protected AJAXRequestResult innerPerform(AJAXRequestData requestData, ServerSession session, JSONValue jVoid) throws OXException, JSONException {
        int id = GetTreeAction.parseIntParameter("id", requestData);
        MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
        MailAccount mailAccount = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
        if (GetTreeAction.isUnifiedINBOXAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_FOUND.create(id, session.getUserId(), session.getContextId());
        }
        if (!session.getUserPermissionBits().isMultipleMailAccounts() && !GetTreeAction.isDefaultMailAccount(mailAccount)) {
            throw MailAccountExceptionCodes.NOT_ENABLED.create(session.getUserId(), session.getContextId());
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(session, mailAccount.getId());
        return new AJAXRequestResult(GetTreeAction.actionValidateTree0(mailAccess, session));
    }
}

