/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.internal;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.Strings;
import com.openexchange.mail.MailProviderRegistry;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.cache.IMailAccessCache;
import com.openexchange.mail.config.IPRange;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.DefaultFolderNamesProvider;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mail.utils.MailPasswordUtil;
import com.openexchange.mail.utils.ProviderUtility;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountExceptionCodes;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.TransportAuth;
import com.openexchange.mailaccount.UnifiedInboxManagement;
import com.openexchange.mailaccount.internal.AbstractMailAccount;
import com.openexchange.mailaccount.internal.CustomMailAccount;
import com.openexchange.mailaccount.internal.DefaultMailAccount;
import com.openexchange.mailaccount.internal.DeleteListenerRegistry;
import com.openexchange.mailaccount.internal.GenericProperty;
import com.openexchange.mailaccount.internal.UpdateMailAccountBuilder;
import com.openexchange.mailaccount.internal.UpdateTransportAccountBuilder;
import com.openexchange.mailaccount.json.fields.GetSwitch;
import com.openexchange.mailaccount.json.fields.MailAccountGetSwitch;
import com.openexchange.mailaccount.json.fields.SetSwitch;
import com.openexchange.secret.SecretEncryptionFactoryService;
import com.openexchange.secret.SecretEncryptionService;
import com.openexchange.secret.SecretEncryptionStrategy;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.session.SetableSession;
import com.openexchange.session.SetableSessionFactory;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.tools.Collections;
import com.openexchange.tools.net.URIDefaults;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.idn.IDNA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RdbMailAccountStorage
implements MailAccountStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(RdbMailAccountStorage.class);
    private static final SecretEncryptionStrategy<GenericProperty> STRATEGY = MailPasswordUtil.STRATEGY;
    private static final int TYPE_VARCHAR = 12;
    private static final String PARAM_POP3_STORAGE_FOLDERS = "com.openexchange.mailaccount.pop3Folders";
    private static final TIntObjectMap<String> INDEX_2_COL;
    private static final Pattern PATTERN_CONSTRAINT_VIOLATION;
    private static final EnumSet<Attribute> DEFAULT;
    private static final EnumSet<Attribute> DEFAULT_FULL_NAMES;
    private static final EnumSet<Attribute> PRIMARY_EDITABLE;
    private static final char[] CHARS_INVALID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <V> V performSynchronized(Callable<V> task, Session session) throws Exception {
        Lock lock = (Lock)session.getParameter(Session.PARAM_LOCK);
        if (null == lock) {
            lock = Session.EMPTY_LOCK;
        }
        lock.lock();
        try {
            V v = task.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private static void dropPOP3StorageFolders(int userId, int contextId) {
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != service) {
            for (Session session : service.getSessions(userId, contextId)) {
                session.setParameter(PARAM_POP3_STORAGE_FOLDERS, null);
            }
        }
    }

    @Override
    public void invalidateMailAccount(int id, int userId, int contextId) throws OXException {
    }

    @Override
    public void invalidateMailAccounts(int userId, int contextId) throws OXException {
    }

    public static Set<String> getPOP3StorageFolders(final Session session) throws OXException {
        Set<String> set = (Set<String>)session.getParameter(PARAM_POP3_STORAGE_FOLDERS);
        if (null == set) {
            try {
                Callable<Set<String>> task = new Callable<Set<String>>(){

                    @Override
                    public Set<String> call() throws OXException {
                        Set<String> set = (Set<String>)session.getParameter(RdbMailAccountStorage.PARAM_POP3_STORAGE_FOLDERS);
                        if (null == set) {
                            set = RdbMailAccountStorage.getPOP3StorageFolders0(session);
                            session.setParameter(RdbMailAccountStorage.PARAM_POP3_STORAGE_FOLDERS, set);
                        }
                        return set;
                    }
                };
                set = RdbMailAccountStorage.performSynchronized(task, session);
            }
            catch (OXException e) {
                throw e;
            }
            catch (Exception e) {
                throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return set;
    }

    static Set<String> getPOP3StorageFolders0(Session session) throws OXException {
        HashSet<String> hashSet;
        int contextId = session.getContextId();
        Connection con = Database.get(contextId, false);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT value FROM user_mail_account_properties WHERE cid = ? AND user = ? AND name = ?");
            stmt.setInt(1, contextId);
            stmt.setInt(2, session.getUserId());
            stmt.setString(3, "pop3.path");
            rs = stmt.executeQuery();
            HashSet<String> set = new HashSet<String>(4);
            while (rs.next()) {
                set.add(rs.getString(1));
            }
            hashSet = set;
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        Database.back(contextId, false, con);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMailAccount(AbstractMailAccount mailAccount, int id, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            this.fillMailAccount(mailAccount, id, userId, contextId, con);
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    private void fillMailAccount(AbstractMailAccount mailAccount, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT name, url, login, password, primary_addr, default_flag, trash, sent, drafts, spam, confirmed_spam, confirmed_ham, spam_handler, unified_inbox, trash_fullname, sent_fullname, drafts_fullname, spam_fullname, confirmed_spam_fullname, confirmed_ham_fullname, personal, replyTo, archive, archive_fullname FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, id);
            stmt.setLong(3, userId);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw MailAccountExceptionCodes.NOT_FOUND.create(Autoboxing.I((int)id), Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            mailAccount.setId(id);
            mailAccount.setLogin(result.getString(3));
            mailAccount.parseMailServerURL(result.getString(2));
            mailAccount.setName(result.getString(1));
            String pw = result.getString(4);
            if (result.wasNull()) {
                mailAccount.setPassword(null);
            } else {
                mailAccount.setPassword(pw);
            }
            mailAccount.setPrimaryAddress(result.getString(5));
            mailAccount.setTrash(RdbMailAccountStorage.getOptionalString(result.getString(7)));
            mailAccount.setSent(RdbMailAccountStorage.getOptionalString(result.getString(8)));
            mailAccount.setDrafts(RdbMailAccountStorage.getOptionalString(result.getString(9)));
            mailAccount.setSpam(RdbMailAccountStorage.getOptionalString(result.getString(10)));
            mailAccount.setConfirmedSpam(RdbMailAccountStorage.getOptionalString(result.getString(11)));
            mailAccount.setConfirmedHam(RdbMailAccountStorage.getOptionalString(result.getString(12)));
            mailAccount.setArchive(RdbMailAccountStorage.getOptionalString(result.getString(23)));
            mailAccount.setSpamHandler(result.getString(13));
            mailAccount.setUnifiedINBOXEnabled(result.getInt(14) > 0);
            Session session = ((SessiondService)SessiondService.SERVICE_REFERENCE.get()).getAnyActiveSessionForUser(userId, contextId);
            if (null != session) {
                String parameterName = MailSessionParameterNames.getParamDefaultFolderArray();
                String[] fullNames = (String[])MailSessionCache.getInstance(session).getParameter(id, parameterName);
                String s = RdbMailAccountStorage.getOptionalString(result.getString(15));
                mailAccount.setTrashFullname((String)(s == null ? (null == fullNames ? null : fullNames[3]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(16));
                mailAccount.setSentFullname((String)(s == null ? (null == fullNames ? null : fullNames[1]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(17));
                mailAccount.setDraftsFullname((String)(s == null ? (null == fullNames ? null : fullNames[0]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(18));
                mailAccount.setSpamFullname((String)(s == null ? (null == fullNames ? null : fullNames[2]) : s));
                s = RdbMailAccountStorage.getOptionalString(result.getString(24));
                mailAccount.setArchiveFullname(s);
            }
            mailAccount.setConfirmedSpamFullname(RdbMailAccountStorage.getOptionalString(result.getString(19)));
            mailAccount.setConfirmedHamFullname(RdbMailAccountStorage.getOptionalString(result.getString(20)));
            String pers = result.getString(21);
            if (result.wasNull()) {
                mailAccount.setPersonal(null);
            } else {
                mailAccount.setPersonal(pers);
            }
            String replyTo = result.getString(22);
            if (result.wasNull()) {
                mailAccount.setReplyTo(null);
            } else {
                mailAccount.setReplyTo(replyTo);
            }
            mailAccount.setUserId(userId);
            RdbMailAccountStorage.fillProperties(mailAccount, contextId, userId, id, false, con);
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTransportAccount(AbstractMailAccount mailAccount, int id, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            this.fillTransportAccount(mailAccount, id, userId, contextId, con);
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    private void fillTransportAccount(AbstractMailAccount mailAccount, int id, int userId, int contextId, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        block12: {
            stmt = null;
            result = null;
            try {
                stmt = con.prepareStatement("SELECT name, url, login, password, send_addr, default_flag, personal, replyTo FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?");
                stmt.setLong(1, contextId);
                stmt.setLong(2, id);
                stmt.setLong(3, userId);
                result = stmt.executeQuery();
                if (result.next()) {
                    mailAccount.parseTransportServerURL(result.getString(2));
                    String transportLogin = result.getString(3);
                    if (result.wasNull()) {
                        mailAccount.setTransportLogin(null);
                    } else {
                        mailAccount.setTransportLogin(transportLogin);
                    }
                    String transportPassword = result.getString(4);
                    if (result.wasNull()) {
                        mailAccount.setTransportPassword(null);
                    } else {
                        mailAccount.setTransportPassword(transportPassword);
                    }
                    String pers = result.getString(7);
                    if (!result.wasNull()) {
                        mailAccount.setPersonal(pers);
                    }
                    String replyTo = result.getString(8);
                    if (!result.wasNull()) {
                        mailAccount.setReplyTo(replyTo);
                    }
                    RdbMailAccountStorage.fillProperties(mailAccount, contextId, userId, id, true, con);
                    break block12;
                }
                mailAccount.setTransportServer((String)null);
            }
            catch (SQLException e) {
                try {
                    if (null != stmt) {
                        final String sql = stmt.toString();
                        LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                            public String toString() {
                                return sql.substring(sql.indexOf(": ") + 2);
                            }
                        });
                    }
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillProperties(AbstractMailAccount mailAccount, int contextId, int userId, int id, boolean transportProps, Connection con) throws SQLException {
        ResultSet rs;
        PreparedStatement stmt;
        block10: {
            stmt = null;
            rs = null;
            try {
                String table = transportProps ? "user_transport_account_properties" : "user_mail_account_properties";
                stmt = con.prepareStatement("SELECT name, value FROM " + table + " WHERE cid = ? AND user = ? AND id = ?");
                int pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setInt(pos, id);
                rs = stmt.executeQuery();
                if (rs.next()) {
                    HashMap<String, String> properties = new HashMap<String, String>(8, 1.0f);
                    do {
                        String name = rs.getString(1);
                        if (rs.wasNull()) continue;
                        String value = rs.getString(2);
                        if (rs.wasNull()) continue;
                        properties.put(name, value);
                    } while (rs.next());
                    if (!transportProps && 0 == id) {
                        properties.put("addresses", RdbMailAccountStorage.getAliases(userId, contextId, mailAccount));
                    }
                    if (transportProps) {
                        String sTransAuth = (String)properties.remove("transport.auth");
                        if (null != sTransAuth) {
                            mailAccount.setTransportAuth(TransportAuth.transportAuthFor(sTransAuth));
                        }
                        if (!properties.isEmpty()) {
                            mailAccount.setTransportProperties(properties);
                        }
                    } else {
                        mailAccount.setProperties(properties);
                    }
                    break block10;
                }
                if (transportProps) break block10;
                if (0 == id) {
                    HashMap<String, String> properties = new HashMap<String, String>(8, 1.0f);
                    properties.put("addresses", RdbMailAccountStorage.getAliases(userId, contextId, mailAccount));
                    mailAccount.setProperties(properties);
                    break block10;
                }
                mailAccount.setProperties(Collections.<String, String>emptyMap());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
    }

    private static String getAliases(int userId, int contextId, AbstractMailAccount mailAccount) {
        String[] aliases;
        StringBuilder sb = new StringBuilder(128);
        sb.append(mailAccount.getPrimaryAddress());
        HashSet<String> s = new HashSet<String>(4);
        s.add(mailAccount.getPrimaryAddress());
        try {
            aliases = UserStorage.getInstance().getUser(userId, contextId).getAliases();
        }
        catch (OXException e) {
            LOG.warn("", (Throwable)e);
            return sb.toString();
        }
        for (String alias : aliases) {
            if (!s.add(alias)) continue;
            sb.append(", ").append(alias);
        }
        return sb.toString();
    }

    RdbMailAccountStorage() {
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int userId, int contextId) throws OXException {
        this.clearFullNamesForMailAccount(id, null, userId, contextId);
    }

    @Override
    public void clearFullNamesForMailAccount(int id, int[] indexes, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, true);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            this.clearFullNamesForMailAccount(id, indexes, userId, contextId, con);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearFullNamesForMailAccount(int id, int[] indexes, int userId, int contextId, Connection con) throws OXException {
        if (null == con) {
            this.clearFullNamesForMailAccount(id, indexes, userId, contextId);
            return;
        }
        stmt = null;
        try {
            block10: {
                if (null != indexes && indexes.length != 0) break block10;
                stmt = con.prepareStatement("UPDATE user_mail_account SET trash_fullname=?, sent_fullname=?, drafts_fullname=?, spam_fullname=?, confirmed_spam_fullname=?, confirmed_ham_fullname=? WHERE cid=? AND id=? AND user=?");
                num = 1;
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setString(num++, "");
                stmt.setLong(num++, contextId);
                stmt.setLong(num++, id);
                stmt.setLong(num++, userId);
                ** GOTO lbl56
            }
            stmtBuilder = new StringBuilder(512).append("UPDATE user_mail_account SET ");
            finds = 0;
            for (int index : indexes) {
                col = (String)RdbMailAccountStorage.INDEX_2_COL.get(index);
                if (null == col) continue;
                ++finds;
                stmtBuilder.append(col).append("=?,");
            }
            if (finds <= 0) {
            }
            ** GOTO lbl-1000
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, new Object[]{e.getMessage()});
                catch (RuntimeException e) {
                    throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                }
            }
            catch (Throwable var14_18) {
                DBUtils.closeSQLStuff(stmt);
                throw var14_18;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return;
lbl-1000:
        // 1 sources

        {
            stmtBuilder.deleteCharAt(stmtBuilder.length() - 1);
            stmtBuilder.append(" WHERE cid=? AND id=? AND user=?");
            stmt = con.prepareStatement(stmtBuilder.toString());
            stmtBuilder = null;
            num = 1;
            i = finds;
            while (i-- > 0) {
                stmt.setString(num++, "");
            }
            stmt.setLong(num++, contextId);
            stmt.setLong(num++, id);
            stmt.setLong(num++, userId);
lbl56:
            // 2 sources

            stmt.executeUpdate();
        }
        DBUtils.closeSQLStuff(stmt);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId) throws OXException {
        this.deleteMailAccount(id, properties, userId, contextId, false);
    }

    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId, boolean deletePrimary) throws OXException {
        if (!deletePrimary && 0 == id) {
            throw MailAccountExceptionCodes.NO_DEFAULT_DELETE.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(userId, contextId);
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            this.deleteMailAccount(id, properties, userId, contextId, deletePrimary, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteMailAccount(int id, Map<String, Object> properties, int userId, int contextId, boolean deletePrimary, Connection con) throws OXException {
        if (!deletePrimary && 0 == id) {
            throw MailAccountExceptionCodes.NO_DEFAULT_DELETE.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(userId, contextId);
        boolean restoreConstraints = RdbMailAccountStorage.disableForeignKeyChecks(con);
        PreparedStatement stmt = null;
        String pop3Path = RdbMailAccountStorage.getPOP3Path(id, userId, contextId, con);
        if (null != pop3Path) {
            try {
                RdbMailAccountStorage.cleanseFromPrimary(pop3Path, userId, contextId);
            }
            catch (OXException e) {
                LOG.warn("Couldn't delete POP3 backup folders in primary mail account", (Throwable)e);
            }
        }
        DeleteListenerRegistry registry = DeleteListenerRegistry.getInstance();
        registry.triggerOnBeforeDeletion(id, properties, userId, contextId, con);
        this.deleteProperties(contextId, userId, id, false, con);
        this.deleteProperties(contextId, userId, id, true, con);
        stmt = con.prepareStatement("DELETE FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
        stmt.setLong(1, contextId);
        stmt.setLong(2, id);
        stmt.setLong(3, userId);
        stmt.executeUpdate();
        DBUtils.closeSQLStuff(stmt);
        stmt = con.prepareStatement("DELETE FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?");
        stmt.setLong(1, contextId);
        stmt.setLong(2, id);
        stmt.setLong(3, userId);
        stmt.executeUpdate();
        registry.triggerOnAfterDeletion(id, properties, userId, contextId, con);
        DBUtils.closeSQLStuff(stmt);
        if (!restoreConstraints) return;
        try {
            RdbMailAccountStorage.enableForeignKeyChecks(con);
            return;
        }
        catch (SQLException e) {
            LOG.error("", (Throwable)e);
        }
        return;
        catch (SQLException e) {
            String className = e.getClass().getName();
            if (null == className || !className.endsWith("MySQLIntegrityConstraintViolationException")) throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            try {
                if (!RdbMailAccountStorage.handleConstraintViolationException(e, id, userId, contextId, con)) throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                this.deleteMailAccount(id, properties, userId, contextId, deletePrimary, con);
                return;
            }
            catch (RuntimeException re) {
                LOG.debug("", (Throwable)re);
            }
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            if (restoreConstraints) {
                try {
                    RdbMailAccountStorage.enableForeignKeyChecks(con);
                }
                catch (SQLException e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
    }

    private static String getPOP3Path(int id, int userId, int contextId, Connection con) throws OXException {
        String string;
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            rs = null;
            stmt = con.prepareStatement("SELECT url FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, id);
            stmt.setLong(3, userId);
            rs = stmt.executeQuery();
            if (rs.next() && rs.getString(1).startsWith("pop3")) break block6;
            String string2 = null;
            DBUtils.closeSQLStuff(rs, stmt);
            return string2;
        }
        try {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = con.prepareStatement("SELECT value FROM user_mail_account_properties WHERE cid = ? AND id = ? AND user = ? AND name = ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, id);
            stmt.setLong(3, userId);
            stmt.setString(4, "pop3.path");
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (SQLException e) {
            try {
                if (null != stmt) {
                    final String sql = stmt.toString();
                    LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                        public String toString() {
                            return sql.substring(sql.indexOf(": ") + 2);
                        }
                    });
                }
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanseFromPrimary(String path, int userId, int contextId) throws OXException {
        if (RdbMailAccountStorage.isEmpty(path)) {
            return;
        }
        MailAccess<IMailFolderStorage, IMailMessageStorage> defaultMailAccess = null;
        try {
            defaultMailAccess = MailAccess.getInstance(userId, contextId);
            defaultMailAccess.connect(false);
            defaultMailAccess.getFolderStorage().deleteFolder(path, true);
        }
        finally {
            if (null != defaultMailAccess) {
                defaultMailAccess.close(false);
            }
        }
    }

    private static boolean handleConstraintViolationException(SQLException e, int id, int userId, int contextId, Connection con) throws OXException {
        Matcher m = PATTERN_CONSTRAINT_VIOLATION.matcher(e.getMessage());
        if (!m.matches()) {
            return false;
        }
        String[] rows = m.group(2).replaceAll(Pattern.quote("`"), "").split(" *, *");
        if (rows.length != 3) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(Arrays.asList(rows));
        set.removeAll(Arrays.asList("cid", "user", "id"));
        if (!set.isEmpty()) {
            return false;
        }
        String tableName = m.group(1);
        int pos = tableName.indexOf(47) + 1;
        if (pos > 0) {
            tableName = tableName.substring(pos);
        }
        return RdbMailAccountStorage.dropReferenced(id, userId, contextId, tableName, con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean dropReferenced(int id, int userId, int contextId, String tableName, Connection con) throws OXException {
        boolean transactional;
        try {
            boolean bl = transactional = !con.getAutoCommit();
            if (transactional) {
                DBUtils.rollback(con);
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        String sql = new StringBuilder(64).append("DELETE FROM ").append(tableName).append(" WHERE cid = ? AND id = ? and user = ?").toString();
        PreparedStatement stmt = null;
        boolean retval = false;
        try {
            stmt = con.prepareStatement(sql);
            stmt.setLong(1, contextId);
            stmt.setLong(2, id);
            stmt.setLong(3, userId);
            stmt.executeUpdate();
            retval = true;
        }
        catch (SQLException e) {
            LOG.warn("Couldn't delete referenced entries with: {}", (Object)sql, (Object)e);
        }
        catch (Exception e) {
            LOG.warn("Couldn't delete referenced entries with: {}", (Object)sql, (Object)e);
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
        try {
            if (transactional) {
                con.setAutoCommit(false);
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        return retval;
    }

    public MailAccount getDefaultMailAccount(int userId, int contextId, Connection con) throws OXException {
        return this.getMailAccount(0, userId, contextId, con);
    }

    @Override
    public MailAccount getDefaultMailAccount(int userId, int contextId) throws OXException {
        return this.getMailAccount(0, userId, contextId);
    }

    @Override
    public MailAccount getMailAccount(int id, int userId, int contextId, Connection con) throws OXException {
        if (null == con) {
            return this.getMailAccount(id, userId, contextId);
        }
        AbstractMailAccount retval = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
        this.fillMailAccount(retval, id, userId, contextId, con);
        this.fillTransportAccount(retval, id, userId, contextId, con);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount getMailAccount(int id, int userId, int contextId) throws OXException {
        Connection rcon = Database.get(contextId, false);
        try {
            MailAccount mailAccount = this.getMailAccount(id, userId, contextId, rcon);
            return mailAccount;
        }
        finally {
            Database.back(contextId, false, rcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MailAccount[] getUserMailAccounts(int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            MailAccount[] mailAccountArray = this.getUserMailAccounts(userId, contextId, con);
            return mailAccountArray;
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    @Override
    public MailAccount[] getUserMailAccounts(int userId, int contextId, Connection con) throws OXException {
        int[] ids = this.getUserMailAccountIDs(userId, contextId, con);
        MailAccount[] retval = new MailAccount[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = this.getMailAccount(ids[i], userId, contextId, con);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getUserMailAccountIDs(int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            int[] nArray = this.getUserMailAccountIDs(userId, contextId, con);
            return nArray;
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    int[] getUserMailAccountIDs(int userId, int contextId, Connection con) throws OXException {
        int[] nArray;
        ResultSet result;
        PreparedStatement stmt;
        block7: {
            if (null == con) {
                return this.getUserMailAccountIDs(userId, contextId);
            }
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id, url FROM user_mail_account WHERE cid = ? AND user = ? ORDER BY id");
            stmt.setLong(1, contextId);
            stmt.setLong(2, userId);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            int[] nArray2 = new int[]{};
            DBUtils.closeSQLStuff(result, stmt);
            return nArray2;
        }
        try {
            TIntArrayList ids = new TIntArrayList(8);
            do {
                String url;
                if (null == MailProviderRegistry.getRealMailProvider(ProviderUtility.extractProtocol(url = result.getString(2), URIDefaults.IMAP.getProtocol()))) continue;
                ids.add(result.getInt(1));
            } while (result.next());
            nArray = ids.toArray();
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return nArray;
    }

    @Override
    public MailAccount[] resolveLogin(String login, int contextId) throws OXException {
        int[][] idsAndUsers = this.resolveLogin2IDs(login, contextId);
        MailAccount[] retval = new MailAccount[idsAndUsers.length];
        for (int i = 0; i < idsAndUsers.length; ++i) {
            int[] idAndUser = idsAndUsers[i];
            retval[i] = this.getMailAccount(idAndUser[0], idAndUser[1], contextId);
        }
        return retval;
    }

    int[][] resolveLogin2IDs(String login, int contextId) throws OXException {
        Collections.SmartIntArray usersArr;
        Collections.SmartIntArray idsArr;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = Database.get(contextId, false);
            stmt = null;
            result = null;
            idsArr = new Collections.SmartIntArray(8);
            usersArr = new Collections.SmartIntArray(8);
            stmt = con.prepareStatement("SELECT id, user FROM user_mail_account WHERE cid = ? AND login = ?");
            stmt.setLong(1, contextId);
            stmt.setString(2, login);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            int[][] nArrayArray = new int[][]{};
            DBUtils.closeSQLStuff(result, stmt);
            Database.back(contextId, false, con);
            return nArrayArray;
        }
        try {
            do {
                idsArr.append(result.getInt(1));
                usersArr.append(result.getInt(2));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(contextId, false, con);
        int[] ids = idsArr.toArray();
        int[] users = usersArr.toArray();
        int[][] retval = new int[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            retval[i] = new int[]{ids[i], users[i]};
        }
        return retval;
    }

    @Override
    public MailAccount[] resolveLogin(String login, String serverUrl, int contextId) throws OXException {
        int[][] idsAndUsers = this.resolveLogin2IDs(login, contextId);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], contextId);
            if (!serverUrl.equals(ProviderUtility.toSocketAddrString(candidate.generateMailServerURL(), 143))) continue;
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    @Override
    public MailAccount[] resolvePrimaryAddr(String primaryAddress, int contextId) throws OXException {
        int[][] idsAndUsers = this.resolvePrimaryAddr2IDs(primaryAddress, contextId);
        ArrayList<MailAccount> l = new ArrayList<MailAccount>(idsAndUsers.length);
        for (int[] idAndUser : idsAndUsers) {
            MailAccount candidate = this.getMailAccount(idAndUser[0], idAndUser[1], contextId);
            l.add(candidate);
        }
        return l.toArray(new MailAccount[l.size()]);
    }

    int[][] resolvePrimaryAddr2IDs(String primaryAddress, int contextId) throws OXException {
        Collections.SmartIntArray usersArr;
        Collections.SmartIntArray idsArr;
        ResultSet result;
        PreparedStatement stmt;
        Connection con;
        block7: {
            con = Database.get(contextId, false);
            stmt = null;
            result = null;
            idsArr = new Collections.SmartIntArray(8);
            usersArr = new Collections.SmartIntArray(8);
            stmt = con.prepareStatement("SELECT id, user FROM user_mail_account WHERE cid = ? AND primary_addr = ?");
            stmt.setLong(1, contextId);
            stmt.setString(2, primaryAddress);
            result = stmt.executeQuery();
            if (result.next()) break block7;
            int[][] nArrayArray = new int[][]{};
            DBUtils.closeSQLStuff(result, stmt);
            Database.back(contextId, false, con);
            return nArrayArray;
        }
        try {
            do {
                idsArr.append(result.getInt(1));
                usersArr.append(result.getInt(2));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                Database.back(contextId, false, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        Database.back(contextId, false, con);
        int[] ids = idsArr.toArray();
        int[] users = usersArr.toArray();
        int[][] idsAndUsers = new int[ids.length][];
        for (int i = 0; i < ids.length; ++i) {
            idsAndUsers[i] = new int[]{ids[i], users[i]};
        }
        return idsAndUsers;
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int userId, int contextId, Session session) throws OXException {
        this.updateMailAccount(mailAccount, attributes, userId, contextId, session, false);
    }

    private void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int userId, int contextId, Session session, boolean changePrimary) throws OXException {
        Connection con = Database.get(contextId, true);
        boolean rollback = false;
        try {
            con.setAutoCommit(false);
            rollback = true;
            this.updateMailAccount(mailAccount, attributes, userId, contextId, session, con, changePrimary);
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, Set<Attribute> attributes, int userId, int contextId, Session session, Connection con, boolean changePrimary) throws OXException {
        String name;
        if (null == con) {
            this.updateMailAccount(mailAccount, attributes, userId, contextId, session, changePrimary);
            return;
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(userId, contextId);
        if (attributes.contains((Object)Attribute.NAME_LITERAL) && !RdbMailAccountStorage.isValid(name = mailAccount.getName())) {
            throw MailAccountExceptionCodes.INVALID_NAME.create(name);
        }
        if (!changePrimary && (mailAccount.isDefaultFlag() || 0 == mailAccount.getId())) {
            boolean containsUnifiedInbox = attributes.contains((Object)Attribute.UNIFIED_INBOX_ENABLED_LITERAL);
            boolean containsPersonal = attributes.contains((Object)Attribute.PERSONAL_LITERAL);
            boolean containsReplyTo = attributes.contains((Object)Attribute.REPLY_TO_LITERAL);
            boolean containsArchive = attributes.contains((Object)Attribute.ARCHIVE_LITERAL);
            boolean containsArchiveFullName = attributes.contains((Object)Attribute.ARCHIVE_FULLNAME_LITERAL);
            if (!(containsUnifiedInbox || containsPersonal || containsReplyTo || containsArchive || containsArchiveFullName)) {
                throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            MailAccount storageVersion = this.getMailAccount(mailAccount.getId(), userId, contextId, con);
            MailAccountGetSwitch storageGetSwitch = new MailAccountGetSwitch(storageVersion);
            GetSwitch getSwitch = new GetSwitch(mailAccount);
            for (Attribute attribute : attributes) {
                if (PRIMARY_EDITABLE.contains((Object)attribute)) continue;
                Object storageValue = attribute.doSwitch(storageGetSwitch);
                Object newValue = attribute.doSwitch(getSwitch);
                if (null == storageValue || !(Attribute.PASSWORD_LITERAL.equals((Object)attribute) || Attribute.TRANSPORT_PASSWORD_LITERAL.equals((Object)attribute) || Attribute.TRANSPORT_LOGIN_LITERAL.equals((Object)attribute) ? null != newValue : !(!DEFAULT_FULL_NAMES.contains((Object)attribute) ? storageValue.equals(newValue) : MailFolderUtility.prepareMailFolderParam(storageValue.toString()).equals(MailFolderUtility.prepareMailFolderParam(newValue.toString()))))) continue;
                throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE_ATTR.create(attribute.getName(), Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            if (containsUnifiedInbox) {
                UnifiedInboxManagement management;
                this.updateUnifiedINBOXEnabled(mailAccount.isUnifiedINBOXEnabled(), 0, userId, contextId, con);
                if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(userId, contextId, con)) {
                    management.createUnifiedINBOX(userId, contextId, con);
                }
            }
            if (containsPersonal) {
                this.updatePersonal(mailAccount.getPersonal(), 0, userId, contextId, con);
            }
            if (containsReplyTo) {
                this.updateReplyTo(mailAccount.getReplyTo(), 0, userId, contextId, con);
            }
            if (containsArchive) {
                this.updateArchive(mailAccount.getArchive(), 0, userId, contextId, con);
            }
            if (containsArchiveFullName) {
                this.updateArchiveFullName(mailAccount.getArchiveFullname(), 0, userId, contextId, con);
            }
        } else {
            UnifiedInboxManagement management;
            Object stmt = null;
            ResultSet rs = null;
            try {
                String oldProtocol;
                String newProtocol;
                String oldProtocol2;
                String newProtocol2;
                Object value;
                SetSwitch setSwitch;
                MailAccountGetSwitch getSwitch;
                MailAccount storageVersion = null;
                if (this.prepareURL(attributes, Attribute.MAIL_URL_ATTRIBUTES, Attribute.MAIL_URL_LITERAL)) {
                    storageVersion = this.getMailAccount(mailAccount.getId(), userId, contextId, con);
                    getSwitch = new MailAccountGetSwitch(storageVersion);
                    setSwitch = new SetSwitch(mailAccount);
                    for (Attribute attribute : Attribute.MAIL_URL_ATTRIBUTES) {
                        if (attributes.contains((Object)attribute)) continue;
                        value = attribute.doSwitch(getSwitch);
                        setSwitch.setValue(value);
                        attribute.doSwitch(setSwitch);
                    }
                    this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), userId, contextId, con);
                    newProtocol2 = mailAccount.getMailProtocol();
                    if (null != newProtocol2 && !newProtocol2.equalsIgnoreCase(oldProtocol2 = storageVersion.getMailProtocol())) {
                        throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol2, newProtocol2, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                    }
                } else if (attributes.contains((Object)Attribute.MAIL_URL_LITERAL)) {
                    this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), userId, contextId, con);
                    newProtocol = mailAccount.getMailProtocol();
                    if (null != newProtocol && !newProtocol.equalsIgnoreCase(oldProtocol = (storageVersion = this.getMailAccount(mailAccount.getId(), userId, contextId, con)).getMailProtocol())) {
                        throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol, newProtocol, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                    }
                }
                if (this.prepareURL(attributes, Attribute.TRANSPORT_URL_ATTRIBUTES, Attribute.TRANSPORT_URL_LITERAL)) {
                    if (null == storageVersion) {
                        storageVersion = this.getMailAccount(mailAccount.getId(), userId, contextId, con);
                    }
                    getSwitch = new MailAccountGetSwitch(storageVersion);
                    setSwitch = new SetSwitch(mailAccount);
                    for (Attribute attribute : Attribute.TRANSPORT_URL_ATTRIBUTES) {
                        if (attributes.contains((Object)attribute)) continue;
                        value = attribute.doSwitch(getSwitch);
                        setSwitch.setValue(value);
                        attribute.doSwitch(setSwitch);
                    }
                    this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), userId, contextId, con);
                    newProtocol2 = mailAccount.getTransportProtocol();
                    if (null != newProtocol2 && !newProtocol2.equalsIgnoreCase(oldProtocol2 = storageVersion.getTransportProtocol())) {
                        throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol2, newProtocol2, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                    }
                } else if (attributes.contains((Object)Attribute.TRANSPORT_URL_LITERAL)) {
                    this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{mailAccount.getId()}), userId, contextId, con);
                    newProtocol = mailAccount.getTransportProtocol();
                    if (null != newProtocol) {
                        if (null == storageVersion) {
                            storageVersion = this.getMailAccount(mailAccount.getId(), userId, contextId, con);
                        }
                        if (!newProtocol.equalsIgnoreCase(oldProtocol = storageVersion.getTransportProtocol())) {
                            throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol, newProtocol, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                        }
                    }
                }
                attributes.removeAll(Attribute.MAIL_URL_ATTRIBUTES);
                attributes.removeAll(Attribute.TRANSPORT_URL_ATTRIBUTES);
                String encryptedPassword = null;
                ArrayList<Attribute> orderedAttributes = null;
                if (UpdateMailAccountBuilder.needsUpdate(attributes)) {
                    orderedAttributes = new ArrayList<Attribute>(attributes);
                    UpdateMailAccountBuilder sqlBuilder = new UpdateMailAccountBuilder();
                    GetSwitch getter = new GetSwitch(mailAccount);
                    Iterator iter = orderedAttributes.iterator();
                    while (iter.hasNext()) {
                        Attribute attribute = (Attribute)((Object)iter.next());
                        if (Attribute.MAIL_URL_LITERAL == attribute) {
                            Object value2 = attribute.doSwitch(getter);
                            if (null == value2) {
                                iter.remove();
                                continue;
                            }
                            attribute.doSwitch(sqlBuilder);
                            continue;
                        }
                        attribute.doSwitch(sqlBuilder);
                    }
                    stmt = con.prepareStatement(sqlBuilder.getUpdateQuery());
                    int pos = 1;
                    for (Attribute attribute : orderedAttributes) {
                        String s;
                        if (!sqlBuilder.handles(attribute)) continue;
                        Object value3 = attribute.doSwitch(getter);
                        if (Attribute.PASSWORD_LITERAL == attribute) {
                            encryptedPassword = this.encrypt(mailAccount.getPassword(), session);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedPassword);
                            continue;
                        }
                        if (Attribute.PERSONAL_LITERAL == attribute) {
                            String personal = mailAccount.getPersonal();
                            if (RdbMailAccountStorage.isEmpty(personal)) {
                                stmt.setNull(pos++, 12);
                                continue;
                            }
                            stmt.setString(pos++, personal);
                            continue;
                        }
                        if (Attribute.REPLY_TO_LITERAL == attribute) {
                            String replyTo = mailAccount.getReplyTo();
                            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                stmt.setNull(pos++, 12);
                                continue;
                            }
                            stmt.setString(pos++, replyTo);
                            continue;
                        }
                        if (Attribute.ARCHIVE_LITERAL == attribute) {
                            s = mailAccount.getArchive();
                            if (RdbMailAccountStorage.isEmpty(s)) {
                                stmt.setString(pos++, "");
                                continue;
                            }
                            stmt.setString(pos++, s);
                            continue;
                        }
                        if (Attribute.ARCHIVE_FULLNAME_LITERAL == attribute) {
                            s = mailAccount.getArchiveFullname();
                            if (RdbMailAccountStorage.isEmpty(s)) {
                                stmt.setString(pos++, "");
                                continue;
                            }
                            stmt.setString(pos++, MailFolderUtility.prepareMailFolderParam(s).getFullname());
                            continue;
                        }
                        if (DEFAULT.contains((Object)attribute)) {
                            if (DEFAULT_FULL_NAMES.contains((Object)attribute)) {
                                String fullName = null == value3 ? "" : MailFolderUtility.prepareMailFolderParam((String)value3).getFullname();
                                stmt.setString(pos++, fullName);
                                continue;
                            }
                            if (null == value3) {
                                stmt.setObject(pos++, "");
                                continue;
                            }
                            stmt.setObject(pos++, value3);
                            continue;
                        }
                        stmt.setObject(pos++, value3);
                    }
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, mailAccount.getId());
                    stmt.setLong(pos++, userId);
                    if (LOG.isDebugEnabled()) {
                        String query = stmt.toString();
                        LOG.debug("Trying to perform SQL update query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                    }
                    stmt.executeUpdate();
                    DBUtils.closeSQLStuff((Statement)stmt);
                }
                if (UpdateTransportAccountBuilder.needsUpdate(attributes)) {
                    if (orderedAttributes == null) {
                        orderedAttributes = new ArrayList<Attribute>(attributes);
                    }
                    stmt = con.prepareStatement("SELECT 1 FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?");
                    int pos = 1;
                    stmt.setLong(pos++, contextId);
                    stmt.setLong(pos++, mailAccount.getId());
                    stmt.setLong(pos++, userId);
                    rs = stmt.executeQuery();
                    boolean exists = rs.next();
                    DBUtils.closeSQLStuff(rs, (Statement)stmt);
                    if (exists) {
                        Object value4;
                        UpdateTransportAccountBuilder sqlBuilder = new UpdateTransportAccountBuilder();
                        GetSwitch getter = new GetSwitch(mailAccount);
                        Iterator iter = orderedAttributes.iterator();
                        while (iter.hasNext()) {
                            Attribute attribute = (Attribute)((Object)iter.next());
                            if (Attribute.TRANSPORT_URL_LITERAL == attribute) {
                                value4 = attribute.doSwitch(getter);
                                if (null == value4) {
                                    iter.remove();
                                    continue;
                                }
                                attribute.doSwitch(sqlBuilder);
                                continue;
                            }
                            attribute.doSwitch(sqlBuilder);
                        }
                        stmt = con.prepareStatement(sqlBuilder.getUpdateQuery());
                        pos = 1;
                        for (Attribute attribute : orderedAttributes) {
                            if (!sqlBuilder.handles(attribute)) continue;
                            value4 = attribute.doSwitch(getter);
                            if (Attribute.TRANSPORT_PASSWORD_LITERAL == attribute) {
                                if (encryptedPassword == null) {
                                    encryptedPassword = this.encrypt(mailAccount.getTransportPassword(), session);
                                }
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedPassword);
                                continue;
                            }
                            if (Attribute.TRANSPORT_LOGIN_LITERAL == attribute) {
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, (String)value4);
                                continue;
                            }
                            if (Attribute.TRANSPORT_URL_LITERAL == attribute) {
                                RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, (String)value4);
                                continue;
                            }
                            if (Attribute.PERSONAL_LITERAL == attribute) {
                                String personal = mailAccount.getPersonal();
                                if (RdbMailAccountStorage.isEmpty(personal)) {
                                    stmt.setNull(pos++, 12);
                                    continue;
                                }
                                stmt.setString(pos++, personal);
                                continue;
                            }
                            if (Attribute.REPLY_TO_LITERAL == attribute) {
                                String replyTo = mailAccount.getReplyTo();
                                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                    stmt.setNull(pos++, 12);
                                    continue;
                                }
                                stmt.setString(pos++, replyTo);
                                continue;
                            }
                            stmt.setObject(pos++, value4);
                        }
                        stmt.setLong(pos++, contextId);
                        stmt.setLong(pos++, mailAccount.getId());
                        stmt.setLong(pos++, userId);
                        if (LOG.isDebugEnabled()) {
                            String query = stmt.toString();
                            LOG.debug("Trying to perform SQL update query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                        }
                        stmt.executeUpdate();
                        DBUtils.closeSQLStuff((Statement)stmt);
                    } else {
                        String transportURL = mailAccount.generateTransportServerURL();
                        if (null != transportURL) {
                            stmt.close();
                            String encryptedTransportPassword = session == null ? null : this.encrypt(mailAccount.getTransportPassword(), session);
                            stmt = con.prepareStatement("INSERT INTO user_transport_account (cid, id, user, name, url, login, password, send_addr, default_flag, personal, replyTo) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                            pos = 1;
                            stmt.setLong(pos++, contextId);
                            stmt.setLong(pos++, mailAccount.getId());
                            stmt.setLong(pos++, userId);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, mailAccount.getName());
                            stmt.setString(pos++, transportURL);
                            if (null == mailAccount.getTransportLogin()) {
                                stmt.setString(pos++, "");
                            } else {
                                stmt.setString(pos++, mailAccount.getTransportLogin());
                            }
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, encryptedTransportPassword);
                            RdbMailAccountStorage.setOptionalString((PreparedStatement)stmt, pos++, mailAccount.getPrimaryAddress());
                            stmt.setInt(pos++, 0);
                            String personal = mailAccount.getPersonal();
                            if (RdbMailAccountStorage.isEmpty(personal)) {
                                stmt.setNull(pos++, 12);
                            } else {
                                stmt.setString(pos++, personal);
                            }
                            String replyTo = mailAccount.getReplyTo();
                            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                                stmt.setNull(pos++, 12);
                            } else {
                                stmt.setString(pos++, replyTo);
                            }
                            if (LOG.isDebugEnabled()) {
                                String query = stmt.toString();
                                LOG.debug("Trying to perform SQL insert query for attributes {} :\n{}", orderedAttributes, (Object)query.substring(query.indexOf(58) + 1));
                            }
                            stmt.executeUpdate();
                            DBUtils.closeSQLStuff((Statement)stmt);
                        }
                    }
                }
                Map<String, String> properties = mailAccount.getProperties();
                if (attributes.contains((Object)Attribute.POP3_DELETE_WRITE_THROUGH_LITERAL)) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "pop3.deletewt", properties.get("pop3.deletewt"), false, con);
                }
                if (attributes.contains((Object)Attribute.POP3_EXPUNGE_ON_QUIT_LITERAL)) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "pop3.expunge", properties.get("pop3.expunge"), false, con);
                }
                if (attributes.contains((Object)Attribute.POP3_REFRESH_RATE_LITERAL)) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "pop3.refreshrate", properties.get("pop3.refreshrate"), false, con);
                }
                if (attributes.contains((Object)Attribute.POP3_STORAGE_LITERAL)) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "pop3.storage", properties.get("pop3.storage"), false, con);
                }
                if (attributes.contains((Object)Attribute.POP3_PATH_LITERAL)) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "pop3.path", properties.get("pop3.path"), false, con);
                }
                if (attributes.contains((Object)Attribute.TRANSPORT_AUTH_LITERAL)) {
                    TransportAuth transportAuth = mailAccount.getTransportAuth();
                    this.updateProperty(contextId, userId, mailAccount.getId(), "transport.auth", null == transportAuth ? null : transportAuth.getId(), true, con);
                }
            }
            catch (SQLException e) {
                try {
                    if (null != stmt) {
                        final String sql = stmt.toString();
                        LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                            public String toString() {
                                return sql.substring(sql.indexOf(": ") + 2);
                            }
                        });
                    }
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, (Statement)stmt);
            if (attributes.contains((Object)Attribute.UNIFIED_INBOX_ENABLED_LITERAL) && mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(userId, contextId, con)) {
                management.createUnifiedINBOX(userId, contextId, con);
            }
        }
    }

    private void updateUnifiedINBOXEnabled(boolean unifiedINBOXEnabled, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET unified_inbox = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            stmt.setInt(pos++, unifiedINBOXEnabled ? 1 : 0);
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            if (null != stmt) {
                final String sql = stmt.toString();
                LOG.debug("\n\tFailed mail account statement:\n\t{}", new Object(){

                    public String toString() {
                        return sql.substring(sql.indexOf(": ") + 2);
                    }
                });
            }
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updatePersonal(String personal, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET personal = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == personal) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement("UPDATE user_transport_account SET personal = ? WHERE cid = ? AND id = ? AND user = ?");
            pos = 1;
            if (null == personal) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateReplyTo(String replyTo, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == replyTo) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
            DBUtils.closeSQLStuff(stmt);
            stmt = con.prepareStatement("UPDATE user_transport_account SET replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
            pos = 1;
            if (null == replyTo) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateArchive(String archive, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET archive = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == archive) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, archive);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    private void updateArchiveFullName(String archiveFullName, int id, int userId, int contextId, Connection con) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement("UPDATE user_mail_account SET archive_fullname = ? WHERE cid = ? AND id = ? AND user = ?");
            int pos = 1;
            if (null == archiveFullName) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, archiveFullName);
            }
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, id);
            stmt.setInt(pos++, userId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperty(int contextId, int userId, int accountId, String name, String newValue, boolean transportProps, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String table = transportProps ? "user_transport_account_properties" : "user_mail_account_properties";
            stmt = con.prepareStatement("DELETE FROM " + table + " WHERE cid = ? AND user = ? AND id = ? AND name = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, accountId);
            stmt.setString(pos++, name);
            stmt.executeUpdate();
            if (null != newValue && newValue.length() > 0) {
                DBUtils.closeSQLStuff(stmt);
                stmt = con.prepareStatement("INSERT INTO " + table + " (cid, user, id, name, value) VALUES (?, ?, ?, ?, ?)");
                pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setInt(pos++, accountId);
                stmt.setString(pos++, name);
                stmt.setString(pos++, newValue);
                stmt.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProperties(int contextId, int userId, int accountId, boolean transportProps, Connection con) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String table = transportProps ? "user_transport_account_properties" : "user_mail_account_properties";
            stmt = con.prepareStatement("DELETE FROM " + table + " WHERE cid = ? AND user = ? AND id = ?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setInt(pos++, accountId);
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(stmt);
    }

    private boolean prepareURL(Set<Attribute> attributes, Set<Attribute> compareWith, Attribute urlAttribute) {
        EnumSet<Attribute> copy;
        EnumSet<Attribute> enumSet = copy = attributes.isEmpty() ? EnumSet.noneOf(Attribute.class) : EnumSet.copyOf(attributes);
        if (copy.removeAll(compareWith)) {
            attributes.add(urlAttribute);
            return !attributes.containsAll(compareWith);
        }
        return false;
    }

    @Override
    public void updateMailAccount(MailAccountDescription mailAccount, int userId, int contextId, Session session) throws OXException {
        this.updateAndReturnMailAccount(mailAccount, userId, contextId, session);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MailAccount updateAndReturnMailAccount(MailAccountDescription mailAccount, int userId, int contextId, Session session) throws OXException {
        MailAccount mailAccount2;
        PreparedStatement stmt;
        Connection con;
        block28: {
            int accountId = mailAccount.getId();
            if (mailAccount.isDefaultFlag() || 0 == accountId) {
                throw MailAccountExceptionCodes.NO_DEFAULT_UPDATE.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            String name = mailAccount.getName();
            if (!RdbMailAccountStorage.isValid(name)) {
                throw MailAccountExceptionCodes.INVALID_NAME.create(name);
            }
            RdbMailAccountStorage.dropPOP3StorageFolders(userId, contextId);
            con = Database.get(contextId, true);
            stmt = null;
            boolean rollback = false;
            try {
                UnifiedInboxManagement management;
                TransportAuth transportAuth;
                Map<String, String> properties;
                String oldProtocol;
                this.checkDuplicateMailAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{accountId}), userId, contextId, con);
                this.checkDuplicateTransportAccount(mailAccount, (TIntSet)new TIntHashSet(new int[]{accountId}), userId, contextId, con);
                MailAccount storageVersion = this.getMailAccount(accountId, userId, contextId, con);
                String newProtocol = mailAccount.getMailProtocol();
                if (null != newProtocol && !newProtocol.equalsIgnoreCase(oldProtocol = storageVersion.getMailProtocol())) {
                    throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol, newProtocol, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                }
                newProtocol = mailAccount.getTransportProtocol();
                if (null != newProtocol && !newProtocol.equalsIgnoreCase(oldProtocol = storageVersion.getTransportProtocol())) {
                    throw MailAccountExceptionCodes.PROTOCOL_CHANGE.create(oldProtocol, newProtocol, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
                }
                con.setAutoCommit(false);
                rollback = true;
                String encryptedPassword = this.encrypt(mailAccount.getPassword(), session);
                stmt = con.prepareStatement("UPDATE user_mail_account SET name = ?, url = ?, login = ?, password = ?, primary_addr = ?, spam_handler = ?, trash = ?, sent = ?, drafts = ?, spam = ?, confirmed_spam = ?, confirmed_ham = ?, unified_inbox = ?, trash_fullname = ?, sent_fullname = ?, drafts_fullname = ?, spam_fullname = ?, confirmed_spam_fullname = ?, confirmed_ham_fullname = ?, personal = ?, replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
                int pos = 1;
                stmt.setString(pos++, name);
                stmt.setString(pos++, mailAccount.generateMailServerURL());
                stmt.setString(pos++, mailAccount.getLogin());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, encryptedPassword);
                stmt.setString(pos++, mailAccount.getPrimaryAddress());
                String sh = mailAccount.getSpamHandler();
                if (null == sh) {
                    stmt.setNull(pos++, 12);
                } else {
                    stmt.setString(pos++, sh);
                }
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrash());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSent());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDrafts());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpam());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpam());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHam());
                stmt.setInt(pos++, mailAccount.isUnifiedINBOXEnabled() ? 1 : 0);
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrashFullname());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSentFullname());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDraftsFullname());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpamFullname());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpamFullname());
                RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHamFullname());
                String personal = mailAccount.getPersonal();
                if (RdbMailAccountStorage.isEmpty(personal)) {
                    stmt.setNull(pos++, 12);
                } else {
                    stmt.setString(pos++, personal);
                }
                String replyTo = mailAccount.getReplyTo();
                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                    stmt.setNull(pos++, 12);
                } else {
                    stmt.setString(pos++, replyTo);
                }
                stmt.setLong(pos++, contextId);
                stmt.setLong(pos++, accountId);
                stmt.setLong(pos++, userId);
                stmt.executeUpdate();
                String transportURL = mailAccount.generateTransportServerURL();
                if (null != transportURL) {
                    String encryptedTransportPassword = this.encrypt(mailAccount.getTransportPassword(), session);
                    stmt.close();
                    stmt = con.prepareStatement("UPDATE user_transport_account SET name = ?, url = ?, login = ?, password = ?, send_addr = ?, personal = ?, replyTo = ? WHERE cid = ? AND id = ? AND user = ?");
                    int pos2 = 1;
                    stmt.setString(pos2++, name);
                    stmt.setString(pos2++, transportURL);
                    RdbMailAccountStorage.setOptionalString(stmt, pos2++, mailAccount.getTransportLogin());
                    RdbMailAccountStorage.setOptionalString(stmt, pos2++, encryptedTransportPassword);
                    stmt.setString(pos2++, mailAccount.getPrimaryAddress());
                    personal = mailAccount.getPersonal();
                    if (RdbMailAccountStorage.isEmpty(personal)) {
                        stmt.setNull(pos2++, 12);
                    } else {
                        stmt.setString(pos2++, personal);
                    }
                    replyTo = mailAccount.getReplyTo();
                    if (RdbMailAccountStorage.isEmpty(replyTo)) {
                        stmt.setNull(pos2++, 12);
                    } else {
                        stmt.setString(pos2++, replyTo);
                    }
                    stmt.setLong(pos2++, contextId);
                    stmt.setLong(pos2++, accountId);
                    stmt.setLong(pos2++, userId);
                    stmt.executeUpdate();
                }
                if ((properties = mailAccount.getProperties()).containsKey("pop3.deletewt")) {
                    this.updateProperty(contextId, userId, accountId, "pop3.deletewt", properties.get("pop3.deletewt"), false, con);
                }
                if (properties.containsKey("pop3.expunge")) {
                    this.updateProperty(contextId, userId, accountId, "pop3.expunge", properties.get("pop3.expunge"), false, con);
                }
                if (properties.containsKey("pop3.refreshrate")) {
                    this.updateProperty(contextId, userId, accountId, "pop3.refreshrate", properties.get("pop3.refreshrate"), false, con);
                }
                if (properties.containsKey("pop3.storage")) {
                    this.updateProperty(contextId, userId, accountId, "pop3.storage", properties.get("pop3.storage"), false, con);
                }
                if (properties.containsKey("pop3.path")) {
                    this.updateProperty(contextId, userId, accountId, "pop3.path", properties.get("pop3.path"), false, con);
                }
                if (null != (transportAuth = mailAccount.getTransportAuth())) {
                    this.updateProperty(contextId, userId, mailAccount.getId(), "transport.auth", transportAuth.getId(), true, con);
                }
                MailAccount retval = this.getMailAccount(accountId, userId, contextId, con);
                con.commit();
                rollback = false;
                if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(userId, contextId, con)) {
                    management.createUnifiedINBOX(userId, contextId, con);
                }
                mailAccount2 = retval;
                if (!rollback) break block28;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(null, stmt);
                    DBUtils.autocommit(con);
                    Database.back(contextId, true, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(null, stmt);
        DBUtils.autocommit(con);
        Database.back(contextId, true, con);
        return mailAccount2;
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int userId, Context context, Session session, Connection con) throws OXException {
        UnifiedInboxManagement management;
        int id;
        int contextId = context.getContextId();
        boolean isUnifiedMail = mailAccount.getMailProtocol().startsWith(UnifiedInboxManagement.PROTOCOL_UNIFIED_INBOX, 0);
        String primaryAddress = mailAccount.getPrimaryAddress();
        String name = mailAccount.getName();
        if (!isUnifiedMail) {
            List<IPRange> ranges = MailProperties.getInstance().getAccountBlacklistRanges();
            if (!mailAccount.isDefaultFlag() && null != ranges && !ranges.isEmpty()) {
                this.checkHostIfBlacklisted(mailAccount.getMailServer(), ranges);
                this.checkHostIfBlacklisted(mailAccount.getTransportServer(), ranges);
            }
            if (-1 != this.getByPrimaryAddress(primaryAddress, userId, contextId, con)) {
                throw MailAccountExceptionCodes.CONFLICT_ADDR.create(primaryAddress, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            this.checkDuplicateMailAccount(mailAccount, null, userId, contextId, con);
            this.checkDuplicateTransportAccount(mailAccount, null, userId, contextId, con);
            if (!RdbMailAccountStorage.isValid(name)) {
                throw MailAccountExceptionCodes.INVALID_NAME.create(name);
            }
        }
        RdbMailAccountStorage.dropPOP3StorageFolders(userId, contextId);
        if (mailAccount.isDefaultFlag()) {
            try {
                this.getDefaultMailAccount(userId, contextId, con);
                throw MailAccountExceptionCodes.NO_DUPLICATE_DEFAULT.create();
            }
            catch (OXException e) {
                LOG.trace("", (Throwable)e);
                id = 0;
            }
        } else {
            try {
                id = IDGenerator.getId(context, 1132, con);
            }
            catch (SQLException e) {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
        }
        PreparedStatement stmt = null;
        try {
            TransportAuth transportAuth;
            Map<String, String> properties;
            stmt = con.prepareStatement("INSERT INTO user_mail_account (cid, id, user, name, url, login, password, primary_addr, default_flag, trash, sent, drafts, spam, confirmed_spam, confirmed_ham, spam_handler, unified_inbox, trash_fullname, sent_fullname, drafts_fullname, spam_fullname, confirmed_spam_fullname, confirmed_ham_fullname, personal, replyTo, archive, archive_fullname) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            String encryptedPassword = session == null ? null : this.encrypt(mailAccount.getPassword(), session);
            int pos = 1;
            stmt.setLong(pos++, contextId);
            stmt.setLong(pos++, id);
            stmt.setLong(pos++, userId);
            stmt.setString(pos++, name);
            stmt.setString(pos++, mailAccount.generateMailServerURL());
            stmt.setString(pos++, mailAccount.getLogin());
            if (mailAccount.isDefaultFlag()) {
                stmt.setNull(pos++, 12);
            } else {
                RdbMailAccountStorage.setOptionalString(stmt, pos++, encryptedPassword);
            }
            stmt.setString(pos++, primaryAddress);
            stmt.setInt(pos++, mailAccount.isDefaultFlag() ? 1 : 0);
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getTrash());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSent());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getDrafts());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedSpam());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getConfirmedHam());
            String sh = mailAccount.getSpamHandler();
            if (null == sh) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, sh);
            }
            stmt.setInt(pos++, mailAccount.isUnifiedINBOXEnabled() ? 1 : 0);
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()));
            RdbMailAccountStorage.setOptionalString(stmt, pos++, DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()));
            String personal = mailAccount.getPersonal();
            if (RdbMailAccountStorage.isEmpty(personal)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, personal);
            }
            String replyTo = mailAccount.getReplyTo();
            if (RdbMailAccountStorage.isEmpty(replyTo)) {
                stmt.setNull(pos++, 12);
            } else {
                stmt.setString(pos++, replyTo);
            }
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getArchive());
            RdbMailAccountStorage.setOptionalString(stmt, pos++, mailAccount.getArchiveFullname());
            stmt.executeUpdate();
            String transportURL = mailAccount.generateTransportServerURL();
            if (null != transportURL) {
                stmt.close();
                String encryptedTransportPassword = session == null ? null : this.encrypt(mailAccount.getTransportPassword(), session);
                stmt = con.prepareStatement("INSERT INTO user_transport_account (cid, id, user, name, url, login, password, send_addr, default_flag, personal, replyTo) VALUES (?,?,?,?,?,?,?,?,?,?,?)");
                int pos2 = 1;
                stmt.setLong(pos2++, contextId);
                stmt.setLong(pos2++, id);
                stmt.setLong(pos2++, userId);
                stmt.setString(pos2++, name);
                stmt.setString(pos2++, transportURL);
                if (null == mailAccount.getTransportLogin()) {
                    stmt.setString(pos2++, "");
                } else {
                    stmt.setString(pos2++, mailAccount.getTransportLogin());
                }
                if (mailAccount.isDefaultFlag()) {
                    stmt.setNull(pos2++, 12);
                } else {
                    RdbMailAccountStorage.setOptionalString(stmt, pos2++, encryptedTransportPassword);
                }
                stmt.setString(pos2++, primaryAddress);
                stmt.setInt(pos2++, mailAccount.isDefaultFlag() ? 1 : 0);
                personal = mailAccount.getPersonal();
                if (RdbMailAccountStorage.isEmpty(personal)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, personal);
                }
                replyTo = mailAccount.getReplyTo();
                if (RdbMailAccountStorage.isEmpty(replyTo)) {
                    stmt.setNull(pos2++, 12);
                } else {
                    stmt.setString(pos2++, replyTo);
                }
                stmt.executeUpdate();
            }
            if (!(properties = mailAccount.getProperties()).isEmpty()) {
                if (properties.containsKey("pop3.deletewt")) {
                    this.updateProperty(contextId, userId, id, "pop3.deletewt", properties.get("pop3.deletewt"), false, con);
                }
                if (properties.containsKey("pop3.expunge")) {
                    this.updateProperty(contextId, userId, id, "pop3.expunge", properties.get("pop3.expunge"), false, con);
                }
                if (properties.containsKey("pop3.refreshrate")) {
                    this.updateProperty(contextId, userId, id, "pop3.refreshrate", properties.get("pop3.refreshrate"), false, con);
                }
                if (properties.containsKey("pop3.storage")) {
                    this.updateProperty(contextId, userId, id, "pop3.storage", properties.get("pop3.storage"), false, con);
                }
                if (properties.containsKey("pop3.path")) {
                    this.updateProperty(contextId, userId, id, "pop3.path", properties.get("pop3.path"), false, con);
                }
            }
            if (null != (transportAuth = mailAccount.getTransportAuth())) {
                this.updateProperty(contextId, userId, id, "transport.auth", transportAuth.getId(), true, con);
            }
        }
        catch (SQLException e) {
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.closeSQLStuff(null, stmt);
        }
        if (mailAccount.isUnifiedINBOXEnabled() && null != (management = ServerServiceRegistry.getInstance().getService(UnifiedInboxManagement.class)) && !management.exists(userId, contextId, con)) {
            management.createUnifiedINBOX(userId, contextId, con);
        }
        return id;
    }

    private void checkHostIfBlacklisted(String host, List<IPRange> ranges) throws OXException {
        if (!RdbMailAccountStorage.isEmpty(host)) {
            boolean allowed = true;
            try {
                String hostAddress = InetAddress.getByName(host).getHostAddress();
                int j = ranges.size();
                while (allowed && j-- > 0) {
                    IPRange ipRange = ranges.get(j);
                    if (!ipRange.contains(hostAddress)) continue;
                    allowed = false;
                }
            }
            catch (Exception e) {
                LOG.warn("Could not check host name \"" + host + "\" against IP range black-list", (Throwable)e);
            }
            if (!allowed) {
                throw MailAccountExceptionCodes.BLACKLISTED_SERVER.create(host);
            }
        }
    }

    @Override
    public int insertMailAccount(MailAccountDescription mailAccount, int userId, Context context, Session session) throws OXException {
        int retval;
        int contextId = context.getContextId();
        Connection con = Database.get(contextId, true);
        try {
            con.setAutoCommit(false);
            retval = this.insertMailAccount(mailAccount, userId, context, session, con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            DBUtils.rollback(con);
            throw e;
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getByHostNames(Collection<String> hostNames, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            int[] nArray = this.getByHostNames(hostNames, userId, contextId, con);
            return nArray;
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    private int[] getByHostNames(Collection<String> hostNames, int userId, int contextId, Connection con) throws OXException {
        int[] nArray;
        TIntArrayList ids;
        ResultSet result;
        PreparedStatement stmt;
        block10: {
            HashSet<String> set;
            block9: {
                if (null == hostNames || hostNames.isEmpty()) {
                    return new int[0];
                }
                set = new HashSet<String>(hostNames.size());
                for (String hostName : hostNames) {
                    set.add(hostName.toLowerCase(Locale.ENGLISH));
                }
                stmt = null;
                result = null;
                stmt = con.prepareStatement("SELECT id, url FROM user_mail_account WHERE cid = ? AND user = ? ORDER BY id");
                stmt.setLong(1, contextId);
                stmt.setLong(2, userId);
                result = stmt.executeQuery();
                if (result.next()) break block9;
                int[] nArray2 = new int[]{};
                DBUtils.closeSQLStuff(result, stmt);
                return nArray2;
            }
            CustomMailAccount tmp = new CustomMailAccount();
            ids = new TIntArrayList(6);
            do {
                tmp.parseMailServerURL(result.getString(2));
                if (!set.contains(tmp.getMailServer().toLowerCase(Locale.ENGLISH))) continue;
                ids.add(result.getInt(1));
            } while (result.next());
            if (!ids.isEmpty()) break block10;
            int[] nArray3 = new int[]{};
            DBUtils.closeSQLStuff(result, stmt);
            return nArray3;
        }
        try {
            int[] array = ids.toArray();
            Arrays.sort(array);
            nArray = array;
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getByPrimaryAddress(String primaryAddress, int userId, int contextId) throws OXException {
        Connection con = Database.get(contextId, false);
        try {
            int n = this.getByPrimaryAddress(primaryAddress, userId, contextId, con);
            return n;
        }
        finally {
            Database.back(contextId, false, con);
        }
    }

    private int getByPrimaryAddress(String primaryAddress, int userId, int contextId, Connection con) throws OXException {
        int n;
        ResultSet result;
        PreparedStatement stmt;
        block6: {
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id FROM user_mail_account WHERE cid = ? AND primary_addr = ? AND user = ?");
            stmt.setLong(1, contextId);
            stmt.setString(2, primaryAddress);
            stmt.setLong(3, userId);
            result = stmt.executeQuery();
            if (result.next()) break block6;
            int n2 = -1;
            DBUtils.closeSQLStuff(result, stmt);
            return n2;
        }
        try {
            int id = result.getInt(1);
            if (result.next()) {
                throw MailAccountExceptionCodes.CONFLICT_ADDR.create(primaryAddress, Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            }
            n = id;
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return n;
    }

    private void checkDuplicateMailAccount(MailAccountDescription mailAccount, TIntSet excepts, int userId, int contextId, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        String server;
        block9: {
            server = mailAccount.getMailServer();
            if (RdbMailAccountStorage.isEmpty(server)) {
                return;
            }
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id, url, login FROM user_mail_account WHERE cid = ? AND user = ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, userId);
            result = stmt.executeQuery();
            if (result.next()) break block9;
            DBUtils.closeSQLStuff(result, stmt);
            return;
        }
        try {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(IDNA.toASCII((String)server));
            }
            catch (UnknownHostException e) {
                LOG.warn("", (Throwable)e);
                addr = null;
            }
            int port = mailAccount.getMailPort();
            String login = mailAccount.getLogin();
            do {
                int id = (int)result.getLong(1);
                if (null != excepts && excepts.contains(id)) continue;
                AbstractMailAccount current = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
                String url = result.getString(2);
                if (null == url) continue;
                current.parseMailServerURL(url);
                if (!RdbMailAccountStorage.checkMailServer(server, addr, current) || !RdbMailAccountStorage.checkProtocol(mailAccount.getMailProtocol(), current.getMailProtocol()) || current.getMailPort() != port || null == login || !login.equals(result.getString(3))) continue;
                throw MailAccountExceptionCodes.DUPLICATE_MAIL_ACCOUNT.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    private static boolean checkMailServer(String server, InetAddress addr, AbstractMailAccount current) {
        String mailServer = current.getMailServer();
        if (RdbMailAccountStorage.isEmpty(mailServer)) {
            return false;
        }
        if (null == addr) {
            return server.equalsIgnoreCase(mailServer);
        }
        try {
            return addr.equals(InetAddress.getByName(IDNA.toASCII((String)mailServer)));
        }
        catch (UnknownHostException e) {
            LOG.warn("", (Throwable)e);
            return server.equalsIgnoreCase(mailServer);
        }
    }

    private static boolean checkProtocol(String protocol1, String protocol2) {
        if (RdbMailAccountStorage.isEmpty(protocol1) || RdbMailAccountStorage.isEmpty(protocol2)) {
            return false;
        }
        return protocol1.equalsIgnoreCase(protocol2);
    }

    private void checkDuplicateTransportAccount(MailAccountDescription mailAccount, TIntSet excepts, int userId, int contextId, Connection con) throws OXException {
        ResultSet result;
        PreparedStatement stmt;
        String server;
        block10: {
            server = mailAccount.getTransportServer();
            if (RdbMailAccountStorage.isEmpty(server)) {
                return;
            }
            stmt = null;
            result = null;
            stmt = con.prepareStatement("SELECT id, url, login FROM user_transport_account WHERE cid = ? AND user = ?");
            stmt.setLong(1, contextId);
            stmt.setLong(2, userId);
            result = stmt.executeQuery();
            if (result.next()) break block10;
            DBUtils.closeSQLStuff(result, stmt);
            return;
        }
        try {
            InetAddress addr;
            try {
                addr = InetAddress.getByName(IDNA.toASCII((String)server));
            }
            catch (UnknownHostException e) {
                LOG.warn("", (Throwable)e);
                addr = null;
            }
            int port = mailAccount.getTransportPort();
            String login = mailAccount.getTransportLogin();
            if (null == login) {
                login = mailAccount.getLogin();
            }
            do {
                int id = (int)result.getLong(1);
                if (null != excepts && excepts.contains(id)) continue;
                AbstractMailAccount current = 0 == id ? new DefaultMailAccount() : new CustomMailAccount();
                current.parseTransportServerURL(result.getString(2));
                if (!RdbMailAccountStorage.checkTransportServer(server, addr, current) || !RdbMailAccountStorage.checkProtocol(mailAccount.getTransportProtocol(), current.getTransportProtocol()) || current.getTransportPort() != port || null == login || !login.equals(result.getString(3))) continue;
                throw MailAccountExceptionCodes.DUPLICATE_TRANSPORT_ACCOUNT.create(Autoboxing.I((int)userId), Autoboxing.I((int)contextId));
            } while (result.next());
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
    }

    private static boolean checkTransportServer(String server, InetAddress addr, AbstractMailAccount current) {
        String transportServer = current.getTransportServer();
        if (RdbMailAccountStorage.isEmpty(transportServer)) {
            return false;
        }
        if (null == addr) {
            return server.equalsIgnoreCase(transportServer);
        }
        try {
            return addr.equals(InetAddress.getByName(IDNA.toASCII((String)transportServer)));
        }
        catch (UnknownHostException e) {
            LOG.warn("", (Throwable)e);
            return server.equalsIgnoreCase(transportServer);
        }
    }

    @Override
    public MailAccount getTransportAccountForID(int id, int userId, int contextId) throws OXException {
        MailAccount account = this.getMailAccount(id, userId, contextId);
        if (null == account.getTransportServer()) {
            return this.getDefaultMailAccount(userId, contextId);
        }
        return account;
    }

    @Override
    public boolean hasAccounts(Session session) throws OXException {
        boolean bl;
        int userId;
        int contextId;
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block8: {
            con = null;
            stmt = null;
            rs = null;
            contextId = session.getContextId();
            userId = session.getUserId();
            con = Database.get(contextId, false);
            stmt = con.prepareStatement("SELECT 1 FROM user_mail_account WHERE cid = ? AND user = ? AND id > 0 LIMIT 1");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (!rs.next()) break block8;
            boolean bl2 = true;
            DBUtils.closeSQLStuff(rs, stmt);
            if (con != null) {
                Database.back(contextId, false, con);
            }
            return bl2;
        }
        try {
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = con.prepareStatement("SELECT 1 FROM user_transport_account WHERE cid = ? AND user = ? AND id > 0 LIMIT 1");
            stmt.setInt(1, contextId);
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (SQLException e) {
            try {
                throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (con != null) {
                    Database.back(contextId, false, con);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (con != null) {
            Database.back(contextId, false, con);
        }
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void migratePasswords(String oldSecret, String newSecret, Session session) throws OXException {
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int contextId;
        block17: {
            contextId = session.getContextId();
            int userId = session.getUserId();
            this.cleanUp(userId, contextId);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            try {
                String transcribed;
                String decrypted;
                SetableSession setableSession;
                String login;
                int id;
                String password;
                con = Database.get(contextId, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_mail_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                SecretEncryptionService encryptionService = ServerServiceRegistry.getInstance().getService(SecretEncryptionFactoryService.class).createService(STRATEGY);
                if (null == encryptionService) {
                    throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{SecretEncryptionService.class.getName()});
                }
                CustomMailAccount parser = new CustomMailAccount();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    login = rs.getString(3);
                    parser.parseMailServerURL(rs.getString(4));
                    String mailServer = parser.getMailServer();
                    try {
                        encryptionService.decrypt(session, password, (Object)new GenericProperty(id, session, login, mailServer));
                    }
                    catch (OXException x) {
                        setableSession = SetableSessionFactory.getFactory().setableSessionFor(session);
                        setableSession.setPassword(oldSecret);
                        decrypted = encryptionService.decrypt((Session)setableSession, password, (Object)new GenericProperty(id, (Session)setableSession, login, mailServer));
                        transcribed = encryptionService.encrypt(session, decrypted);
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("UPDATE user_mail_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(2, contextId);
                            updateStmt.setInt(4, userId);
                        }
                        updateStmt.setString(1, transcribed);
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_transport_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    login = rs.getString(3);
                    parser.parseTransportServerURL(rs.getString(4));
                    String transportServer = parser.getTransportServer();
                    try {
                        encryptionService.decrypt(session, password, (Object)new GenericProperty(id, session, login, transportServer));
                    }
                    catch (OXException x) {
                        setableSession = SetableSessionFactory.getFactory().setableSessionFor(session);
                        setableSession.setPassword(oldSecret);
                        decrypted = encryptionService.decrypt((Session)setableSession, password, (Object)new GenericProperty(id, (Session)setableSession, login, transportServer));
                        transcribed = encryptionService.encrypt(session, decrypted);
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("UPDATE user_transport_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(2, contextId);
                            updateStmt.setInt(4, userId);
                        }
                        updateStmt.setString(1, transcribed);
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block17;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con == null) throw throwable;
                    DBUtils.autocommit(con);
                    Database.back(contextId, true, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con == null) return;
        DBUtils.autocommit(con);
        Database.back(contextId, true, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cleanUp(String secret, Session session) throws OXException {
        boolean modified;
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int contextId;
        block18: {
            int userId = session.getUserId();
            contextId = session.getContextId();
            this.cleanUp(userId, contextId);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            modified = false;
            try {
                int id;
                String password;
                con = Database.get(contextId, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_mail_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("UPDATE user_mail_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(2, contextId);
                            updateStmt.setInt(4, userId);
                        }
                        updateStmt.setString(1, "");
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    modified = true;
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_transport_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("UPDATE user_transport_account SET password = ?  WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(2, contextId);
                            updateStmt.setInt(4, userId);
                        }
                        updateStmt.setString(1, "");
                        updateStmt.setInt(3, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    modified = false;
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block18;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con == null) throw throwable;
                    DBUtils.autocommit(con);
                    if (modified) {
                        Database.getDatabaseService().backWritable(contextId, con);
                        throw throwable;
                    }
                    Database.getDatabaseService().backWritableAfterReading(contextId, con);
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con == null) return;
        DBUtils.autocommit(con);
        if (modified) {
            Database.getDatabaseService().backWritable(contextId, con);
            return;
        }
        Database.getDatabaseService().backWritableAfterReading(contextId, con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void removeUnrecoverableItems(String secret, Session session) throws OXException {
        ResultSet rs;
        Statement updateStmt;
        PreparedStatement selectStmt;
        Connection con;
        int contextId;
        int userId;
        block18: {
            userId = session.getUserId();
            contextId = session.getContextId();
            this.cleanUp(userId, contextId);
            con = null;
            selectStmt = null;
            updateStmt = null;
            rs = null;
            boolean rollback = false;
            try {
                int id;
                String password;
                con = Database.get(contextId, true);
                con.setAutoCommit(false);
                rollback = true;
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_mail_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("DELETE FROM user_mail_account WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(1, contextId);
                            updateStmt.setInt(3, userId);
                        }
                        updateStmt.setInt(2, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                DBUtils.closeSQLStuff(rs, selectStmt);
                selectStmt = con.prepareStatement("SELECT id, password, login, url FROM user_transport_account WHERE cid = ? AND user = ?");
                selectStmt.setInt(1, contextId);
                selectStmt.setInt(2, userId);
                rs = selectStmt.executeQuery();
                while (rs.next()) {
                    password = rs.getString(2);
                    if (RdbMailAccountStorage.isEmpty(password) || (id = rs.getInt(1)) == 0) continue;
                    try {
                        MailPasswordUtil.decrypt(password, secret);
                    }
                    catch (GeneralSecurityException x) {
                        if (null == updateStmt) {
                            updateStmt = con.prepareStatement("DELETE FROM user_transport_account WHERE cid = ? AND id = ? AND user = ?");
                            updateStmt.setInt(1, contextId);
                            updateStmt.setInt(3, userId);
                        }
                        updateStmt.setInt(2, id);
                        updateStmt.addBatch();
                    }
                }
                if (null != updateStmt) {
                    updateStmt.executeBatch();
                    DBUtils.closeSQLStuff(updateStmt);
                    updateStmt = null;
                }
                con.commit();
                rollback = false;
                if (!rollback) break block18;
            }
            catch (SQLException e) {
                try {
                    throw MailAccountExceptionCodes.SQL_ERROR.create(e, e.getMessage());
                    catch (RuntimeException e2) {
                        throw MailAccountExceptionCodes.UNEXPECTED_ERROR.create(e2, e2.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    if (rollback) {
                        DBUtils.rollback(con);
                    }
                    DBUtils.closeSQLStuff(rs, selectStmt);
                    DBUtils.closeSQLStuff(updateStmt);
                    if (con != null) {
                        DBUtils.autocommit(con);
                        Database.back(contextId, true, con);
                    }
                    throw throwable;
                }
            }
            DBUtils.rollback(con);
        }
        DBUtils.closeSQLStuff(rs, selectStmt);
        DBUtils.closeSQLStuff(updateStmt);
        if (con != null) {
            DBUtils.autocommit(con);
            Database.back(contextId, true, con);
        }
        this.cleanUp(userId, contextId);
    }

    private void cleanUp(int userId, int contextId) {
        Session session;
        SessiondService service = ServerServiceRegistry.getInstance().getService(SessiondService.class);
        if (null != service && null != (session = service.getAnyActiveSessionForUser(userId, contextId))) {
            try {
                int[] ids;
                IMailAccessCache mac = MailAccess.getMailAccessCache();
                for (int id : ids = this.getUserMailAccountIDs(userId, contextId)) {
                    while (mac.removeMailAccess(session, id) != null) {
                    }
                }
            }
            catch (Exception exc) {
                LOG.error("Unable to clear cached mail accesses.", (Throwable)exc);
            }
        }
    }

    private String encrypt(String toCrypt, Session session) throws OXException {
        if (null == toCrypt) {
            return null;
        }
        SecretEncryptionService encryptionService = RdbMailAccountStorage.getService(SecretEncryptionFactoryService.class).createService(STRATEGY);
        return encryptionService.encrypt(session, toCrypt);
    }

    private static <S> S getService(Class<? extends S> clazz) {
        return ServerServiceRegistry.getInstance().getService(clazz);
    }

    private static boolean disableForeignKeyChecks(Connection con) {
        if (null == con) {
            return false;
        }
        try {
            DBUtils.disableMysqlForeignKeyChecks(con);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void enableForeignKeyChecks(Connection con) throws SQLException {
        if (null == con) {
            return;
        }
        DBUtils.enableMysqlForeignKeyChecks(con);
    }

    private static void setOptionalString(PreparedStatement stmt, int pos, String string) throws SQLException {
        stmt.setString(pos, null == string ? "" : string);
    }

    private static String getOptionalString(String string) {
        return null == string || 0 == string.length() ? null : string;
    }

    private static boolean isEmpty(String string) {
        return Strings.isEmpty((String)string);
    }

    private static boolean isValid(String name) {
        return null != name && 0 != name.length();
    }

    static {
        TIntObjectHashMap map = new TIntObjectHashMap(8);
        map.put(5, (Object)"confirmed_ham_fullname");
        map.put(4, (Object)"confirmed_spam_fullname");
        map.put(0, (Object)"drafts_fullname");
        map.put(1, (Object)"sent_fullname");
        map.put(2, (Object)"spam_fullname");
        map.put(3, (Object)"trash_fullname");
        INDEX_2_COL = map;
        String quote1 = Pattern.quote("Cannot delete or update a parent row: a foreign key constraint fails (`");
        String quote2 = Pattern.quote("`, CONSTRAINT `");
        String quote3 = Pattern.quote("` FOREIGN KEY (");
        String quote4 = Pattern.quote(") REFERENCES `user_mail_account` (`cid`, `user`, `id`))");
        PATTERN_CONSTRAINT_VIOLATION = Pattern.compile(quote1 + "([^`]+)" + quote2 + "[^`]+" + quote3 + "([^)]+)" + quote4, 2);
        DEFAULT = Attribute.DEFAULT;
        DEFAULT_FULL_NAMES = Attribute.DEFAULT_FULL_NAMES;
        PRIMARY_EDITABLE = EnumSet.of(Attribute.UNIFIED_INBOX_ENABLED_LITERAL, Attribute.PERSONAL_LITERAL, Attribute.REPLY_TO_LITERAL, Attribute.ARCHIVE_LITERAL, Attribute.ARCHIVE_FULLNAME_LITERAL);
        CHARS_INVALID = new char[]{'\t', '\n', '\f', '\r', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '`', '{', '|', '}', '~'};
    }
}

