/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.mail.MailExceptionCode;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.json.JSONBinary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructureJSONBinary
implements JSONBinary {
    private static final Logger LOG = LoggerFactory.getLogger(StructureJSONBinary.class);
    private final ThresholdFileHolder tfh;
    private final InputStream in;

    public StructureJSONBinary(InputStream in) throws OXException {
        this(in, true);
    }

    public StructureJSONBinary(InputStream in, boolean copy) throws OXException {
        if (null == in) {
            NullPointerException e = new NullPointerException("Input stream is null.");
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        if (copy) {
            this.in = null;
            try {
                ThresholdFileHolder tfh;
                this.tfh = tfh = new ThresholdFileHolder();
                tfh.write(in);
            }
            catch (RuntimeException e) {
                throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
            finally {
                Streams.close((Closeable)in);
            }
        } else {
            this.tfh = null;
            this.in = in;
        }
    }

    public String toString() {
        try {
            int read;
            InputStream in = this.in;
            if (null == in) {
                in = this.tfh.getStream();
            }
            ByteArrayOutputStream bout = Streams.newByteArrayOutputStream((int)8192);
            Base64OutputStream base64Out = new Base64OutputStream((OutputStream)bout, true, -1, null);
            int blen = 2048;
            byte[] buf = new byte[2048];
            while ((read = in.read(buf, 0, 2048)) > 0) {
                base64Out.write(buf, 0, read);
            }
            base64Out.flush();
            base64Out.close();
            return bout.toString("US-ASCII");
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
            return "";
        }
    }

    public InputStream getBinary() {
        ThresholdFileHolder tfh = this.tfh;
        if (null == tfh) {
            return this.in;
        }
        try {
            return tfh.getStream();
        }
        catch (OXException e) {
            LOG.error("", (Throwable)e);
            return Streams.EMPTY_INPUT_STREAM;
        }
    }

    public long length() {
        ThresholdFileHolder tfh = this.tfh;
        return null == tfh ? -1L : tfh.getLength();
    }
}

