/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.search;

import com.openexchange.exception.OXException;
import com.openexchange.mail.MailField;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.search.ComparablePattern;
import com.openexchange.mail.search.ComparisonType;
import com.openexchange.mail.search.SearchTerm;
import com.openexchange.mail.search.SearchTermVisitor;
import java.util.Collection;
import java.util.Date;
import javax.mail.FetchProfile;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.slf4j.LoggerFactory;

public final class ReceivedDateTerm
extends SearchTerm<ComparablePattern<Date>> {
    private static final long serialVersionUID = -3566780904070234005L;
    private final ComparablePattern<Date> pattern;

    public ReceivedDateTerm(final ComparisonType comparisonType, final Date receivedDate) {
        this.pattern = new ComparablePattern<Date>(){

            @Override
            public ComparisonType getComparisonType() {
                return comparisonType;
            }

            @Override
            public Date getPattern() {
                return receivedDate;
            }
        };
    }

    @Override
    public void accept(SearchTermVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ComparablePattern<Date> getPattern() {
        return this.pattern;
    }

    @Override
    public void addMailField(Collection<MailField> col) {
        col.add(MailField.RECEIVED_DATE);
    }

    @Override
    public boolean matches(MailMessage mailMessage) {
        Date receivedDate = mailMessage.getReceivedDate();
        if (null == receivedDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        switch (comparisonType) {
            case EQUALS: {
                return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
            }
            case LESS_THAN: {
                return ((Date)pattern.getPattern()).getTime() > receivedDate.getTime();
            }
            case LESS_EQUALS: {
                return ((Date)pattern.getPattern()).getTime() >= receivedDate.getTime();
            }
            case GREATER_THAN: {
                return ((Date)pattern.getPattern()).getTime() < receivedDate.getTime();
            }
            case GREATER_EQUALS: {
                return ((Date)pattern.getPattern()).getTime() <= receivedDate.getTime();
            }
        }
        return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
    }

    @Override
    public boolean matches(Message msg) throws OXException {
        Date receivedDate;
        try {
            receivedDate = msg.getReceivedDate();
        }
        catch (MessagingException e) {
            LoggerFactory.getLogger(ReceivedDateTerm.class).warn("Error during search.", (Throwable)e);
            return false;
        }
        if (null == receivedDate) {
            return false;
        }
        Object pattern = this.getPattern();
        ComparisonType comparisonType = pattern.getComparisonType();
        switch (comparisonType) {
            case EQUALS: {
                return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
            }
            case LESS_THAN: {
                return ((Date)pattern.getPattern()).getTime() > receivedDate.getTime();
            }
            case LESS_EQUALS: {
                return ((Date)pattern.getPattern()).getTime() >= receivedDate.getTime();
            }
            case GREATER_THAN: {
                return ((Date)pattern.getPattern()).getTime() < receivedDate.getTime();
            }
            case GREATER_EQUALS: {
                return ((Date)pattern.getPattern()).getTime() <= receivedDate.getTime();
            }
        }
        return ((Date)pattern.getPattern()).getTime() == receivedDate.getTime();
    }

    @Override
    public javax.mail.search.SearchTerm getJavaMailSearchTerm() {
        Object pattern = this.getPattern();
        return new javax.mail.search.ReceivedDateTerm(pattern.getComparisonType().getType(), (Date)pattern.getPattern());
    }

    @Override
    public javax.mail.search.SearchTerm getNonWildcardJavaMailSearchTerm() {
        return this.getJavaMailSearchTerm();
    }

    @Override
    public void contributeTo(FetchProfile fetchProfile) {
        if (!fetchProfile.contains(FetchProfile.Item.ENVELOPE)) {
            fetchProfile.add(FetchProfile.Item.ENVELOPE);
        }
    }
}

