/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.Category;
import com.openexchange.exception.DisplayableOXExceptionCode;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum MimeMailExceptionCode implements DisplayableOXExceptionCode
{
    LOGIN_FAILED("There was an issue in authenticating your E-Mail password. This may be due to a recent password change. To continue please log out now and then log back in with your most current password. (server=%1$s | user=%2$s)", CATEGORY_PERMISSION_DENIED, 1000, "There was an issue while authenticating. This may be due to a recent password change. To continue please log out and log back in with your most current password."),
    INVALID_CREDENTIALS("Wrong or missing login data to access mail server %1$s. Error message from mail server: %2$s", CATEGORY_PERMISSION_DENIED, 1001, "The provided login information seem to be wrong. Please try again."),
    INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.INVALID_CREDENTIALS.detailNumber, "The provided login information to access mail server %1$s seem to be wrong. Please try again."),
    FOLDER_NOT_FOUND("Mail folder \"%1$s\" could not be found.", CATEGORY_USER_INPUT, 1002, "Mail folder \"%1$s\" could not be found."),
    FOLDER_NOT_FOUND_EXT("Mail folder \"%1$s\" could not be found on mail server %2$s with login %3$s (user=%4$s, context=%5$s).", CATEGORY_USER_INPUT, MimeMailExceptionCode.FOLDER_NOT_FOUND.detailNumber, "Mail folder \"%1$s\" could not be found on mail server %2$s."),
    FOLDER_CLOSED("Folder \"%1$s\" has been closed. Probably your request took too long.", CATEGORY_ERROR, 1003, "Folder \"%1$s\" has been closed. Probably your request took too long."),
    FOLDER_CLOSED_EXT("Folder \"%1$s\" has been closed on mail server %2$s with login %3$s (user=%4$s, context=%5$s). Probably your request took too long.", CATEGORY_ERROR, MimeMailExceptionCode.FOLDER_CLOSED.detailNumber, "Folder \"%1$s\" has been closed on mail server %2$s. Probably your request took too long."),
    ILLEGAL_WRITE("Illegal write attempt: %1$s", CATEGORY_ERROR, 1004),
    MESSAGE_REMOVED("Mail(s) %1$s could not be found in folder %2$s", CATEGORY_USER_INPUT, 32, "Mail(s) could not be found in the given folder."),
    METHOD_NOT_SUPPORTED("Method not supported: %1$s", CATEGORY_ERROR, 1006),
    NO_SUCH_PROVIDER("Session attempts to instantiate a provider that does not exist: %1$s", CATEGORY_ERROR, 1007),
    INVALID_EMAIL_ADDRESS("Invalid E-Mail address %1$s", CATEGORY_USER_INPUT, 1008, "The given E-Mail address \"%1$s\" is invalid."),
    PARSE_ERROR("Wrong message header: %1$s", CATEGORY_ERROR, 1009),
    READ_ONLY_FOLDER("An attempt was made to open a read-only folder with read-write \"%1$s\"", CATEGORY_PERMISSION_DENIED, 1010, "You do not have the appropriate permissions to change the content of folder \"%1$s\"."),
    READ_ONLY_FOLDER_EXT("An attempt was made to open a read-only folder with read-write \"%1$s\" on mail server %2$s with login %3$s (user=%4$s, context=%5$s)", CATEGORY_PERMISSION_DENIED, 1010, "You do not have the appropriate permissions to change the content of folder \"%1$s\" on mail server %2$s."),
    SEARCH_ERROR("Invalid search expression: %1$s", CATEGORY_USER_INPUT, 1011, "The search expression \"%1$s\" you entered is invalid."),
    MESSAGE_TOO_LARGE("Message could not be sent because it is too large", CATEGORY_USER_INPUT, 1012, "Message could not be sent because it is too large."),
    MESSAGE_TOO_LARGE_EXT("Message could not be sent because it is too large (%1$s)", CATEGORY_USER_INPUT, 1012, "Message could not be sent because it is too large (%1$s)."),
    SEND_FAILED("Message could not be sent to the following recipients: %1$s", CATEGORY_USER_INPUT, 1013, "Message could not be sent to the following recipients: %1$s."),
    SEND_FAILED_EXT("Message could not be sent to the following recipients: %1$s (%2$s)", CATEGORY_USER_INPUT, 1013, "Message could not be sent to the following recipients: %1$s (%2$s)"),
    STORE_CLOSED("Lost connection to mail server.", CATEGORY_SERVICE_DOWN, 1014, "Lost connection to mail server."),
    STORE_CLOSED_EXT("Connection closed to mail server %1$s with login %2$s (user=%3$s, context=%4$s).", MimeMailExceptionCode.STORE_CLOSED.category, MimeMailExceptionCode.STORE_CLOSED.detailNumber, "Connection closed to mail server %1$s."),
    BIND_ERROR("Could not bind connection to local port %1$s", CATEGORY_CONFIGURATION, 1015),
    CONNECT_ERROR("Connection was refused or timed out while attempting to connect to remote server %1$s for user %2$s.", CATEGORY_SERVICE_DOWN, 1016, "The connection to remote server %1$s was refused or timed out while attempting to connect."),
    CONNECTION_RESET("Connection was reset. Please try again.", CATEGORY_TRY_AGAIN, 1017),
    NO_ROUTE_TO_HOST("No route to host: server (%1$s) cannot be reached", CATEGORY_SERVICE_DOWN, 1018),
    PORT_UNREACHABLE("Port %1$s was unreachable on remote server", CATEGORY_CONFIGURATION, 1019),
    BROKEN_CONNECTION("Connection is broken due to a socket exception on remote server: %1$s", CATEGORY_SERVICE_DOWN, 1020),
    SOCKET_ERROR("A socket error occurred: %1$s", CATEGORY_ERROR, 1021),
    UNKNOWN_HOST("The IP address of host \"%1$s\" could not be determined", CATEGORY_CONFIGURATION, 1022),
    MESSAGING_ERROR("Messaging error: %1$s", CATEGORY_ERROR, 1023),
    QUOTA_EXCEEDED("The quota on mail server exceeded. Error message: %1$s", CATEGORY_CAPACITY, 1024, "The allowed quota on mail server exceeded."),
    QUOTA_EXCEEDED_EXT("The quota on mail server \"%1$s\" exceeded with login %2$s (user=%3$s, context=%4$s). Error message: %5$s", MimeMailExceptionCode.QUOTA_EXCEEDED.category, MimeMailExceptionCode.QUOTA_EXCEEDED.detailNumber, "The allowed quota on mail server \"%1$s\" exceeded."),
    COMMAND_FAILED("A command sent to mail server failed. Server response: %1$s", CATEGORY_ERROR, 1025),
    COMMAND_FAILED_EXT("A command failed on mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.COMMAND_FAILED.category, MimeMailExceptionCode.COMMAND_FAILED.detailNumber),
    BAD_COMMAND("Mail server indicates a bad command. Server response: %1$s", CATEGORY_ERROR, 1026),
    BAD_COMMAND_EXT("Bad command indicated by mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s", MimeMailExceptionCode.BAD_COMMAND.category, MimeMailExceptionCode.BAD_COMMAND.detailNumber),
    PROTOCOL_ERROR("Error in mail server protocol. Error message: %1$s", CATEGORY_ERROR, 1027),
    PROTOCOL_ERROR_EXT("Protocol error in data sent to the mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message: %5$s", MimeMailExceptionCode.PROTOCOL_ERROR.category, MimeMailExceptionCode.PROTOCOL_ERROR.detailNumber),
    SEND_FAILED_MSG_ERROR("Message could not be sent to the following recipients: %1$s", CATEGORY_ERROR, 1028, "Message could not be sent to the following recipients: %1$s."),
    SEND_FAILED_MSG_EXT_ERROR("Message could not be sent to the following recipients: %1$s (%2$s)", CATEGORY_ERROR, 1028, "Message could not be sent to the following recipients: %1$s (%2$s)"),
    MESSAGE_NOT_DISPLAYED("Message cannot be displayed.", CATEGORY_ERROR, 1029),
    TRANSPORT_INVALID_CREDENTIALS("Wrong or missing login data to access mail transport server %1$s. Error message from mail transport server: %2$s", CATEGORY_PERMISSION_DENIED, 1030, "Wrong or missing login data to access mail transport server %1$s. Please check associated account's settings/credentials."),
    TRANSPORT_INVALID_CREDENTIALS_EXT("Wrong or missing login data to access mail transport server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail transport server: %5$s", CATEGORY_PERMISSION_DENIED, MimeMailExceptionCode.TRANSPORT_INVALID_CREDENTIALS.detailNumber),
    PROCESSING_ERROR("Error processing mail server response. The administrator has been informed.", CATEGORY_ERROR, 1031),
    PROCESSING_ERROR_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed.", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber),
    IO_ERROR("An I/O error occurred: %1$s.", CATEGORY_ERROR, 8),
    IO_ERROR_EXT("I/O error \"%1$s\" occurred in communication with \"%2$s\" mail server for login %3$s (user=%4$s, context=%5$s).", CATEGORY_ERROR, 8),
    PROCESSING_ERROR_WE("Error processing mail server response. The administrator has been informed. Error message: %1$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber),
    PROCESSING_ERROR_WE_EXT("Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed. Error message: %5$s", CATEGORY_ERROR, MimeMailExceptionCode.PROCESSING_ERROR_WE.detailNumber),
    IN_USE_ERROR("That mailbox is already in use by another process. Please try again later. Error message: %1$s", CATEGORY_USER_INPUT, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber),
    IN_USE_ERROR_EXT("That mailbox is already in use by another process on %1$s mail server for login %2$s (user=%3$s, context=%4$s). Please try again later. Error message: %5$s", CATEGORY_USER_INPUT, MimeMailExceptionCode.PROCESSING_ERROR.detailNumber);

    private static final String LOGIN_FAILED_MSG = "There was an issue in authenticating your E-Mail password. This may be due to a recent password change. To continue please log out now and then log back in with your most current password. (server=%1$s | user=%2$s)";
    private static final String INVALID_CREDENTIALS_MSG = "Wrong or missing login data to access mail server %1$s. Error message from mail server: %2$s";
    private static final String INVALID_CREDENTIALS_EXT_MSG = "Wrong or missing login data to access mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail server: %5$s";
    private static final String FOLDER_NOT_FOUND_MSG = "Mail folder \"%1$s\" could not be found.";
    private static final String FOLDER_NOT_FOUND_EXT_MSG = "Mail folder \"%1$s\" could not be found on mail server %2$s with login %3$s (user=%4$s, context=%5$s).";
    private static final String FOLDER_CLOSED_MSG = "Folder \"%1$s\" has been closed. Probably your request took too long.";
    private static final String FOLDER_CLOSED_EXT_MSG = "Folder \"%1$s\" has been closed on mail server %2$s with login %3$s (user=%4$s, context=%5$s). Probably your request took too long.";
    private static final String ILLEGAL_WRITE_MSG = "Illegal write attempt: %1$s";
    private static final String MESSAGE_REMOVED_MSG = "Mail(s) %1$s could not be found in folder %2$s";
    private static final String METHOD_NOT_SUPPORTED_MSG = "Method not supported: %1$s";
    private static final String NO_SUCH_PROVIDER_MSG = "Session attempts to instantiate a provider that does not exist: %1$s";
    private static final String INVALID_EMAIL_ADDRESS_MSG = "Invalid E-Mail address %1$s";
    private static final String PARSE_ERROR_MSG = "Wrong message header: %1$s";
    private static final String READ_ONLY_FOLDER_MSG = "An attempt was made to open a read-only folder with read-write \"%1$s\"";
    private static final String READ_ONLY_FOLDER_EXT_MSG = "An attempt was made to open a read-only folder with read-write \"%1$s\" on mail server %2$s with login %3$s (user=%4$s, context=%5$s)";
    private static final String SEARCH_ERROR_MSG = "Invalid search expression: %1$s";
    private static final String MESSAGE_TOO_LARGE_MSG = "Message could not be sent because it is too large";
    private static final String MESSAGE_TOO_LARGE_EXT_MSG = "Message could not be sent because it is too large (%1$s)";
    private static final String SEND_FAILED_MSG = "Message could not be sent to the following recipients: %1$s";
    private static final String SEND_FAILED_EXT_MSG = "Message could not be sent to the following recipients: %1$s (%2$s)";
    private static final String STORE_CLOSED_MSG = "Lost connection to mail server.";
    private static final String STORE_CLOSED_EXT_MSG = "Connection closed to mail server %1$s with login %2$s (user=%3$s, context=%4$s).";
    private static final String CONNECT_ERROR_MSG = "Connection was refused or timed out while attempting to connect to remote server %1$s for user %2$s.";
    private static final String BIND_ERROR_MSG = "Could not bind connection to local port %1$s";
    private static final String CONNECTION_RESET_MSG = "Connection was reset. Please try again.";
    private static final String NO_ROUTE_TO_HOST_MSG = "No route to host: server (%1$s) cannot be reached";
    private static final String PORT_UNREACHABLE_MSG = "Port %1$s was unreachable on remote server";
    private static final String BROKEN_CONNECTION_MSG = "Connection is broken due to a socket exception on remote server: %1$s";
    private static final String SOCKET_ERROR_MSG = "A socket error occurred: %1$s";
    private static final String UNKNOWN_HOST_MSG = "The IP address of host \"%1$s\" could not be determined";
    private static final String MESSAGING_ERROR_MSG = "Messaging error: %1$s";
    private static final String QUOTA_EXCEEDED_MSG = "The quota on mail server exceeded. Error message: %1$s";
    private static final String QUOTA_EXCEEDED_EXT_MSG = "The quota on mail server \"%1$s\" exceeded with login %2$s (user=%3$s, context=%4$s). Error message: %5$s";
    private static final String COMMAND_FAILED_MSG = "A command sent to mail server failed. Server response: %1$s";
    private static final String COMMAND_FAILED_EXT_MSG = "A command failed on mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s";
    private static final String BAD_COMMAND_MSG = "Mail server indicates a bad command. Server response: %1$s";
    private static final String BAD_COMMAND_EXT_MSG = "Bad command indicated by mail server %1$s with login %2$s (user=%3$s, context=%4$s). Server response: %5$s";
    private static final String PROTOCOL_ERROR_MSG = "Error in mail server protocol. Error message: %1$s";
    private static final String PROTOCOL_ERROR_EXT_MSG = "Protocol error in data sent to the mail server %1$s with login %2$s (user=%3$s, context=%4$s). Error message: %5$s";
    private static final String MESSAGE_NOT_DISPLAYED_MSG = "Message cannot be displayed.";
    private static final String TRANSPORT_INVALID_CREDENTIALS_MSG = "Wrong or missing login data to access mail transport server %1$s. Error message from mail transport server: %2$s";
    private static final String TRANSPORT_INVALID_CREDENTIALS_EXT_MSG = "Wrong or missing login data to access mail transport server %1$s with login %2$s (user=%3$s, context=%4$s). Error message from mail transport server: %5$s";
    private static final String PROCESSING_ERROR_MSG = "Error processing mail server response. The administrator has been informed.";
    private static final String PROCESSING_ERROR_EXT_MSG = "Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed.";
    private static final String IO_ERROR_MSG = "An I/O error occurred: %1$s.";
    private static final String IO_ERROR_EXT_MSG = "I/O error \"%1$s\" occurred in communication with \"%2$s\" mail server for login %3$s (user=%4$s, context=%5$s).";
    private static final String PROCESSING_ERROR_WE_MSG = "Error processing mail server response. The administrator has been informed. Error message: %1$s";
    private static final String PROCESSING_ERROR_WE_EXT_MSG = "Error processing %1$s mail server response for login %2$s (user=%3$s, context=%4$s). The administrator has been informed. Error message: %5$s";
    private static final String IN_USE_ERROR_MSG = "That mailbox is already in use by another process. Please try again later. Error message: %1$s";
    private static final String IN_USE_ERROR_EXT_MSG = "That mailbox is already in use by another process on %1$s mail server for login %2$s (user=%3$s, context=%4$s). Please try again later. Error message: %5$s";
    private final String message;
    private final int detailNumber;
    private final Category category;
    private String displayMessage;

    private MimeMailExceptionCode(String message, Category category, int detailNumber, String displayMessage) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
        this.displayMessage = displayMessage == null ? "An error occurred inside the server which prevented it from fulfilling the request." : displayMessage;
    }

    private MimeMailExceptionCode(String message, Category category, int detailNumber) {
        this(message, category, detailNumber, null);
    }

    public String getPrefix() {
        return "MSG";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

