/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.json.OXJSONWriter;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.json.MailRequest;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.server.ServiceLookup;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.utility.VersitUtility;
import java.io.IOException;
import java.util.ArrayList;
import javax.mail.MessageRemovedException;
import org.json.JSONException;
import org.json.JSONObject;

public final class GetVersitAction
extends AbstractMailAction {
    public GetVersitAction(ServiceLookup services) {
        super(services);
    }

    @Override
    protected AJAXRequestResult perform(MailRequest req) throws OXException {
        try {
            ServerSession session = req.getSession();
            String folderPath = req.checkParameter("folder");
            String uid = req.checkParameter("id");
            String partIdentifier = req.checkParameter("attachment");
            MailServletInterface mailInterface = this.getMailInterface(req);
            MailPart versitPart = mailInterface.getMessageAttachment(folderPath, uid, partIdentifier, false);
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            ArrayList<CommonObject> retvalList = new ArrayList<CommonObject>();
            if (versitPart.getContentType().isMimeType("text/x-vcard") || versitPart.getContentType().isMimeType("text/vcard")) {
                VersitUtility.saveVCard(versitPart.getInputStream(), versitPart.getContentType().getBaseType(), versitPart.getContentType().containsCharsetParameter() ? versitPart.getContentType().getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset(), retvalList, session, ctx);
            } else if (versitPart.getContentType().isMimeType("text/x-vcalendar") || versitPart.getContentType().isMimeType("text/calendar")) {
                VersitUtility.saveICal(versitPart.getInputStream(), versitPart.getContentType().getBaseType(), versitPart.getContentType().containsCharsetParameter() ? versitPart.getContentType().getCharsetParameter() : MailProperties.getInstance().getDefaultMimeCharset(), retvalList, session, ctx);
            } else {
                throw MailExceptionCode.UNSUPPORTED_VERSIT_ATTACHMENT.create(versitPart.getContentType());
            }
            CommonObject[] insertedObjs = retvalList.toArray(new CommonObject[retvalList.size()]);
            OXJSONWriter jsonWriter = new OXJSONWriter();
            jsonWriter.array();
            JSONObject jo = new JSONObject();
            for (CommonObject current : insertedObjs) {
                jo.reset();
                jo.put("id", current.getObjectID());
                jo.put("folder_id", current.getParentFolderID());
                jsonWriter.value(jo);
            }
            jsonWriter.endArray();
            AJAXRequestResult data = new AJAXRequestResult((Object)jsonWriter.getObject(), "json");
            return data;
        }
        catch (RuntimeException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        catch (JSONException e) {
            throw MailExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (IOException e) {
            if ("com.sun.mail.util.MessageRemovedIOException".equals(e.getClass().getName()) || e.getCause() instanceof MessageRemovedException) {
                throw MailExceptionCode.MAIL_NOT_FOUND_SIMPLE.create(e, new Object[0]);
            }
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (ConverterException e) {
            throw MailExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }
}

