/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.compose;

import com.openexchange.mail.compose.CompositionSpace;
import com.openexchange.session.Session;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class CompositionSpaceRegistry {
    private final Map<String, CompositionSpace> spaces = new HashMap<String, CompositionSpace>(8);

    CompositionSpaceRegistry() {
    }

    synchronized List<CompositionSpace> removeAllCompositionSpaces() {
        LinkedList<CompositionSpace> l = new LinkedList<CompositionSpace>(this.spaces.values());
        for (CompositionSpace space : l) {
            space.markInactive();
        }
        this.spaces.clear();
        return l;
    }

    synchronized CompositionSpace getCompositionSpace(String csid, Session session) {
        CompositionSpace space = this.spaces.get(csid);
        if (null == space) {
            CompositionSpace newSpace = new CompositionSpace(csid, session);
            this.spaces.put(csid, newSpace);
            space = newSpace;
            space.markActive();
        }
        return space;
    }

    synchronized CompositionSpace optCompositionSpace(String csid) {
        return this.spaces.get(csid);
    }

    synchronized CompositionSpace removeCompositionSpace(String csid) {
        CompositionSpace space = this.spaces.remove(csid);
        if (null != space) {
            space.markInactive();
        }
        return space;
    }
}

