/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.groupware.userconfiguration.UserPermissionBitsStorage;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.map.hash.TIntIntHashMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbUserPermissionBitsStorage
extends UserPermissionBitsStorage {
    private static final Logger LOG = LoggerFactory.getLogger(RdbUserPermissionBitsStorage.class);
    private static final String SQL_SELECT = "SELECT user FROM user_configuration WHERE cid = ? AND user = ?";
    private static final String INSERT_USER_CONFIGURATION = "INSERT INTO user_configuration (cid, user, permissions) VALUES (?, ?, ?)";
    private static final String UPDATE_USER_CONFIGURATION = "UPDATE user_configuration SET permissions = ? WHERE cid = ? AND user = ?";
    private static final String LOAD_USER_CONFIGURATION = "SELECT permissions FROM user_configuration WHERE cid = ? AND user = ?";
    private static final String LOAD_SOME_USER_CONFIGURATIONS = "SELECT user,permissions FROM user_configuration WHERE cid=? AND user IN (";
    private static final String COUNT_USERS_BY_PERMISSION = "SELECT COUNT(permissions) FROM user_configuration WHERE cid = ? AND permissions = ?";
    private static final int LIMIT = 1000;
    private static final String DELETE_USER_CONFIGURATION = "DELETE FROM user_configuration WHERE cid = ? AND user = ?";

    @Override
    public UserPermissionBits getUserPermissionBits(int userId, int contextId) throws OXException {
        ContextService contextService = ServerServiceRegistry.getInstance().getService(ContextService.class);
        if (null == contextService) {
            throw ServiceExceptionCode.absentService(ContextService.class);
        }
        return this.getUserPermissionBits(userId, contextService.getContext(contextId));
    }

    @Override
    public UserPermissionBits getUserPermissionBits(int userId, Context ctx) throws OXException {
        try {
            return RdbUserPermissionBitsStorage.loadUserPermissionBits(userId, ctx);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public UserPermissionBits[] getUserPermissionBits(Context ctx, User[] users) throws OXException {
        try {
            int[] userIds = new int[users.length];
            for (int i = 0; i < users.length; ++i) {
                userIds[i] = users[i].getId();
            }
            return RdbUserPermissionBitsStorage.loadUserPermissionBits(ctx, null, userIds);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public UserPermissionBits[] getUserPermissionBits(Context ctx, int[] userIds) throws OXException {
        try {
            return RdbUserPermissionBitsStorage.loadUserPermissionBits(ctx, null, userIds);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public void clearStorage() {
    }

    @Override
    public void removeUserPermissionBits(int userId, Context ctx) {
    }

    @Override
    public void saveUserPermissionBits(int permissionBits, int userId, Context ctx) throws OXException {
        RdbUserPermissionBitsStorage.saveUserPermissionBits0(permissionBits, userId, ctx);
    }

    public static void saveUserPermissionBits(UserPermissionBits perms, boolean insert, Connection writeCon) throws SQLException, OXException {
        RdbUserPermissionBitsStorage.saveUserPermissionBits(perms.getPermissionBits(), perms.getUserId(), insert, perms.getContextId(), writeCon);
    }

    private static Context getContext(UserPermissionBits perms) throws OXException {
        return ContextStorage.getInstance().getContext(perms.getContextId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveUserPermissionBits0(int permissionBits, int userId, Context ctx) throws OXException {
        boolean insert = false;
        try {
            Connection readCon = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                readCon = DBPool.pickup(ctx);
                stmt = readCon.prepareStatement(SQL_SELECT);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, userId);
                rs = stmt.executeQuery();
                insert = !rs.next();
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
                throw throwable;
            }
            DBUtils.closeResources(rs, (Statement)stmt, readCon, true, ctx);
            RdbUserPermissionBitsStorage.saveUserPermissionBits(permissionBits, userId, insert, ctx.getContextId(), null);
        }
        catch (SQLException e) {
            throw UserConfigurationCodes.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUserPermissionBits(int permissionBits, int userId, boolean insert, int ctxId, Connection writeConArg) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeConnection = false;
        PreparedStatement stmt = null;
        ContextImpl ctx = new ContextImpl(ctxId);
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeConnection = true;
            }
            if (insert) {
                stmt = writeCon.prepareStatement(INSERT_USER_CONFIGURATION);
                stmt.setInt(1, ctxId);
                stmt.setInt(2, userId);
                stmt.setInt(3, permissionBits);
            } else {
                stmt = writeCon.prepareStatement(UPDATE_USER_CONFIGURATION);
                stmt.setInt(1, permissionBits);
                stmt.setInt(2, ctxId);
                stmt.setInt(3, userId);
            }
            stmt.executeUpdate();
            if (!insert) {
                try {
                    UserConfigurationStorage.getInstance().invalidateCache(userId, ctx);
                }
                catch (OXException e) {
                    LOG.warn("User Configuration could not be removed from cache", (Throwable)e);
                }
            }
            DBUtils.closeResources(null, (Statement)stmt, closeConnection ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeConnection ? writeCon : null, false, ctx);
            throw throwable;
        }
    }

    public static UserPermissionBits loadUserPermissionBits(int userId, Context ctx) throws SQLException, OXException {
        return RdbUserPermissionBitsStorage.loadUserPermissionBits(userId, ctx, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPermissionBits adminLoadUserPermissionBits(int userId, int[] groups, int cid, Connection readConArg) throws SQLException, OXException {
        UserPermissionBits userPermissionBits;
        ContextImpl ctx = new ContextImpl(cid);
        Connection readCon = readConArg;
        boolean closeReadCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeReadCon = true;
            }
            stmt = readCon.prepareStatement(LOAD_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            userPermissionBits = rs.next() ? new UserPermissionBits(rs.getInt(1), userId, groups, ctx.getContextId()) : new UserPermissionBits(0, userId, groups, ctx.getContextId());
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return userPermissionBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int adminCountUsersByPermission(int cid, UserPermissionBits permissions, Connection readConArg) throws SQLException, OXException {
        ResultSet rs;
        PreparedStatement stmt;
        boolean closeReadCon;
        Connection readCon;
        ContextImpl ctx;
        block4: {
            int n;
            ctx = new ContextImpl(cid);
            readCon = readConArg;
            closeReadCon = false;
            stmt = null;
            rs = null;
            try {
                if (readCon == null) {
                    readCon = DBPool.pickup(ctx);
                    closeReadCon = true;
                }
                stmt = readCon.prepareStatement(COUNT_USERS_BY_PERMISSION);
                stmt.setInt(1, ctx.getContextId());
                stmt.setInt(2, permissions.getPermissionBits());
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
            }
            catch (Throwable throwable) {
                DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
                throw throwable;
            }
            return n;
        }
        int n = -1;
        DBUtils.closeResources(rs, (Statement)stmt, closeReadCon ? readCon : null, true, ctx);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPermissionBits loadUserPermissionBits(int userId, Context ctx, Connection readConArg) throws SQLException, OXException {
        UserPermissionBits userPermissionBits;
        Connection readCon = readConArg;
        boolean closeCon = false;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            if (readCon == null) {
                readCon = DBPool.pickup(ctx);
                closeCon = true;
            }
            stmt = readCon.prepareStatement(LOAD_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw UserConfigurationCodes.NOT_FOUND.create(userId, ctx.getContextId());
            }
            userPermissionBits = new UserPermissionBits(rs.getInt(1), userId, ctx.getContextId());
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(rs, (Statement)stmt, closeCon ? readCon : null, true, ctx);
            throw throwable;
        }
        return userPermissionBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserPermissionBits[] loadUserPermissionBits(Context ctx, Connection conArg, int[] userIds) throws OXException, SQLException {
        boolean closeCon;
        Connection con;
        int length = userIds.length;
        if (0 == length) {
            return new UserPermissionBits[0];
        }
        if (null == conArg) {
            con = DBPool.pickup(ctx);
            closeCon = true;
        } else {
            con = conArg;
            closeCon = false;
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        UserPermissionBits[] retval = new UserPermissionBits[length];
        try {
            TIntIntHashMap userMap;
            if (length <= 1000) {
                StringBuilder sb = new StringBuilder(512);
                sb.append("SELECT u.user, u.permissions FROM user_configuration AS u");
                if (1 == length) {
                    sb.append(" WHERE u.user = ? AND u.cid = ?");
                } else {
                    sb.append(" INNER JOIN (");
                    sb.append("SELECT ? AS user");
                    for (int i = 1; i < length; ++i) {
                        sb.append(" UNION ALL SELECT ?");
                    }
                    sb.append(") AS x ON u.user = x.user WHERE u.cid = ?");
                }
                stmt = con.prepareStatement(sb.toString());
                int pos = 1;
                userMap = new TIntIntHashMap(length, 1.0f);
                for (int index = 0; index < length; ++index) {
                    int userId = userIds[index];
                    stmt.setInt(pos++, userId);
                    userMap.put(userId, index);
                }
                stmt.setInt(pos++, ctx.getContextId());
            } else {
                stmt = con.prepareStatement("SELECT u.user, u.permissions FROM user_configuration AS u WHERE u.cid = ?");
                userMap = new TIntIntHashMap(length, 1.0f);
                for (int index = 0; index < length; ++index) {
                    userMap.put(userIds[index], index);
                }
                stmt.setInt(1, ctx.getContextId());
            }
            result = stmt.executeQuery();
            while (result.next()) {
                int userId = result.getInt(1);
                if (!userMap.containsKey(userId)) continue;
                int index = userMap.get(userId);
                retval[index] = new UserPermissionBits(result.getInt(2), userId, ctx.getContextId());
            }
            DBUtils.closeResources(result, (Statement)stmt, closeCon ? con : null, true, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(result, (Statement)stmt, closeCon ? con : null, true, ctx);
            throw throwable;
        }
        return retval;
    }

    public static void deleteUserPermissionBits(int userId, Context ctx) throws SQLException, OXException {
        RdbUserPermissionBitsStorage.deleteUserPermissionBits(userId, null, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteUserPermissionBits(int userId, Connection writeConArg, Context ctx) throws SQLException, OXException {
        Connection writeCon = writeConArg;
        boolean closeWriteCon = false;
        PreparedStatement stmt = null;
        try {
            if (writeCon == null) {
                writeCon = DBPool.pickupWriteable(ctx);
                closeWriteCon = true;
            }
            stmt = writeCon.prepareStatement(DELETE_USER_CONFIGURATION);
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, userId);
            stmt.executeUpdate();
            try {
                UserConfigurationStorage.getInstance().invalidateCache(userId, ctx);
            }
            catch (OXException e) {
                LOG.warn("User Configuration could not be removed from cache", (Throwable)e);
            }
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
        }
        catch (Throwable throwable) {
            DBUtils.closeResources(null, (Statement)stmt, closeWriteCon ? writeCon : null, false, ctx);
            throw throwable;
        }
    }
}

