/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactsAddIndex4AutoCompleteSearch
implements UpdateTask {
    private static final Logger LOG = LoggerFactory.getLogger(ContactsAddIndex4AutoCompleteSearch.class);

    @Override
    public int addedWithVersion() {
        return 74;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGH.priority;
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            String[] tables = new String[]{"prg_contacts", "del_contacts"};
            this.createContactIndex(con, tables, "field03", "givenname");
            this.createContactIndex(con, tables, "field02", "surname");
            this.createContactIndex(con, tables, "field01", "displayname");
            this.createContactIndex(con, tables, "field65", "email1");
            this.createContactIndex(con, tables, "field66", "email2");
            this.createContactIndex(con, tables, "field67", "email3");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw ContactsAddIndex4AutoCompleteSearch.createSQLError(e);
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createContactIndex(Connection con, String[] tables, String fieldName, String name) {
        String[] columns = new String[]{"cid", fieldName};
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    if (LOG.isInfoEnabled()) {
                        sb.setLength(0);
                        sb.append("Creating new index named \"");
                        sb.append(name);
                        sb.append("\" with columns (cid,");
                        sb.append(fieldName);
                        sb.append(") on table ");
                        sb.append(table);
                        sb.append('.');
                        LOG.info(sb.toString());
                    }
                    Tools.createIndex(con, table, name, columns, false);
                    continue;
                }
                if (!LOG.isInfoEnabled()) continue;
                sb.setLength(0);
                sb.append("New index named \"");
                sb.append(indexName);
                sb.append("\" with columns (cid,");
                sb.append(fieldName);
                sb.append(") already exists on table ");
                sb.append(table);
                sb.append('.');
                LOG.info(sb.toString());
            }
            catch (SQLException e) {
                LOG.error("Problem adding index {} on table {}{}", new Object[]{name, table, Character.valueOf('.'), e});
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

