/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.update.Index;
import com.openexchange.tools.update.IndexNotFoundException;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class CreateIndexUpdateTask
extends UpdateTaskAdapter {
    private final Index index = new Index();

    public CreateIndexUpdateTask(String table, String indexName, String ... columns) {
        this.index.setTable(table);
        this.index.setName(indexName);
        this.index.setColumns(columns);
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = null;
        try {
            con = this.getDatabaseService().getForUpdateTask(contextId);
            if (!this.hasIndex(con)) {
                this.createIndex(con);
            }
        }
        catch (SQLException x) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(x.getMessage(), x);
        }
        finally {
            this.getDatabaseService().backForUpdateTask(contextId, con);
        }
    }

    protected abstract DatabaseService getDatabaseService();

    protected void createIndex(Connection con) throws SQLException {
        this.index.create(con);
    }

    private boolean hasIndex(Connection con) throws SQLException {
        try {
            Index.findByName(con, this.index.getTable(), this.index.getName());
        }
        catch (IndexNotFoundException e) {
            return false;
        }
        return true;
    }
}

