/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.tasks.Folder;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.SQL;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.TaskExceptionCode;
import com.openexchange.tools.Collections;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class RdbFolderStorage
extends FolderStorage {
    @Override
    public void insertFolder(Context ctx, Connection con, int taskId, Set<Folder> folders2, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL.INSERT_FOLDER.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            for (Folder folder : folders2) {
                pos = 3;
                stmt.setInt(pos++, folder.getIdentifier());
                stmt.setInt(pos++, folder.getUser());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
    }

    @Override
    public Set<Folder> selectFolder(Context ctx, Connection con, int taskId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        HashSet<Folder> retval = new HashSet<Folder>();
        try {
            stmt = con.prepareStatement(SQL.SELECT_FOLDER.get((Object)type));
            stmt.setInt(1, ctx.getContextId());
            stmt.setInt(2, taskId);
            result = stmt.executeQuery();
            while (result.next()) {
                retval.add(new Folder(result.getInt(1), result.getInt(2)));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    @Override
    public Folder selectFolderByUser(Context ctx, Connection con, int taskId, int userId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        Folder retval = null;
        try {
            stmt = con.prepareStatement(SQL.FOLDER_BY_USER.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            if (result.next()) {
                retval = new Folder(result.getInt(1), userId);
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    @Override
    Folder selectFolderById(Context ctx, Connection con, int taskId, int folderId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        Folder retval = null;
        try {
            stmt = con.prepareStatement(SQL.FOLDER_BY_ID.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, taskId);
            stmt.setInt(pos++, folderId);
            result = stmt.executeQuery();
            if (result.next()) {
                retval = new Folder(folderId, result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return retval;
    }

    @Override
    void deleteFolder(Context ctx, Connection con, int taskId, int[] folderIds, StorageType type, boolean sanityCheck) throws OXException {
        PreparedStatement stmt = null;
        int deleted = 0;
        try {
            stmt = con.prepareStatement(DBUtils.getIN(SQL.DELETE_FOLDER.get((Object)type), folderIds.length));
            int counter = 1;
            stmt.setInt(counter++, ctx.getContextId());
            stmt.setInt(counter++, taskId);
            for (int folderId : folderIds) {
                stmt.setInt(counter++, folderId);
            }
            deleted = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(null, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(null, stmt);
        if (sanityCheck && folderIds.length != deleted) {
            throw TaskExceptionCode.FOLDER_DELETE_WRONG.create(folderIds.length, deleted);
        }
    }

    @Override
    int[] getTasksInFolder(Context ctx, Connection con, int folderId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<Integer> tasks2 = new ArrayList<Integer>();
        try {
            stmt = con.prepareStatement(SQL.TASK_IN_FOLDER.get((Object)type));
            int counter = 1;
            stmt.setInt(counter++, ctx.getContextId());
            stmt.setInt(counter++, folderId);
            result = stmt.executeQuery();
            while (result.next()) {
                tasks2.add(result.getInt(1));
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return Collections.toArray(tasks2);
    }

    @Override
    public int[][] searchFolderByUser(Context ctx, Connection con, int userId, StorageType type) throws OXException {
        PreparedStatement stmt = null;
        ResultSet result = null;
        ArrayList<int[]> tmp = new ArrayList<int[]>();
        try {
            stmt = con.prepareStatement(SQL.SEARCH_FOLDER_BY_USER.get((Object)type));
            int pos = 1;
            stmt.setInt(pos++, ctx.getContextId());
            stmt.setInt(pos++, userId);
            result = stmt.executeQuery();
            while (result.next()) {
                int[] folderAndTask = new int[]{result.getInt(1), result.getInt(2)};
                tmp.add(folderAndTask);
            }
        }
        catch (SQLException e) {
            try {
                throw TaskExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        int[][] retval = new int[tmp.size()][];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = (int[])tmp.get(i);
        }
        return retval;
    }
}

