/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PreRead<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PreRead.class);
    private static final int MINIMUM_PREREAD = 1;
    private final Queue<T> elements = new LinkedList<T>();
    private final Lock lock = new ReentrantLock();
    private final Condition waitForMinimum = this.lock.newCondition();
    private final Condition waitForPreReader = this.lock.newCondition();
    private boolean preReaderFinished = false;

    PreRead() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        this.lock.lock();
        try {
            this.preReaderFinished = true;
            this.waitForPreReader.signal();
            this.waitForMinimum.signal();
            LOG.trace("Finished.");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(T element) {
        this.lock.lock();
        try {
            this.elements.offer(element);
            this.waitForPreReader.signal();
            if (this.elements.size() >= 1) {
                this.waitForMinimum.signal();
            }
            LOG.trace("Offered. {}", (Object)this.elements.size());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> take(boolean minimum) throws InterruptedException {
        ArrayList<T> retval;
        this.lock.lock();
        try {
            LOG.debug("Taking. {}", (Object)minimum);
            if (minimum && this.elements.size() < 1 && !this.preReaderFinished) {
                LOG.debug("Waiting for enough.");
                this.waitForMinimum.await();
            }
            if (this.elements.isEmpty()) {
                throw new NoSuchElementException();
            }
            retval = new ArrayList<T>(this.elements.size());
            retval.addAll(this.elements);
            this.elements.clear();
            LOG.trace("Taken.");
        }
        finally {
            this.lock.unlock();
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        this.lock.lock();
        try {
            while (!this.preReaderFinished && this.elements.isEmpty()) {
                LOG.trace("Waiting for state.");
                try {
                    this.waitForPreReader.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.trace("", (Throwable)e);
                }
            }
            boolean bl = !this.elements.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

