/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.tree.modules.mail;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.PreferencesItemService;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.settings.SettingExceptionCodes;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Strings;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;

public class MsgFormat
implements PreferencesItemService {
    @Override
    public String[] getPath() {
        return new String[]{"modules", "mail", "msgformat"};
    }

    @Override
    public IValueHandler getSharedValue() {
        return new IValueHandler(){

            @Override
            public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
                UserSettingMail settings = UserSettingMailStorage.getInstance().getUserSettingMail(user.getId(), ctx);
                if (null != settings) {
                    String format = "html";
                    int msgFormat = settings.getMsgFormat();
                    if (1 == msgFormat) {
                        format = "text";
                    } else if (2 == msgFormat) {
                        format = "html";
                    } else if (3 == msgFormat) {
                        format = "alternative";
                    }
                    setting.setSingleValue(format);
                }
            }

            @Override
            public boolean isAvailable(UserConfiguration userConfig) {
                return userConfig.hasWebMail();
            }

            @Override
            public boolean isWritable() {
                return true;
            }

            @Override
            public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
                UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
                UserSettingMail usm = storage.getUserSettingMail(user.getId(), ctx);
                if (null != usm) {
                    int msgFormat = 2;
                    String s = setting.getSingleValue().toString();
                    if (Strings.isEmpty((String)s)) {
                        return;
                    }
                    if ("text".equalsIgnoreCase(s)) {
                        msgFormat = 1;
                    } else if ("html".equalsIgnoreCase(s)) {
                        msgFormat = 2;
                    } else if ("alternative".equalsIgnoreCase(s)) {
                        msgFormat = 3;
                    }
                    try {
                        if (msgFormat != usm.getMsgFormat()) {
                            usm.setMsgFormat(msgFormat);
                            storage.saveUserSettingMail(usm, user.getId(), ctx);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw SettingExceptionCodes.JSON_READ_ERROR.create(e, new Object[0]);
                    }
                }
            }

            @Override
            public int getId() {
                return -1;
            }
        };
    }
}

