/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.notify;

import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalEmitter;
import com.openexchange.data.conversion.ical.ICalSession;
import com.openexchange.data.conversion.ical.SimpleMode;
import com.openexchange.data.conversion.ical.ZoneInfo;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.mail.MailObject;
import com.openexchange.groupware.notify.EmailableParticipant;
import com.openexchange.groupware.notify.LinkableState;
import com.openexchange.groupware.notify.ParticipantNotify;
import com.openexchange.groupware.notify.State;
import com.openexchange.i18n.tools.RenderMap;
import com.openexchange.i18n.tools.StringTemplate;
import com.openexchange.i18n.tools.Template;
import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.replacement.LocationReplacement;
import com.openexchange.java.Autoboxing;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentState
extends LinkableState {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppointmentState.class);
    private final TemplateReplacement actionRepl;
    private final TemplateReplacement confirmationActionRepl;
    private final String messageTemplate;
    private final State.Type type;
    private static final Set<Integer> FIELDS_TO_IGNORE = new HashSet<Integer>(Arrays.asList(Autoboxing.I((int)1), Autoboxing.I((int)2), Autoboxing.I((int)3), Autoboxing.I((int)4), Autoboxing.I((int)5), Autoboxing.I((int)6), Autoboxing.I((int)204), Autoboxing.I((int)217), Autoboxing.I((int)209), Autoboxing.I((int)100), Autoboxing.I((int)225), Autoboxing.I((int)402)));

    public AppointmentState(TemplateReplacement actionRepl, String messageTemplate, State.Type type) {
        this(actionRepl, null, messageTemplate, type);
    }

    public AppointmentState(TemplateReplacement actionRepl, TemplateReplacement confirmationActionRepl, String messageTemplate, State.Type type) {
        this.actionRepl = actionRepl;
        this.confirmationActionRepl = confirmationActionRepl;
        this.messageTemplate = messageTemplate;
        this.type = type;
    }

    @Override
    public boolean sendMail(UserSettingMail userSettingMail, int owner, int participant, int modificationUser) {
        if (modificationUser == participant) {
            return false;
        }
        switch (this.type) {
            case ACCEPTED: 
            case DECLINED: 
            case TENTATIVELY_ACCEPTED: 
            case NONE_ACCEPTED: {
                return participant == owner ? userSettingMail.isNotifyAppointmentsConfirmOwner() : userSettingMail.isNotifyAppointmentsConfirmParticipant();
            }
            case REMINDER: {
                return false;
            }
        }
        return userSettingMail.isNotifyAppointments();
    }

    @Override
    public void addSpecial(CalendarObject obj, CalendarObject oldObj, RenderMap renderMap, EmailableParticipant p) {
        super.addSpecial(obj, oldObj, renderMap, p);
        String location = ((Appointment)obj).getLocation();
        if (location == null) {
            location = "";
        }
        LocationReplacement tr = new LocationReplacement(location);
        tr.setLocale(p.getLocale());
        tr.setChanged(oldObj == null ? false : !ParticipantNotify.compareStrings(location, ((Appointment)oldObj).getLocation()));
        renderMap.put(tr);
        if (!obj.containsUid() && null != oldObj && oldObj.containsUid()) {
            obj.setUid(oldObj.getUid());
        }
    }

    @Override
    public int getModule() {
        return 1;
    }

    @Override
    public DateFormat getDateFormat(Locale locale) {
        return this.tryAppendingTimeZone(DateFormat.getDateTimeInstance(2, 2, locale));
    }

    private DateFormat tryAppendingTimeZone(DateFormat df) {
        if (df instanceof SimpleDateFormat) {
            SimpleDateFormat sdf = (SimpleDateFormat)df;
            String format = sdf.toPattern();
            return new SimpleDateFormat(format + ", z");
        }
        return df;
    }

    @Override
    public void modifyInternal(MailObject mail, CalendarObject obj, ServerSession sessObj) {
    }

    @Override
    public void modifyExternal(MailObject mail, CalendarObject obj, ServerSession sessObj) {
        this.addICALAttachment(mail, (Appointment)obj, sessObj);
    }

    private void addICALAttachment(MailObject mail, Appointment obj, ServerSession sessObj) {
        ICalEmitter emitter = ServerServiceRegistry.getInstance().getService(ICalEmitter.class);
        if (emitter == null) {
            LOGGER.warn("Could not find ical emitter service. Skipping attachment");
            return;
        }
        try {
            UnsynchronizedByteArrayOutputStream byteArrayOutputStream = new UnsynchronizedByteArrayOutputStream();
            ICalSession session = emitter.createSession(new SimpleMode(ZoneInfo.OUTLOOK));
            emitter.writeAppointment(session, obj, sessObj.getContext(), new LinkedList<ConversionError>(), new LinkedList<ConversionWarning>());
            emitter.writeSession(session, (OutputStream)byteArrayOutputStream);
            UnsynchronizedByteArrayInputStream icalFile = new UnsynchronizedByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ContentType ct = new ContentType();
            ct.setPrimaryType("text");
            ct.setSubType("calendar");
            ct.setCharsetParameter("utf-8");
            String filename = "appointment.ics";
            mail.addFileAttachment(ct, "appointment.ics", (InputStream)icalFile);
        }
        catch (OXException e) {
            LOGGER.error("Can't add attachment", (Throwable)e);
        }
    }

    @Override
    public Template getTemplate() {
        return new StringTemplate(this.messageTemplate);
    }

    @Override
    public TemplateReplacement getAction() {
        return this.actionRepl;
    }

    @Override
    public TemplateReplacement getConfirmationAction() {
        return this.confirmationActionRepl;
    }

    @Override
    public State.Type getType() {
        return this.type;
    }

    @Override
    public boolean onlyIrrelevantFieldsChanged(CalendarObject oldObj, CalendarObject newObj) {
        Set<Integer> differingFields = oldObj.findDifferingFields(newObj);
        differingFields.removeAll(FIELDS_TO_IGNORE);
        return differingFields.isEmpty();
    }
}

