/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Map;
import java.util.Set;

public final class UserAttributeAccess {
    private static volatile UserAttributeAccess instance;
    private final UserStorage userStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserAttributeAccess getDefaultInstance() {
        UserAttributeAccess tmp = instance;
        if (null != tmp) return tmp;
        Class<UserAttributeAccess> clazz = UserAttributeAccess.class;
        synchronized (UserAttributeAccess.class) {
            tmp = instance;
            if (null != tmp) return tmp;
            instance = new UserAttributeAccess();
            return instance;
        }
    }

    private UserAttributeAccess() {
        this(UserStorage.getInstance());
    }

    public UserAttributeAccess(UserStorage userStorage) {
        this.userStorage = userStorage;
    }

    public boolean getBooleanProperty(String name, boolean defaultValue) {
        ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
        if (null == service) {
            return defaultValue;
        }
        return service.getBoolProperty(name, defaultValue);
    }

    public boolean getBooleanAttribute(String name, int userId, int contextId, boolean defaultValue) throws OXException {
        return this.getBooleanAttribute(name, UserStorage.getInstance().getUser(userId, contextId), defaultValue);
    }

    public boolean getBooleanAttribute(String name, User user, boolean defaultValue) {
        return Boolean.parseBoolean(this.getAttribute(name, user, String.valueOf(defaultValue)));
    }

    public String getAttribute(String name, User user, String defaultValue) {
        Map<String, Set<String>> attributes = user.getAttributes();
        if (null == attributes) {
            return defaultValue;
        }
        Set<String> bset = attributes.get(name);
        if (null == bset || bset.isEmpty()) {
            return defaultValue;
        }
        return bset.iterator().next();
    }

    public void setBooleanAttribute(String name, boolean value, int userId, int contextId) throws OXException {
        Context context = null;
        try {
            context = ContextStorage.getStorageContext(contextId);
        }
        catch (OXException e) {
            context = new ContextImpl(contextId);
        }
        this.setBooleanAttribute(name, value, this.userStorage.getUser(userId, context), context);
    }

    public void setBooleanAttribute(String name, boolean value, User user, Context context) throws OXException {
        this.setAttribute(name, String.valueOf(value), user, context);
    }

    public void setAttribute(String name, String value, User user, Context context) throws OXException {
        this.userStorage.setAttribute(name, value, user.getId(), context);
    }
}

