/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.CachingContextStorage;
import com.openexchange.groupware.contexts.impl.ContextExceptionCodes;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.contexts.impl.RdbContextStorage;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextStorage {
    private static final Logger LOG = LoggerFactory.getLogger(ContextStorage.class);
    private static volatile ContextStorage impl;
    public static final int NOT_FOUND = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ContextStorage getInstance() {
        ContextStorage tmp = impl;
        if (null != tmp) return tmp;
        Class<ContextStorage> clazz = ContextStorage.class;
        synchronized (ContextStorage.class) {
            tmp = impl;
            if (null != tmp) return tmp;
            try {
                CachingContextStorage.parent = new CachingContextStorage(new RdbContextStorage());
                tmp = CachingContextStorage.parent;
                tmp.startUp();
                impl = tmp;
            }
            catch (OXException e) {
                LOG.warn("", (Throwable)e);
            }
            return tmp;
        }
    }

    public abstract int getContextId(String var1) throws OXException;

    public final Context getContext(Session session) throws OXException {
        return this.getContext(session.getContextId());
    }

    public Context getContext(int contextId) throws OXException {
        ContextExtended retval = this.loadContext(contextId);
        if (retval.isUpdating()) {
            OXException exception = ContextExceptionCodes.UPDATE.create();
            LOG.info(exception.getMessage());
            throw exception;
        }
        return retval;
    }

    public abstract ContextExtended loadContext(int var1) throws OXException;

    public void invalidateContext(int contextId) throws OXException {
        LOG.trace("invalidateContext not implemented in {}", (Object)this.getClass().getCanonicalName());
    }

    public void invalidateContexts(int[] contextIDs) throws OXException {
        LOG.trace("invalidateContext not implemented in {}", (Object)this.getClass().getCanonicalName());
    }

    public void invalidateLoginInfo(String loginContextInfo) throws OXException {
        LOG.trace("invalidateLoginInfo not implemented in {}", (Object)this.getClass().getCanonicalName());
    }

    public abstract List<Integer> getAllContextIds() throws OXException;

    public abstract List<Integer> getAllContextIdsForFilestore(int var1) throws OXException;

    protected abstract void startUp() throws OXException;

    protected abstract void shutDown() throws OXException;

    public static void start() throws OXException {
        ContextStorage impl = ContextStorage.impl;
        if (null != impl) {
            LOG.error("Duplicate initialization of ContextStorage.");
            return;
        }
        CachingContextStorage.parent = new CachingContextStorage(new RdbContextStorage());
        impl = CachingContextStorage.parent;
        impl.startUp();
        ContextStorage.impl = impl;
    }

    public static void stop() throws OXException {
        ContextStorage impl = ContextStorage.impl;
        if (null == impl) {
            LOG.error("Duplicate shutdown of ContextStorage.");
            return;
        }
        impl.shutDown();
        ContextStorage.impl = null;
    }

    public static Context getStorageContext(Session session) throws OXException {
        if (session instanceof ServerSession) {
            return ((ServerSession)session).getContext();
        }
        return ContextStorage.getStorageContext(session.getContextId());
    }

    public static Context getStorageContext(int contextId) throws OXException {
        return ContextStorage.getInstance().getContext(contextId);
    }
}

