/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact.datahandler;

import com.openexchange.contact.ContactService;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataHandler;
import com.openexchange.conversion.DataProperties;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.java.Streams;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.versit.VersitDefinition;
import com.openexchange.tools.versit.VersitObject;
import com.openexchange.tools.versit.converter.ConverterException;
import com.openexchange.tools.versit.converter.OXContainerConverter;
import com.openexchange.tools.versit.filetokenizer.VCardFileToken;
import com.openexchange.tools.versit.filetokenizer.VCardTokenizer;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContactInsertDataHandler
implements DataHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ContactInsertDataHandler.class);
    private static final String[] ARGS = new String[]{"com.openexchange.groupware.contact.folder"};
    private static final Class<?>[] TYPES = new Class[]{InputStream.class};

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public Object processData(Data<?> data, DataArguments dataArguments, Session session) throws OXException {
        int folder;
        try {
            folder = Integer.parseInt(dataArguments.get(ARGS[0]));
        }
        catch (NumberFormatException e) {
            throw DataExceptionCodes.INVALID_ARGUMENT.create(new Object[]{ARGS[0], e, dataArguments.get(ARGS[0])});
        }
        Context ctx = ContextStorage.getStorageContext(session);
        OXContainerConverter converter = new OXContainerConverter(session, ctx);
        InputStream inputStream = (InputStream)data.getData();
        try {
            DataProperties dataProperties = data.getDataProperties();
            VCardTokenizer tokenizer = new VCardTokenizer(inputStream);
            List<VCardFileToken> chunks = tokenizer.split();
            if (chunks.isEmpty()) {
                LOG.error("VCard tokenizer returned zero results");
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            JSONArray jsonArray = new JSONArray();
            for (VCardFileToken chunk : chunks) {
                VersitDefinition def = chunk.getVersitDefinition();
                if (def == null) {
                    LOG.error("Could not recognize format of the following VCard data:\n{}", (Object)Arrays.toString(chunk.getContent()));
                    continue;
                }
                VersitDefinition.Reader versitReader = def.getReader((InputStream)new UnsynchronizedByteArrayInputStream(chunk.getContent()), dataProperties.get("com.openexchange.conversion.charset"));
                VersitObject versitObject = def.parse(versitReader);
                Contact contact = converter.convertContact(versitObject);
                contact.setParentFolderID(folder);
                ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
                try {
                    contactService.createContact(session, Integer.toString(contact.getParentFolderID()), contact);
                }
                catch (OXException oxEx) {
                    LOG.debug("Cannot store contact object", (Throwable)oxEx);
                    throw ContactInsertDataHandler.handleDataTruncation(oxEx);
                }
                jsonArray.put((Object)new JSONObject().put("folder_id", folder).put("id", contact.getObjectID()));
            }
            JSONArray jSONArray = jsonArray;
            return jSONArray;
        }
        catch (ConverterException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (OXException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (JSONException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            converter.close();
            Streams.close((Closeable)inputStream);
        }
    }

    private static OXException handleDataTruncation(OXException e) {
        if (Category.EnumType.TRUNCATED.equals((Object)((Category)e.getCategories().get(0)).getType())) {
            OXException.ProblematicAttribute[] problematics;
            String separator = ", ";
            StringBuilder bob = new StringBuilder();
            for (OXException.ProblematicAttribute problematic : problematics = e.getProblematics()) {
                if (!(problematic instanceof OXException.Truncated)) continue;
                int id = ((OXException.Truncated)problematic).getId();
                bob.append(ContactInsertDataHandler.getNameForFieldInTruncationError(id));
                bob.append(", ");
            }
            bob.setLength(bob.length() - ", ".length());
            return DataExceptionCodes.TRUNCATED.create(new Object[]{bob.toString()});
        }
        return e;
    }

    private static String getNameForFieldInTruncationError(int id) {
        ContactField field = ContactField.getByValue(id);
        if (field == null) {
            return String.valueOf(id);
        }
        return field.getReadableName();
    }
}

