/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.concurrent.CallerRunsCompletionService;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.FolderType;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.StorageParameters;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.InstanceStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.SessionStorageParametersProvider;
import com.openexchange.folderstorage.internal.performers.StorageParametersProvider;
import com.openexchange.folderstorage.mail.MailFolderType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.FullnameArgument;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.internal.RdbMailAccountStorage;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.ThreadPoolCompletionService;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ListPerformer
extends AbstractUserizedFolderPerformer {
    private static final Logger LOG = LoggerFactory.getLogger(ListPerformer.class);
    protected static final FolderType FOLDER_TYPE_MAIL = MailFolderType.getInstance();
    private static final ThreadPools.ExpectedExceptionFactory<OXException> FACTORY = new ThreadPools.ExpectedExceptionFactory<OXException>(){

        public Class<OXException> getType() {
            return OXException.class;
        }

        public OXException newUnexpectedError(Throwable t) {
            return FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(t, t.getMessage());
        }
    };

    public ListPerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public ListPerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public ListPerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public ListPerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public UserizedFolder[] doList(String treeId, String parentId, boolean all) throws OXException {
        return this.doList(treeId, parentId, all, false);
    }

    protected UserizedFolder[] doList(String treeId, String parentId, boolean all, boolean checkOnly) throws OXException {
        FolderStorage folderStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, parentId);
        if (null == folderStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        if (folderStorage.startTransaction(this.storageParameters, false)) {
            openedStorages.add(folderStorage);
        }
        try {
            UserizedFolder[] ret;
            for (UserizedFolder userizedFolder : ret = this.doList(treeId, parentId, all, openedStorages, checkOnly)) {
                userizedFolder.setParentID(parentId);
            }
            for (FolderStorage fs : openedStorages) {
                fs.commitTransaction(this.storageParameters);
            }
            return ret;
        }
        catch (OXException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (RuntimeException e) {
            for (FolderStorage fs : openedStorages) {
                fs.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    UserizedFolder[] doList(final String treeId, String parentId, final boolean all, Collection<FolderStorage> openedStorages, final boolean checkOnly) throws OXException {
        FolderStorage folderStorage = this.getOpenedStorage(parentId, treeId, this.storageParameters, openedStorages);
        try {
            StorageParametersProvider paramsProvider;
            ThreadPoolCompletionService completionService;
            FullnameArgument argument;
            Folder parent = folderStorage.getFolder(treeId, parentId, this.storageParameters);
            Permission parentPermission = CalculatePermission.calculate(parent, this, this.getAllowedContentTypes());
            if (!parentPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(parent), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            final String[] subfolderIds = parent.getSubfolderIDs();
            if (null == subfolderIds) {
                return this.getSubfoldersFromStorages(treeId, parentId, all, checkOnly);
            }
            if (0 == subfolderIds.length) {
                return new UserizedFolder[0];
            }
            if (MailProperties.getInstance().isHidePOP3StorageFolders() && FOLDER_TYPE_MAIL.servesFolderId(parentId) && 0 == (argument = MailFolderUtility.prepareMailFolderParam(parentId)).getAccountId()) {
                ArrayList<String> l = new ArrayList<String>(Arrays.asList(subfolderIds));
                Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(this.session);
                Iterator it = l.iterator();
                while (it.hasNext()) {
                    if (!pop3StorageFolders.contains(it.next())) continue;
                    it.remove();
                }
            }
            HashMap<FolderStorage, TIntList> map = new HashMap<FolderStorage, TIntList>(4);
            for (int i = 0; i < subfolderIds.length; ++i) {
                String id = subfolderIds[i];
                FolderStorage tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
                if (null == tmp) {
                    throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, id);
                }
                TIntList list = (TIntList)map.get(tmp);
                if (null == list) {
                    list = new TIntArrayList();
                    map.put(tmp, list);
                }
                list.add(i);
            }
            final UserizedFolder[] subfolders = new UserizedFolder[subfolderIds.length];
            if (1 == map.size()) {
                completionService = new CallerRunsCompletionService();
                paramsProvider = new InstanceStorageParametersProvider(this.storageParameters);
            } else {
                completionService = new ThreadPoolCompletionService(ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true));
                paramsProvider = null == this.session ? new SessionStorageParametersProvider(this.user, this.context) : new SessionStorageParametersProvider(this.session);
            }
            final ListPerformer performer = this;
            int taskCount = 0;
            for (Map.Entry entry : map.entrySet()) {
                final FolderStorage tmp = (FolderStorage)entry.getKey();
                final int[] indexes = ((TIntList)entry.getValue()).toArray();
                final Logger log = LOG;
                completionService.submit(new ThreadPools.TrackableCallable<Object>(){

                    public Object call() throws OXException {
                        StorageParameters newParameters = paramsProvider.getStorageParameters();
                        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(2);
                        if (tmp.startTransaction(newParameters, false)) {
                            openedStorages.add(tmp);
                        }
                        try {
                            List<Folder> folders2;
                            try {
                                ArrayList<String> ids = new ArrayList<String>(indexes.length);
                                for (int index : indexes) {
                                    ids.add(subfolderIds[index]);
                                }
                                folders2 = tmp.getFolders(treeId, ids, newParameters);
                                Set<OXException> warnings = newParameters.getWarnings();
                                if (!warnings.isEmpty()) {
                                    ListPerformer.this.addWarning(warnings.iterator().next());
                                }
                            }
                            catch (OXException e) {
                                log.warn("Batch loading of folder failed. Fall-back to one-by-one loading.", (Throwable)e);
                                folders2 = null;
                            }
                            if (null == folders2) {
                                for (int index : indexes) {
                                    Permission userPermission;
                                    Folder subfolder;
                                    String id = subfolderIds[index];
                                    try {
                                        subfolder = tmp.getFolder(treeId, id, newParameters);
                                    }
                                    catch (OXException e) {
                                        log.warn("The folder with ID \"{}\" in tree \"{}\" could not be fetched from storage \"{}\"", new Object[]{id, treeId, tmp.getClass().getSimpleName(), e});
                                        ListPerformer.this.addWarning(e);
                                        continue;
                                    }
                                    if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, ListPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                    subfolders[index] = ListPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages, checkOnly);
                                }
                            } else {
                                int size = folders2.size();
                                int j = 0;
                                for (int index : indexes) {
                                    Permission userPermission;
                                    if (j >= size) continue;
                                    Folder subfolder = folders2.get(j++);
                                    if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, ListPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                    subfolders[index] = ListPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages, checkOnly);
                                }
                            }
                            for (FolderStorage fs : openedStorages) {
                                fs.commitTransaction(newParameters);
                            }
                            return null;
                        }
                        catch (OXException e) {
                            for (FolderStorage fs : openedStorages) {
                                fs.rollback(newParameters);
                            }
                            throw e;
                        }
                        catch (RuntimeException e) {
                            for (FolderStorage fs : openedStorages) {
                                fs.rollback(newParameters);
                            }
                            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                        }
                    }
                });
                ++taskCount;
            }
            ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, FACTORY);
            return ListPerformer.trimArray(subfolders);
        }
        catch (OXException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private UserizedFolder[] getSubfoldersFromStorages(final String treeId, final String parentId, final boolean all, final boolean checkOnly) throws OXException {
        neededStorages = this.folderStorageDiscoverer.getFolderStoragesForParent(treeId, parentId);
        if (null == neededStorages || 0 == neededStorages.length) {
            return new UserizedFolder[0];
        }
        if (1 == neededStorages.length) {
            neededStorage = neededStorages[0];
            started = neededStorage.startTransaction(this.storageParameters, false);
            try {
                allSubfolderIds = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, this.storageParameters));
                if (!started) ** GOTO lbl37
                neededStorage.commitTransaction(this.storageParameters);
            }
            catch (OXException e) {
                if (started) {
                    neededStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (RuntimeException e) {
                if (started) {
                    neededStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
            }
        } else {
            allSubfolderIds = new ArrayList<E>(neededStorages.length * 8);
            threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true);
            completionService = new ThreadPoolCompletionService(threadPool);
            for (final FolderStorage neededStorage : neededStorages) {
                completionService.submit(new ThreadPools.TrackableCallable<List<SortableId>>(){

                    public List<SortableId> call() throws OXException {
                        StorageParameters newParameters = ListPerformer.this.newStorageParameters();
                        boolean started = neededStorage.startTransaction(newParameters, false);
                        try {
                            List<SortableId> l;
                            if (MailProperties.getInstance().isHidePOP3StorageFolders() && FOLDER_TYPE_MAIL.servesFolderId(parentId)) {
                                l = new ArrayList<SortableId>(Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters)));
                                FullnameArgument argument = MailFolderUtility.prepareMailFolderParam(parentId);
                                if (0 == argument.getAccountId()) {
                                    Set<String> pop3StorageFolders = RdbMailAccountStorage.getPOP3StorageFolders(ListPerformer.this.session);
                                    Iterator<SortableId> it = l.iterator();
                                    while (it.hasNext()) {
                                        if (!pop3StorageFolders.contains(it.next().getId())) continue;
                                        it.remove();
                                    }
                                }
                            } else {
                                l = Arrays.asList(neededStorage.getSubfolders(treeId, parentId, newParameters));
                            }
                            if (started) {
                                neededStorage.commitTransaction(newParameters);
                            }
                            return l;
                        }
                        catch (OXException e) {
                            if (started) {
                                neededStorage.rollback(newParameters);
                            }
                            ListPerformer.this.addWarning(e);
                            return Collections.emptyList();
                        }
                        catch (RuntimeException e) {
                            if (started) {
                                neededStorage.rollback(newParameters);
                            }
                            OXException OXException2 = FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                            ListPerformer.this.addWarning(OXException2);
                            return Collections.emptyList();
                        }
                    }
                });
            }
            results = ThreadPools.takeCompletionService((CompletionService)completionService, (int)neededStorages.length, ListPerformer.FACTORY);
            for (List result : results) {
                allSubfolderIds.addAll(result);
            }
            if (!results.isEmpty() && results.size() == this.getNumOfWarnings()) {
                e = this.getWarnings().iterator().next();
                e.addCategory(Category.CATEGORY_ERROR);
                throw e;
            }
        }
lbl37:
        // 4 sources

        Collections.sort(allSubfolderIds);
        size = allSubfolderIds.size();
        subfolders = new UserizedFolder[size];
        map = new HashMap<FolderStorage, TIntList>(4);
        for (i = 0; i < size; ++i) {
            id = ((SortableId)allSubfolderIds.get(i)).getId();
            tmp = this.folderStorageDiscoverer.getFolderStorage(treeId, id);
            if (null == tmp) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(new Object[]{treeId, id});
            }
            list = (TIntList)map.get(tmp);
            if (null == list) {
                list = new TIntArrayList();
                map.put(tmp, list);
            }
            list.add(i);
        }
        if (1 == map.size()) {
            completionService = new CallerRunsCompletionService();
            paramsProvider /* !! */  = new InstanceStorageParametersProvider(this.storageParameters);
        } else {
            completionService = new ThreadPoolCompletionService(ServerServiceRegistry.getInstance().getService(ThreadPoolService.class, true));
            paramsProvider /* !! */  = null == this.session ? new SessionStorageParametersProvider(this.user, this.context) : new SessionStorageParametersProvider(this.session);
        }
        performer = this;
        taskCount = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            tmp = (FolderStorage)entry.getKey();
            indexes = ((TIntList)entry.getValue()).toArray();
            log = ListPerformer.LOG;
            completionService.submit(new ThreadPools.TrackableCallable<Object>(){

                public Object call() throws Exception {
                    StorageParameters newParameters = paramsProvider.getStorageParameters();
                    ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(2);
                    if (tmp.startTransaction(newParameters, false)) {
                        openedStorages.add(tmp);
                    }
                    try {
                        List<Folder> folders2;
                        try {
                            ArrayList<String> ids = new ArrayList<String>(indexes.length);
                            for (int index : indexes) {
                                ids.add(((SortableId)allSubfolderIds.get(index)).getId());
                            }
                            folders2 = tmp.getFolders(treeId, ids, newParameters);
                            Set<OXException> warnings = newParameters.getWarnings();
                            if (!warnings.isEmpty()) {
                                ListPerformer.this.addWarning(warnings.iterator().next());
                            }
                        }
                        catch (OXException e) {
                            log.warn("Batch loading of folder failed. Fall-back to one-by-one loading.", (Throwable)e);
                            folders2 = null;
                        }
                        if (null == folders2) {
                            for (int index : indexes) {
                                Permission userPermission;
                                Folder subfolder;
                                String id = ((SortableId)allSubfolderIds.get(index)).getId();
                                try {
                                    subfolder = tmp.getFolder(treeId, id, newParameters);
                                }
                                catch (OXException e) {
                                    log.warn("The folder with ID \"{}\" in tree \"{}\" could not be fetched from storage \"{}\"", new Object[]{id, treeId, tmp.getClass().getSimpleName(), e});
                                    ListPerformer.this.addWarning(e);
                                    continue;
                                }
                                if (!all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, ListPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                subfolders[index] = ListPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages, checkOnly);
                            }
                        } else {
                            int size = folders2.size();
                            int j = 0;
                            for (int index : indexes) {
                                Permission userPermission;
                                Folder subfolder;
                                if (j >= size || null == (subfolder = folders2.get(j++)) || !all && !subfolder.isSubscribed() && !subfolder.hasSubscribedSubfolders() || !(userPermission = CalculatePermission.calculate(subfolder, performer, ListPerformer.this.getAllowedContentTypes())).isVisible()) continue;
                                subfolders[index] = ListPerformer.this.getUserizedFolder(subfolder, userPermission, treeId, all, true, newParameters, openedStorages, checkOnly);
                            }
                        }
                        for (FolderStorage fs : openedStorages) {
                            fs.commitTransaction(newParameters);
                        }
                        return null;
                    }
                    catch (OXException e) {
                        for (FolderStorage fs : openedStorages) {
                            fs.rollback(newParameters);
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        for (FolderStorage fs : openedStorages) {
                            fs.rollback(newParameters);
                        }
                        throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                    }
                }
            });
            ++taskCount;
        }
        ThreadPools.takeCompletionService((CompletionService)completionService, (int)taskCount, ListPerformer.FACTORY);
        return ListPerformer.trimArray(subfolders);
    }

    private static UserizedFolder[] trimArray(UserizedFolder[] userizedFolders) {
        if (null == userizedFolders) {
            return new UserizedFolder[0];
        }
        ArrayList<UserizedFolder> l = new ArrayList<UserizedFolder>(userizedFolders.length);
        for (UserizedFolder uf : userizedFolders) {
            if (null == uf || null == uf.getID()) continue;
            l.add(uf);
        }
        return l.toArray(new UserizedFolder[l.size()]);
    }
}

