/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractPerformer;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.outlook.DuplicateCleaner;
import com.openexchange.folderstorage.outlook.OutlookFolderStorage;
import com.openexchange.folderstorage.type.PublicType;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class CreatePerformer
extends AbstractUserizedFolderPerformer {
    private static final String CONTENT_TYPE_MAIL = MailContentType.getInstance().toString();
    private static final String CONTENT_TYPE_INFOSTORE = InfostoreContentType.getInstance().toString();

    public CreatePerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public CreatePerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public CreatePerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public CreatePerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    public String doCreate(Folder toCreate) throws OXException {
        String parentId = toCreate.getParentID();
        if (null == parentId) {
            throw FolderExceptionErrorMessage.MISSING_PARENT_ID.create(new Object[0]);
        }
        String treeId = toCreate.getTreeID();
        if (null == treeId) {
            throw FolderExceptionErrorMessage.MISSING_TREE_ID.create(new Object[0]);
        }
        if (!KNOWN_TREES.contains(treeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Create not supported by tree " + treeId);
        }
        FolderStorage parentStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, parentId);
        if (null == parentStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        ArrayList<FolderStorage> openedStorages = new ArrayList<FolderStorage>(4);
        this.checkOpenedStorage(parentStorage, openedStorages);
        try {
            String duplicateId;
            AbstractPerformer.CheckForDuplicateResult result;
            Folder parent = parentStorage.getFolder(treeId, parentId, this.storageParameters);
            Permission parentPermission = CalculatePermission.calculate(parent, this, (List<ContentType>)ALL_ALLOWED);
            if (!parentPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(parent), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            ContentType contentType = toCreate.getContentType();
            if (null == contentType) {
                throw AjaxExceptionCodes.MISSING_FIELD.create("module");
            }
            String cts = ((Object)contentType).toString();
            if ((FolderStorage.PUBLIC_ID.equals(parent.getID()) || PublicType.getInstance().equals(parent.getType())) && CONTENT_TYPE_MAIL.equals(cts)) {
                throw FolderExceptionErrorMessage.NO_PUBLIC_MAIL_FOLDER.create();
            }
            if (!CONTENT_TYPE_INFOSTORE.equals(cts)) {
                int resetLen;
                StringBuilder nameBuilder;
                int count;
                boolean useParenthesis;
                boolean autoRename;
                Session session = this.storageParameters.getSession();
                if (null == session) {
                    result = this.getCheckForDuplicateResult(toCreate.getName(), treeId, parentId, openedStorages);
                    if (null != result) {
                        autoRename = AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename"));
                        if (!autoRename) {
                            throw result.error;
                        }
                        useParenthesis = PARENTHESIS_CAPABLE.contains(cts);
                        count = 2;
                        nameBuilder = new StringBuilder(toCreate.getName());
                        resetLen = nameBuilder.length();
                        do {
                            nameBuilder.setLength(resetLen);
                            if (useParenthesis) {
                                nameBuilder.append(" (").append(count++).append(')');
                                continue;
                            }
                            nameBuilder.append(" ").append(count++);
                        } while (null != (result = this.getCheckForDuplicateResult(nameBuilder.toString(), treeId, parentId, openedStorages)));
                        toCreate.setName(nameBuilder.toString());
                    }
                } else {
                    result = this.getCheckForDuplicateResult(toCreate.getName(), treeId, parentId, openedStorages);
                    if (null != result) {
                        autoRename = AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename"));
                        if (!autoRename || result.error.similarTo((OXExceptionCode)FolderExceptionErrorMessage.RESERVED_NAME)) {
                            if (null != result.optFolderId && "USM-JSON".equals(session.getClient())) {
                                return result.optFolderId;
                            }
                            throw result.error;
                        }
                        useParenthesis = PARENTHESIS_CAPABLE.contains(cts);
                        count = 2;
                        nameBuilder = new StringBuilder(toCreate.getName());
                        resetLen = nameBuilder.length();
                        do {
                            nameBuilder.setLength(resetLen);
                            if (useParenthesis) {
                                nameBuilder.append(" (").append(count++).append(')');
                                continue;
                            }
                            nameBuilder.append(" ").append(count++);
                        } while (null != (result = this.getCheckForDuplicateResult(nameBuilder.toString(), treeId, parentId, openedStorages)));
                        toCreate.setName(nameBuilder.toString());
                    }
                }
            } else {
                boolean autoRename = AJAXRequestDataTools.parseBoolParameter(this.getDecoratorStringProperty("autorename"));
                if (autoRename && null != (result = this.getCheckForDuplicateResult(toCreate.getName(), treeId, parentId, openedStorages))) {
                    boolean useParenthesis = PARENTHESIS_CAPABLE.contains(cts);
                    int count = 2;
                    StringBuilder nameBuilder = new StringBuilder(toCreate.getName());
                    int resetLen = nameBuilder.length();
                    do {
                        nameBuilder.setLength(resetLen);
                        if (useParenthesis) {
                            nameBuilder.append(" (").append(count++).append(')');
                            continue;
                        }
                        nameBuilder.append(" ").append(count++);
                    } while (null != (result = this.getCheckForDuplicateResult(nameBuilder.toString(), treeId, parentId, openedStorages)));
                    toCreate.setName(nameBuilder.toString());
                }
            }
            String newId = FolderStorage.REAL_TREE_ID.equals(toCreate.getTreeID()) ? this.doCreateReal(toCreate, parentId, treeId, parentStorage) : this.doCreateVirtual(toCreate, parentId, treeId, parentStorage, openedStorages);
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.commitTransaction(this.storageParameters);
            }
            if (!FolderStorage.REAL_TREE_ID.equals(toCreate.getTreeID()) && null != (duplicateId = DuplicateCleaner.cleanDuplicates(treeId, this.storageParameters, newId))) {
                throw FolderExceptionErrorMessage.EQUAL_NAME.create(toCreate.getName(), parent.getLocalizedName(this.storageParameters.getUser().getLocale()), treeId);
            }
            Set<OXException> warnings = this.storageParameters.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
            return newId;
        }
        catch (OXException e) {
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.rollback(this.storageParameters);
            }
            throw e;
        }
        catch (Exception e) {
            for (FolderStorage folderStorage : openedStorages) {
                folderStorage.rollback(this.storageParameters);
            }
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
    }

    private String doCreateReal(Folder toCreate, String parentId, String treeId, FolderStorage parentStorage) throws OXException {
        ContentType[] contentTypes = parentStorage.getSupportedContentTypes();
        boolean supported = false;
        ContentType folderContentType = toCreate.getContentType();
        if (0 < contentTypes.length) {
            String cts = ((Object)folderContentType).toString();
            for (ContentType contentType : contentTypes) {
                if (!((Object)contentType).toString().equals(cts)) continue;
                supported = true;
                break;
            }
        } else {
            supported = true;
        }
        if (!supported) {
            throw FolderExceptionErrorMessage.INVALID_CONTENT_TYPE.create(parentId, ((Object)folderContentType).toString(), treeId, this.user.getId(), this.context.getContextId());
        }
        parentStorage.createFolder(toCreate, this.storageParameters);
        return toCreate.getID();
    }

    private String doCreateVirtual(Folder toCreate, String parentId, String treeId, FolderStorage virtualStorage, List<FolderStorage> openedStorages) throws OXException {
        ContentType folderContentType = toCreate.getContentType();
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, parentId);
        if (realStorage.equals(virtualStorage)) {
            virtualStorage.createFolder(toCreate, this.storageParameters);
        } else if (CreatePerformer.supportsContentType(folderContentType, realStorage)) {
            this.checkOpenedStorage(realStorage, openedStorages);
            realStorage.createFolder(toCreate, this.storageParameters);
            virtualStorage.createFolder(toCreate, this.storageParameters);
        } else {
            boolean found;
            List<ContentType> contentTypes;
            String rootId;
            Folder rootFolder;
            Permission rootPermission;
            FolderStorage capStorage = this.folderStorageDiscoverer.getFolderStorageByContentType(FolderStorage.REAL_TREE_ID, folderContentType);
            if (null == capStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(FolderStorage.REAL_TREE_ID, ((Object)folderContentType).toString());
            }
            this.checkOpenedStorage(capStorage, openedStorages);
            if (FolderStorage.PRIVATE_ID.equals(parentId) && CONTENT_TYPE_MAIL.equals(((Object)folderContentType).toString()) && (rootPermission = CalculatePermission.calculate(rootFolder = capStorage.getFolder(treeId, rootId = MailFolderUtility.prepareFullname(0, "default"), this.storageParameters), this, contentTypes = Collections.emptyList())).getFolderPermission() >= 8) {
                Folder clone4Real = (Folder)toCreate.clone();
                clone4Real.setParentID(rootId);
                capStorage.createFolder(clone4Real, this.storageParameters);
                toCreate.setID(clone4Real.getID());
                boolean started = realStorage.startTransaction(this.storageParameters, true);
                try {
                    realStorage.updateLastModified(System.currentTimeMillis(), FolderStorage.REAL_TREE_ID, parentId, this.storageParameters);
                    if (started) {
                        realStorage.commitTransaction(this.storageParameters);
                    }
                }
                catch (OXException e) {
                    if (started) {
                        realStorage.rollback(this.storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        realStorage.rollback(this.storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                OutlookFolderStorage.clearTCM();
                return toCreate.getID();
            }
            String realParentId = virtualStorage.getDefaultFolderID(this.user, treeId, null == folderContentType ? capStorage.getDefaultContentType() : folderContentType, virtualStorage.getTypeByParent(this.user, treeId, parentId, this.storageParameters), this.storageParameters);
            if (null == realParentId) {
                throw FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.create(capStorage.getDefaultContentType(), FolderStorage.REAL_TREE_ID);
            }
            Folder clone4Real = (Folder)toCreate.clone();
            clone4Real.setParentID(realParentId);
            SortableId[] subfolders = capStorage.getSubfolders(FolderStorage.REAL_TREE_ID, realParentId, this.storageParameters);
            String prefix = clone4Real.getName();
            int appendixCount = 2;
            do {
                found = false;
                String n = clone4Real.getName();
                for (int i = 0; !found && i < subfolders.length; ++i) {
                    if (!n.equals(capStorage.getFolder(FolderStorage.REAL_TREE_ID, subfolders[i].getId(), this.storageParameters).getName())) continue;
                    found = true;
                    clone4Real.setName(prefix + '_' + appendixCount++);
                }
            } while (found);
            capStorage.createFolder(clone4Real, this.storageParameters);
            toCreate.setID(clone4Real.getID());
            virtualStorage.createFolder(toCreate, this.storageParameters);
            boolean started = realStorage.startTransaction(this.storageParameters, true);
            try {
                realStorage.updateLastModified(System.currentTimeMillis(), FolderStorage.REAL_TREE_ID, parentId, this.storageParameters);
                if (started) {
                    realStorage.commitTransaction(this.storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return toCreate.getID();
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    private static boolean supportsContentType(ContentType folderContentType, FolderStorage folderStorage) {
        ContentType[] supportedContentTypes = folderStorage.getSupportedContentTypes();
        if (null == supportedContentTypes) {
            return false;
        }
        if (0 == supportedContentTypes.length) {
            return true;
        }
        String cts = ((Object)folderContentType).toString();
        for (ContentType supportedContentType : supportedContentTypes) {
            if (!((Object)supportedContentType).toString().equals(cts)) continue;
            return true;
        }
        return false;
    }
}

