/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.cache.osgi;

import com.openexchange.caching.CacheKey;
import com.openexchange.caching.events.CacheEvent;
import com.openexchange.caching.events.CacheEventService;
import com.openexchange.caching.events.CacheListener;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.cache.memory.FolderMapManagement;
import com.openexchange.folderstorage.internal.Tools;
import java.io.Serializable;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderMapInvalidator
implements CacheListener,
ServiceTrackerCustomizer<CacheEventService, CacheEventService> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderMapInvalidator.class);
    private final BundleContext context;

    public FolderMapInvalidator(BundleContext context) {
        this.context = context;
    }

    public void onEvent(Object sender, CacheEvent cacheEvent, boolean fromRemote) {
        block4: {
            String region;
            block5: {
                if (!fromRemote) break block4;
                LOGGER.debug("Handling incoming remote cache event: {}", (Object)cacheEvent);
                region = cacheEvent.getRegion();
                if (!"GlobalFolderCache".equals(region)) break block5;
                int contextId = Tools.getUnsignedInteger(cacheEvent.getGroupName());
                List cacheKeys = cacheEvent.getKeys();
                if (null == cacheKeys || 0 == cacheKeys.size()) {
                    FolderMapManagement.getInstance().dropFor(contextId);
                } else {
                    for (Serializable cacheKey : cacheKeys) {
                        String[] keys = ((CacheKey)cacheKey).getKeys();
                        String id = keys[1].toString();
                        String treeId = keys[0].toString();
                        this.removeFromUserCache(id, treeId, contextId);
                    }
                }
                break block4;
            }
            if (!"OXFolderCache".equals(region)) break block4;
            for (Serializable key : cacheEvent.getKeys()) {
                CacheKey cacheKey = (CacheKey)key;
                String id = cacheKey.getKeys()[0].toString();
                String treeId = FolderStorage.REAL_TREE_ID;
                this.removeFromUserCache(id, treeId, cacheKey.getContextId());
            }
        }
    }

    private void removeFromUserCache(String id, String treeId, int contextId) {
        FolderMapManagement.getInstance().dropFor(id, treeId, -1, contextId);
    }

    public CacheEventService addingService(ServiceReference<CacheEventService> reference) {
        CacheEventService service = (CacheEventService)this.context.getService(reference);
        service.addListener("GlobalFolderCache", (CacheListener)this);
        service.addListener("OXFolderCache", (CacheListener)this);
        return service;
    }

    public void modifiedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
    }

    public void removedService(ServiceReference<CacheEventService> reference, CacheEventService service) {
        service.removeListener("GlobalFolderCache", (CacheListener)this);
        service.removeListener("OXFolderCache", (CacheListener)this);
        this.context.ungetService(reference);
    }
}

