/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.context.osgi;

import com.openexchange.context.ContextService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WhiteboardContextService
implements ServiceTrackerCustomizer<ContextService, ContextService>,
ContextService {
    private final BundleContext context;
    private final ServiceTracker<ContextService, ContextService> tracker;
    private ContextService delegate;

    public WhiteboardContextService(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, ContextService.class, (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public ContextService addingService(ServiceReference<ContextService> reference) {
        this.delegate = (ContextService)this.context.getService(reference);
        return this.delegate;
    }

    public void modifiedService(ServiceReference<ContextService> reference, ContextService service) {
    }

    public void removedService(ServiceReference<ContextService> reference, ContextService service) {
        this.context.ungetService(reference);
        this.delegate = null;
    }

    public List<Integer> getAllContextIds() throws OXException {
        return this.getDelegate().getAllContextIds();
    }

    public Context getContext(int contextId) throws OXException {
        return this.getDelegate().getContext(contextId);
    }

    public Context loadContext(int contextId) throws OXException {
        return this.getDelegate().loadContext(contextId);
    }

    public int getContextId(String loginContextInfo) throws OXException {
        return this.getDelegate().getContextId(loginContextInfo);
    }

    public void invalidateContext(int contextId) throws OXException {
        this.getDelegate().invalidateContext(contextId);
    }

    public void invalidateLoginInfo(String loginContextInfo) throws OXException {
        this.getDelegate().invalidateLoginInfo(loginContextInfo);
    }

    private ContextService getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        ServiceReference serviceReference = this.context.getServiceReference(ContextService.class);
        if (serviceReference == null) {
            return null;
        }
        return (ContextService)this.context.getService(serviceReference);
    }
}

