/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.writer;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.customizer.folder.AdditionalFolderField;
import com.openexchange.ajax.customizer.folder.AdditionalFolderFieldList;
import com.openexchange.ajax.writer.DataWriter;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FolderWriter
extends DataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(FolderWriter.class);
    private static final int[] mapping = new int[]{0, -1, 1, -1, 2, -1, -1, -1, 4};
    final User user;
    final UserConfiguration userConfig;
    final Context ctx;
    final ServerSession session;
    private AdditionalFolderFieldList fields = null;
    private static final TIntObjectMap<FolderFieldWriter> STATIC_WRITERS_MAP = new TIntObjectHashMap(15);
    private static final int[] ALL_FLD_FIELDS;

    public FolderWriter(JSONWriter jw, Session session, Context ctx, String timeZone, AdditionalFolderFieldList fields) throws OXException {
        super(null == timeZone ? FolderWriter.getTimeZoneBySession(session, ctx) : TimeZoneUtils.getTimeZone(timeZone), jw);
        this.user = UserStorage.getInstance().getUser(session.getUserId(), ctx);
        this.userConfig = UserConfigurationStorage.getInstance().getUserConfigurationSafe(session.getUserId(), ctx);
        this.ctx = ctx;
        this.fields = fields;
        this.session = ServerSessionAdapter.valueOf(session, ctx, this.user, this.userConfig);
    }

    private static TimeZone getTimeZoneBySession(Session session, Context ctx) throws OXException {
        if (session instanceof ServerSession) {
            return TimeZoneUtils.getTimeZone(((ServerSession)session).getUser().getTimeZone());
        }
        return TimeZoneUtils.getTimeZone(UserStorage.getInstance().getUser(session.getUserId(), ctx).getTimeZone());
    }

    public void writeOXFolderFieldsAsObject(int[] fields, FolderObject fo, Locale locale) throws OXException {
        this.writeOXFolderFieldsAsObject(fields, fo, FolderObject.getFolderString(fo.getObjectID(), locale), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOXFolderFieldsAsObject(int[] fields, FolderObject fo, String name, int hasSubfolders) throws OXException {
        try {
            int[] fs;
            if (fields == null) {
                fs = ALL_FLD_FIELDS;
            } else {
                fs = new int[fields.length];
                System.arraycopy(fields, 0, fs, 0, fields.length);
            }
            FolderFieldWriter[] writers = this.getFolderFieldWriter(fs);
            this.jsonwriter.object();
            try {
                for (int i = 0; i < fs.length; ++i) {
                    writers[i].writeField(this.jsonwriter, fo, true, name, hasSubfolders);
                }
            }
            finally {
                this.jsonwriter.endObject();
            }
        }
        catch (JSONException e) {
            throw OXFolderExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw e;
        }
    }

    public void writeOXFolderFieldsAsArray(int[] fields, FolderObject fo, Locale locale) throws OXException {
        this.writeOXFolderFieldsAsArray(fields, fo, FolderObject.getFolderString(fo.getObjectID(), locale), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOXFolderFieldsAsArray(int[] fields, FolderObject fo, String name, int hasSubfolders) throws OXException {
        try {
            FolderFieldWriter[] writers = this.getFolderFieldWriter(fields);
            this.jsonwriter.array();
            try {
                for (int i = 0; i < fields.length; ++i) {
                    writers[i].writeField(this.jsonwriter, fo, false, name, hasSubfolders);
                }
            }
            finally {
                this.jsonwriter.endArray();
            }
        }
        catch (JSONException e) {
            throw OXFolderExceptionCode.JSON_ERROR.create(e, e.getMessage());
        }
        catch (SQLException e) {
            throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw e;
        }
    }

    public static int[] getAllFolderFields() {
        int[] retval = new int[ALL_FLD_FIELDS.length];
        System.arraycopy(ALL_FLD_FIELDS, 0, retval, 0, retval.length);
        return retval;
    }

    public FolderFieldWriter[] getFolderFieldWriter(int[] fields) {
        FolderFieldWriter[] retval = new FolderFieldWriter[fields.length];
        for (int i = 0; i < retval.length; ++i) {
            int field = fields[i];
            FolderFieldWriter ffw = (FolderFieldWriter)STATIC_WRITERS_MAP.get(field);
            if (ffw == null) {
                switch (field) {
                    case 4: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                                if (withKey) {
                                    if (fo.containsCreationDate()) {
                                        jsonwriter.key("creation_date");
                                        jsonwriter.value(FolderWriter.this.addTimeZoneOffset(fo.getCreationDate().getTime()));
                                    }
                                } else {
                                    jsonwriter.value(fo.containsCreationDate() ? Long.valueOf(FolderWriter.this.addTimeZoneOffset(fo.getCreationDate().getTime())) : JSONObject.NULL);
                                }
                            }
                        };
                        break;
                    }
                    case 5: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                                if (withKey) {
                                    if (fo.containsLastModified()) {
                                        jsonwriter.key("last_modified");
                                        jsonwriter.value(FolderWriter.this.addTimeZoneOffset(fo.getLastModified().getTime()));
                                    }
                                } else {
                                    jsonwriter.value(fo.containsLastModified() ? Long.valueOf(FolderWriter.this.addTimeZoneOffset(fo.getLastModified().getTime())) : JSONObject.NULL);
                                }
                            }
                        };
                        break;
                    }
                    case 6: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                                if (withKey) {
                                    if (fo.containsLastModified()) {
                                        jsonwriter.key("last_modified_utc");
                                        jsonwriter.value(fo.getLastModified().getTime());
                                    }
                                } else {
                                    jsonwriter.value(fo.containsLastModified() ? Long.valueOf(fo.getLastModified().getTime()) : JSONObject.NULL);
                                }
                            }
                        };
                        break;
                    }
                    case 302: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                                if (withKey) {
                                    if (fo.containsType()) {
                                        jsonwriter.key("type");
                                        jsonwriter.value((long)fo.getType(FolderWriter.this.user.getId()));
                                    }
                                } else {
                                    jsonwriter.value(fo.containsType() ? Integer.valueOf(fo.getType(FolderWriter.this.user.getId())) : JSONObject.NULL);
                                }
                            }
                        };
                        break;
                    }
                    case 304: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException, OXException, SearchIteratorException, SQLException {
                                boolean shared;
                                boolean bl = shared = fo.containsCreatedBy() && fo.containsType() && fo.isShared(FolderWriter.this.user.getId());
                                if (withKey) {
                                    if (hasSubfolders != -1 || shared || fo.containsSubfolderFlag()) {
                                        jsonwriter.key("subfolders");
                                        jsonwriter.value((Object)(hasSubfolders == -1 ? (shared ? Boolean.FALSE : Boolean.valueOf(fo.hasVisibleSubfolders(FolderWriter.this.user, FolderWriter.this.userConfig, FolderWriter.this.ctx))) : Boolean.valueOf(hasSubfolders > 0)));
                                    }
                                } else {
                                    jsonwriter.value(hasSubfolders == -1 ? (shared ? Boolean.FALSE : (fo.containsSubfolderFlag() ? Boolean.valueOf(fo.hasVisibleSubfolders(FolderWriter.this.user, FolderWriter.this.userConfig, FolderWriter.this.ctx)) : JSONObject.NULL)) : Boolean.valueOf(hasSubfolders > 0));
                                }
                            }
                        };
                        break;
                    }
                    case 305: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException, OXException, SQLException {
                                if (!fo.containsPermissions()) {
                                    try {
                                        fo.setPermissionsAsArray(FolderObject.getFolderPermissions(fo.getObjectID(), FolderWriter.this.ctx, null));
                                        if (FolderCacheManager.isEnabled()) {
                                            FolderCacheManager.getInstance().putFolderObject(fo, FolderWriter.this.ctx);
                                        }
                                    }
                                    catch (SQLException e) {
                                        throw OXFolderExceptionCode.MISSING_FOLDER_ATTRIBUTE.create(e, "own_rights", fo.getObjectID(), FolderWriter.this.ctx.getContextId());
                                    }
                                }
                                if (withKey) {
                                    jsonwriter.key("own_rights");
                                }
                                EffectivePermission effectivePerm = fo.getEffectiveUserPermission(FolderWriter.this.user.getId(), FolderWriter.this.userConfig);
                                jsonwriter.value((long)FolderWriter.createPermissionBits(((OCLPermission)effectivePerm).getFolderPermission(), ((OCLPermission)effectivePerm).getReadPermission(), ((OCLPermission)effectivePerm).getWritePermission(), ((OCLPermission)effectivePerm).getDeletePermission(), ((OCLPermission)effectivePerm).isFolderAdmin()));
                            }
                        };
                        break;
                    }
                    case 306: {
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException, OXException {
                                if (!fo.containsPermissions()) {
                                    try {
                                        fo.setPermissionsAsArray(FolderObject.getFolderPermissions(fo.getObjectID(), FolderWriter.this.ctx, null));
                                        if (FolderCacheManager.isEnabled()) {
                                            FolderCacheManager.getInstance().putFolderObject(fo, FolderWriter.this.ctx);
                                        }
                                    }
                                    catch (SQLException e) {
                                        throw OXFolderExceptionCode.MISSING_PARAMETER.create(e, "permissions");
                                    }
                                }
                                JSONArray ja = new JSONArray();
                                OCLPermission[] perms = fo.getPermissionsAsArray();
                                UserConfigurationStorage userConfStorage = UserConfigurationStorage.getInstance();
                                try {
                                    for (int k = 0; k < perms.length; ++k) {
                                        OCLPermission effectPerm;
                                        OCLPermission permission = perms[k];
                                        if (permission.isSystem()) continue;
                                        int entity = permission.getEntity();
                                        if (permission.isGroupPermission()) {
                                            effectPerm = permission;
                                        } else if (0 == entity) {
                                            effectPerm = permission;
                                            effectPerm.setGroupPermission(true);
                                        } else {
                                            effectPerm = fo.getEffectiveUserPermission(entity, userConfStorage.getUserConfiguration(entity, FolderWriter.this.ctx));
                                        }
                                        JSONObject jo = new JSONObject();
                                        jo.put("bits", FolderWriter.createPermissionBits(effectPerm));
                                        jo.put("entity", entity);
                                        jo.put("group", effectPerm.isGroupPermission());
                                        ja.put((Object)jo);
                                    }
                                }
                                catch (RuntimeException e) {
                                    throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, FolderWriter.this.ctx.getContextId());
                                }
                                if (withKey) {
                                    jsonwriter.key("permissions");
                                }
                                jsonwriter.value((Object)ja);
                            }
                        };
                        break;
                    }
                    default: {
                        if (!this.fields.knows(field)) {
                            LOG.warn("Unknown folder field: {}", (Object)field);
                        }
                        final AdditionalFolderField folderField = this.fields.get(field);
                        retval[i] = new FolderFieldWriter(){

                            @Override
                            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                                if (withKey) {
                                    if (folderField.getColumnName() == null) {
                                        return;
                                    }
                                    jsonwriter.key(folderField.getColumnName());
                                }
                                jsonwriter.value(folderField.renderJSON(folderField.getValue(fo, FolderWriter.this.session)));
                            }
                        };
                        break;
                    }
                }
                continue;
            }
            retval[i] = ffw;
        }
        return retval;
    }

    static int createPermissionBits(OCLPermission perm) throws OXException {
        return FolderWriter.createPermissionBits(perm.getFolderPermission(), perm.getReadPermission(), perm.getWritePermission(), perm.getDeletePermission(), perm.isFolderAdmin());
    }

    static int createPermissionBits(int fp, int orp, int owp, int odp, boolean adminFlag) throws OXException {
        int[] perms = new int[]{fp == 64 ? 128 : fp, orp == 64 ? 128 : orp, owp == 64 ? 128 : owp, odp == 64 ? 128 : odp, adminFlag ? 1 : 0};
        return FolderWriter.createPermissionBits(perms);
    }

    private static int createPermissionBits(int[] permission) throws OXException {
        int retval = 0;
        boolean first = true;
        for (int i = permission.length - 1; i >= 0; --i) {
            int shiftVal = i * 7;
            if (first) {
                retval += permission[i] << shiftVal;
                first = false;
                continue;
            }
            if (permission[i] == 128) {
                retval += 64 << shiftVal;
                continue;
            }
            try {
                retval += mapping[permission[i]] << shiftVal;
                continue;
            }
            catch (Exception e) {
                throw OXFolderExceptionCode.MAP_PERMISSION_FAILED.create(e, permission[i]);
            }
        }
        return retval;
    }

    protected long addTimeZoneOffset(long date) {
        return date + (long)this.timeZone.getOffset(date);
    }

    static {
        STATIC_WRITERS_MAP.put(1, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (!fo.containsObjectID()) {
                    if (withKey) {
                        if (fo.containsFullName()) {
                            jsonwriter.key("id");
                            jsonwriter.value((Object)fo.getFullName());
                        }
                    } else {
                        jsonwriter.value(fo.containsFullName() ? fo.getFullName() : JSONObject.NULL);
                    }
                    return;
                }
                if (withKey) {
                    jsonwriter.key("id");
                }
                jsonwriter.value((long)fo.getObjectID());
            }
        });
        STATIC_WRITERS_MAP.put(2, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (fo.containsCreatedBy()) {
                        jsonwriter.key("created_by");
                        jsonwriter.value((long)fo.getCreatedBy());
                    }
                } else {
                    jsonwriter.value(fo.containsCreatedBy() ? Integer.valueOf(fo.getCreatedBy()) : JSONObject.NULL);
                }
            }
        });
        STATIC_WRITERS_MAP.put(3, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (fo.containsModifiedBy()) {
                        jsonwriter.key("modified_by");
                        jsonwriter.value((long)fo.getModifiedBy());
                    }
                } else {
                    jsonwriter.value(fo.containsModifiedBy() ? Integer.valueOf(fo.getModifiedBy()) : JSONObject.NULL);
                }
            }
        });
        STATIC_WRITERS_MAP.put(20, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (fo.containsParentFolderID()) {
                        jsonwriter.key("folder_id");
                        jsonwriter.value((long)fo.getParentFolderID());
                    }
                } else {
                    jsonwriter.value(fo.containsParentFolderID() ? Integer.valueOf(fo.getParentFolderID()) : JSONObject.NULL);
                }
            }
        });
        STATIC_WRITERS_MAP.put(300, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (name != null || fo.containsFolderName()) {
                        jsonwriter.key("title");
                        jsonwriter.value((Object)(name == null ? fo.getFolderName() : name));
                    }
                } else {
                    jsonwriter.value(name == null ? (fo.containsFolderName() ? fo.getFolderName() : JSONObject.NULL) : name);
                }
            }
        });
        STATIC_WRITERS_MAP.put(301, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (fo.containsModule()) {
                        jsonwriter.key("module");
                        jsonwriter.value((Object)AJAXServlet.getModuleString(fo.getModule(), fo.getObjectID()));
                    }
                } else {
                    jsonwriter.value(fo.containsModule() ? AJAXServlet.getModuleString(fo.getModule(), fo.getObjectID()) : JSONObject.NULL);
                }
            }
        });
        STATIC_WRITERS_MAP.put(307, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    jsonwriter.key("summary");
                }
                jsonwriter.value((Object)"");
            }
        });
        STATIC_WRITERS_MAP.put(308, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    if (fo.containsDefaultFolder()) {
                        jsonwriter.key("standard_folder");
                        jsonwriter.value(fo.isDefaultFolder());
                    }
                } else {
                    jsonwriter.value(fo.containsDefaultFolder() ? Boolean.valueOf(fo.isDefaultFolder()) : JSONObject.NULL);
                }
            }
        });
        STATIC_WRITERS_MAP.put(309, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(310, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(311, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(312, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(313, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(314, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        STATIC_WRITERS_MAP.put(315, (Object)new FolderFieldWriter(){

            @Override
            public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey, String name, int hasSubfolders) throws JSONException {
                if (withKey) {
                    return;
                }
                jsonwriter.value(JSONObject.NULL);
            }
        });
        ALL_FLD_FIELDS = new int[]{1, 2, 3, 4, 5, 20, 300, 301, 302, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315};
    }

    public static abstract class FolderFieldWriter {
        protected FolderFieldWriter() {
        }

        public void writeField(JSONWriter jsonwriter, FolderObject fo, boolean withKey) throws JSONException, SQLException, OXException {
            this.writeField(jsonwriter, fo, withKey, null, -1);
        }

        public abstract void writeField(JSONWriter var1, FolderObject var2, boolean var3, String var4, int var5) throws JSONException, SQLException, OXException;
    }
}

