/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.container.ByteArrayFileHolder;
import com.openexchange.ajax.container.ByteArrayInputStreamClosure;
import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.container.IFileHolder;
import com.openexchange.ajax.helper.ImageUtils;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.ResponseRenderer;
import com.openexchange.ajax.requesthandler.cache.CachedResource;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.ajax.requesthandler.cache.ResourceCaches;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.config.ConfigurationService;
import com.openexchange.config.PropertyEvent;
import com.openexchange.config.PropertyListener;
import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.tools.images.Constants;
import com.openexchange.tools.images.ImageTransformationService;
import com.openexchange.tools.images.ImageTransformationUtility;
import com.openexchange.tools.images.ImageTransformations;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.TransformedImage;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileResponseRenderer
implements ResponseRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(FileResponseRenderer.class);
    private static final int DEFAULT_IN_MEMORY_THRESHOLD = 0x100000;
    private static final int INITIAL_CAPACITY = 8192;
    private static final int BUFLEN = 2048;
    private static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    private static final String PARAMETER_CONTENT_TYPE = "content_type";
    private static final String SAVE_AS_TYPE = "application/octet-stream";
    private volatile ImageTransformationService scaler;
    private static final String DELIVERY = AJAXServlet.PARAMETER_DELIVERY;
    private static final String DOWNLOAD = "download";
    private static final String VIEW = "view";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_BYTERANGES";
    private static final Pattern PATTERN_BYTE_RANGES = Pattern.compile("^bytes=\\d*-\\d*(,\\d*-\\d*)*$");
    private final AtomicReference<File> tmpDirReference;

    public FileResponseRenderer() {
        final AtomicReference<File> tmpDirReference = new AtomicReference<File>();
        this.tmpDirReference = tmpDirReference;
        ServerServiceRegistry registry = ServerServiceRegistry.getInstance();
        ConfigurationService cs = registry.getService(ConfigurationService.class);
        if (null == cs) {
            throw new IllegalStateException("Missing configuration service");
        }
        String path = cs.getProperty("UPLOAD_DIRECTORY", new PropertyListener(){

            public void onPropertyChange(PropertyEvent event) {
                if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                    tmpDirReference.set(FileResponseRenderer.getTmpDirByPath(event.getValue()));
                }
            }
        });
        tmpDirReference.set(FileResponseRenderer.getTmpDirByPath(path));
    }

    @Override
    public int getRanking() {
        return 0;
    }

    public void setScaler(ImageTransformationService scaler) {
        this.scaler = scaler;
    }

    @Override
    public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
        return result.getResultObject() instanceof IFileHolder;
    }

    @Override
    public void write(AJAXRequestData request, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        IFileHolder file = (IFileHolder)result.getResultObject();
        if (file == null || this.hasNoFileItem(file)) {
            try {
                resp.sendError(404);
            }
            catch (IOException e) {
                LOG.error("Exception while trying to write HTTP response.", (Throwable)e);
            }
            return;
        }
        this.writeFileHolder(file, request, result, req, resp);
    }

    /*
     * Exception decompiling
     */
    public void writeFileHolder(IFileHolder fileHolder, AJAXRequestData requestData, AJAXRequestResult result, HttpServletRequest req, HttpServletResponse resp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 23[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setContentLengthHeader(long length, HttpServletResponse resp) {
        if (length > 0L) {
            resp.setHeader("Accept-Ranges", "bytes");
            resp.setHeader("Content-Length", Long.toString(length));
        } else {
            resp.setHeader("Accept-Ranges", "none");
        }
    }

    private String getContentTypeByFileName(String fileName) {
        return null == fileName ? null : MimeType2ExtMap.getContentType(fileName, null);
    }

    private void sendErrorSafe(int sc, String msg, HttpServletResponse resp) {
        try {
            resp.sendError(sc, msg);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private boolean trySetSanitizedContentType(String contentType, String fallbackContentType, HttpServletResponse resp) {
        try {
            resp.setContentType(new ContentType(contentType).getBaseType());
            return true;
        }
        catch (Exception e) {
            resp.setContentType(fallbackContentType);
            return false;
        }
    }

    private void setHeaderSafe(String name, String value, HttpServletResponse resp) {
        try {
            resp.setHeader(name, value);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private IFileHolder transformIfImage(AJAXRequestData request, AJAXRequestResult result, IFileHolder fileHolder, String delivery) throws IOException, OXException {
        Boolean compress;
        Boolean rotate;
        boolean markSupported;
        String cacheKey;
        CachedResource cachedResource;
        String formatName;
        Boolean compress2;
        Boolean rotate2;
        ImageTransformationService scaler = this.scaler;
        if (null == scaler || !this.isImage(fileHolder)) {
            return fileHolder;
        }
        if (request.isSet("transformationNeeded") && !request.getParameter("transformationNeeded", Boolean.class).booleanValue()) {
            return fileHolder;
        }
        boolean transform = false;
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            transform = true;
        }
        if (!transform && (request.isSet("width") || request.isSet("height"))) {
            transform = true;
        }
        Boolean bl = rotate2 = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (!transform && null != rotate2 && rotate2.booleanValue()) {
            transform = true;
        }
        Boolean bl2 = compress2 = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (!transform && null != compress2 && compress2.booleanValue()) {
            transform = true;
        }
        if (!transform && ("jpeg".equals(formatName = this.toLowerCase(ImageTransformationUtility.getImageFormat(fileHolder.getContentType()))) || "jpg".equals(formatName)) && !DOWNLOAD.equalsIgnoreCase(delivery)) {
            transform = true;
        }
        if (!transform) {
            return fileHolder;
        }
        ResourceCache tmp = ResourceCaches.getResourceCache();
        final ResourceCache resourceCache = null == tmp ? null : (tmp.isEnabledFor(request.getSession().getContextId(), request.getSession().getUserId()) ? tmp : null);
        String eTag = result.getHeader("ETag");
        boolean isValidEtag = !Strings.isEmpty((String)eTag);
        String previewLanguage = AbstractPreviewResultConverter.getUserLanguage(request.getSession());
        if (null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", request, true) && null != (cachedResource = resourceCache.get(cacheKey = ResourceCaches.generatePreviewCacheKey(eTag, request, previewLanguage), 0, request.getSession().getContextId()))) {
            IFileHolder ret;
            InputStream inputStream;
            String contentType = cachedResource.getFileType();
            if (null == contentType) {
                contentType = "image/jpeg";
            }
            if (null == (inputStream = cachedResource.getInputStream())) {
                ByteArrayFileHolder responseFileHolder = new ByteArrayFileHolder(cachedResource.getBytes());
                responseFileHolder.setContentType(contentType);
                responseFileHolder.setName(cachedResource.getFileName());
                ret = responseFileHolder;
            } else {
                ret = new FileHolder(inputStream, cachedResource.getSize(), contentType, cachedResource.getFileName());
            }
            return ret;
        }
        IFileHolder file = fileHolder;
        InputStream stream = file.getStream();
        if (null == stream) {
            LOG.warn("(Possible) Image file misses stream data");
            return file;
        }
        if (file.repetitive()) {
            if (ImageUtils.isAnimatedGif(stream)) {
                return fileHolder;
            }
            stream = file.getStream();
        } else {
            AtomicReference<InputStream> ref = new AtomicReference<InputStream>();
            if (ImageUtils.isAnimatedGif(stream, ref)) {
                return new FileHolder(ref.get(), -1L, file.getContentType(), file.getName());
            }
            stream = ref.get();
        }
        boolean bl3 = markSupported = file.repetitive() ? false : stream.markSupported();
        if (markSupported) {
            stream.mark(131072);
        }
        ImageTransformations transformations = scaler.transfom(stream, (Object)request.getSession().getSessionID());
        Boolean bl4 = rotate = request.isSet("rotate") ? request.getParameter("rotate", Boolean.class) : null;
        if (null == rotate && !DOWNLOAD.equalsIgnoreCase(delivery) || null != rotate && rotate.booleanValue()) {
            transformations.rotate();
        }
        if (request.isSet("cropWidth") || request.isSet("cropHeight")) {
            int cropX = request.isSet("cropX") ? request.getParameter("cropX", Integer.TYPE) : 0;
            int cropY = request.isSet("cropY") ? request.getParameter("cropY", Integer.TYPE) : 0;
            int cropWidth = request.getParameter("cropWidth", Integer.TYPE);
            int cropHeight = request.getParameter("cropHeight", Integer.TYPE);
            transformations.crop(cropX, cropY, cropWidth, cropHeight);
        }
        if (request.isSet("width") || request.isSet("height")) {
            int maxHeight;
            int maxWidth;
            int n = maxWidth = request.isSet("width") ? request.getParameter("width", Integer.TYPE) : 0;
            if (maxWidth > Constants.getMaxWidth()) {
                throw AjaxExceptionCodes.BAD_REQUEST.create("Width " + maxWidth + " exceeds max. supported width " + Constants.getMaxWidth());
            }
            int n2 = maxHeight = request.isSet("height") ? request.getParameter("height", Integer.TYPE) : 0;
            if (maxHeight > Constants.getMaxHeight()) {
                throw AjaxExceptionCodes.BAD_REQUEST.create("Height " + maxHeight + " exceeds max. supported height " + Constants.getMaxHeight());
            }
            ScaleType scaleType = ScaleType.getType(request.getParameter("scaleType"));
            try {
                transformations.scale(maxWidth, maxHeight, scaleType);
            }
            catch (IllegalArgumentException e) {
                throw AjaxExceptionCodes.BAD_REQUEST_CUSTOM.create(e, e.getMessage());
            }
        }
        Boolean bl5 = compress = request.isSet("compress") ? request.getParameter("compress", Boolean.class) : null;
        if (null == compress && !DOWNLOAD.equalsIgnoreCase(delivery) || null != compress && compress.booleanValue()) {
            transformations.compress();
        }
        boolean cachingAdvised = false;
        try {
            byte[] transformed;
            String contentTypeByFileName;
            String fileContentType = file.getContentType();
            if (!(null != fileContentType && Strings.toLowerCase((CharSequence)fileContentType).startsWith("image/") || null == (contentTypeByFileName = this.getContentTypeByFileName(file.getName())))) {
                fileContentType = contentTypeByFileName;
            }
            try {
                TransformedImage transformedImage = transformations.getTransformedImage(fileContentType);
                int expenses = transformedImage.getTransformationExpenses();
                if (expenses >= 3) {
                    cachingAdvised = true;
                }
                transformed = transformedImage.getImageData();
            }
            catch (IOException ioe) {
                if ("Unsupported Image Type".equals(ioe.getMessage())) {
                    return this.handleFailure(file, stream, markSupported);
                }
                throw ioe;
            }
            if (null == transformed) {
                LOG.debug("Got no resulting input stream from transformation, trying to recover original input");
                return this.handleFailure(file, stream, markSupported);
            }
            if (!(cachingAdvised && null != resourceCache && isValidEtag && AJAXRequestDataTools.parseBoolParameter("cache", request, true))) {
                return new FileHolder(Streams.newByteArrayInputStream((byte[])transformed), -1L, fileContentType, file.getName());
            }
            final int size = transformed.length;
            final String cacheKey2 = ResourceCaches.generatePreviewCacheKey(eTag, request, new String[0]);
            final ServerSession session = request.getSession();
            final String fileName = file.getName();
            final String contentType = fileContentType;
            AbstractTask<Void> task = new AbstractTask<Void>(){

                public Void call() {
                    try {
                        CachedResource preview = new CachedResource(transformed, fileName, contentType, (long)size);
                        resourceCache.save(cacheKey2, preview, 0, session.getContextId());
                    }
                    catch (OXException e) {
                        LOG.warn("Could not cache preview.", (Throwable)e);
                    }
                    return null;
                }
            };
            ThreadPoolService threadPool = ServerServiceRegistry.getInstance().getService(ThreadPoolService.class);
            if (null == threadPool) {
                Thread thread = Thread.currentThread();
                boolean ran = false;
                task.beforeExecute(thread);
                try {
                    task.call();
                    ran = true;
                    task.afterExecute(null);
                }
                catch (Exception ex) {
                    if (!ran) {
                        task.afterExecute((Throwable)ex);
                    }
                    throw ex instanceof OXException ? (OXException)((Object)ex) : AjaxExceptionCodes.UNEXPECTED_ERROR.create(ex, ex.getMessage());
                }
            } else {
                threadPool.submit((Task)task);
            }
            return new FileHolder(new ByteArrayInputStreamClosure(transformed), (long)size, contentType, fileName);
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled() && file.repetitive()) {
                try {
                    File tmpFile = this.writeBrokenImage2Disk(file);
                    LOG.error("Unable to transform image from {}. Unparseable image file is written to disk at: {}", (Object)file.getName(), (Object)tmpFile.getPath());
                }
                catch (Exception x) {
                    LOG.error("Unable to transform image from {}", (Object)file.getName());
                }
            } else {
                LOG.error("Unable to transform image from {}", (Object)file.getName());
            }
            return file.repetitive() ? file : null;
        }
    }

    private IFileHolder handleFailure(IFileHolder file, InputStream stream, boolean markSupported) {
        if (markSupported) {
            try {
                stream.reset();
                return file;
            }
            catch (Exception e) {
                LOG.warn("Error resetting input stream", (Throwable)e);
            }
        }
        LOG.warn("Unable to transform image from {}", (Object)file.getName());
        return file.repetitive() ? file : null;
    }

    private String checkedContentDisposition(String contentDisposition, IFileHolder file) {
        String ct = this.toLowerCase(file.getContentType());
        if (null == ct || ct.startsWith("text/htm")) {
            int pos = contentDisposition.indexOf(59);
            return pos > 0 ? "attachment" + contentDisposition.substring(pos) : "attachment";
        }
        return contentDisposition;
    }

    private boolean isImage(IFileHolder file) {
        String fileName;
        if (0L == file.getLength()) {
            return false;
        }
        String contentType = file.getContentType();
        return null != contentType && contentType.startsWith("image/") || (fileName = file.getName()) != null && (contentType = MimeType2ExtMap.getContentType(fileName)).startsWith("image/");
    }

    private String toLowerCase(CharSequence chars) {
        if (null == chars) {
            return null;
        }
        int length = chars.length();
        StringBuilder builder = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = chars.charAt(i);
            builder.append(c >= 'A' && c <= 'Z' ? (char)(c ^ 0x20) : c);
        }
        return builder.toString();
    }

    private String unquote(String s) {
        if (!Strings.isEmpty((String)s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private String getPrimaryType(String contentType) {
        if (Strings.isEmpty((String)contentType)) {
            return contentType;
        }
        int pos = contentType.indexOf(47);
        return pos > 0 ? contentType.substring(0, pos) : contentType;
    }

    private boolean equalPrimaryTypes(String contentType1, String contentType2) {
        if (null == contentType1 || null == contentType2) {
            return false;
        }
        return this.toLowerCase(this.getPrimaryType(contentType1)).startsWith(this.toLowerCase(this.getPrimaryType(contentType2)));
    }

    private String detectMimeType(InputStream in) throws IOException {
        return AJAXUtility.detectMimeType(in);
    }

    private long sublong(String value, int beginIndex, int endIndex) {
        String substring = value.substring(beginIndex, endIndex);
        return substring.length() > 0 ? Long.parseLong(substring) : -1L;
    }

    private void copy(InputStream inputStream, OutputStream output, long start, long length) throws IOException {
        int read;
        InputStream input = !(inputStream instanceof BufferedInputStream) && !(inputStream instanceof ByteArrayInputStream) ? new BufferedInputStream(inputStream, 8192) : inputStream;
        int i = 0;
        while ((long)i < start) {
            if (input.read() < 0) {
                throw new OffsetOutOfRangeIOException(start, i);
            }
            ++i;
        }
        long toRead = length;
        byte[] buffer = new byte[2048];
        while ((read = input.read(buffer)) > 0) {
            if ((toRead -= (long)read) > 0L) {
                output.write(buffer, 0, read);
                continue;
            }
            output.write(buffer, 0, (int)toRead + read);
            break;
        }
    }

    private boolean hasNoFileItem(IFileHolder file) {
        String fileMIMEType = file.getContentType();
        return (Strings.isEmpty((String)fileMIMEType) || SAVE_AS_TYPE.equals(fileMIMEType)) && Strings.isEmpty((String)file.getName()) && file.getLength() <= 0L;
    }

    static File getTmpDirByPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("Path is null. Probably property \"UPLOAD_DIRECTORY\" is not set.");
        }
        File tmpDir = new File(path);
        if (!tmpDir.exists()) {
            throw new IllegalArgumentException("Directory " + path + " does not exist.");
        }
        if (!tmpDir.isDirectory()) {
            throw new IllegalArgumentException(path + " is not a directory.");
        }
        return tmpDir;
    }

    private File writeBrokenImage2Disk(IFileHolder file) throws IOException, OXException, FileNotFoundException {
        String contentType;
        int pos;
        String suffix = null;
        String name = file.getName();
        if (null != name && (pos = name.lastIndexOf(46)) > 0 && pos < name.length() - 1) {
            suffix = name.substring(pos);
        }
        if (null == suffix && null != (contentType = file.getContentType())) {
            suffix = "." + MimeType2ExtMap.getFileExtension(contentType);
        }
        return this.write2Disk(file, "brokenimage-", suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File write2Disk(IFileHolder file, String prefix, String suffix) throws IOException, OXException, FileNotFoundException {
        File directory = this.tmpDirReference.get();
        File newFile = File.createTempFile(null == prefix ? "open-xchange-" : prefix, null == suffix ? ".tmp" : suffix, directory);
        InputStream is = file.getStream();
        FileOutputStream out = new FileOutputStream(newFile);
        try {
            int read;
            int len = 8192;
            byte[] buf = new byte[8192];
            while ((read = is.read(buf, 0, 8192)) > 0) {
                ((OutputStream)out).write(buf, 0, read);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            Streams.close((Closeable[])new Closeable[]{is, out});
            throw throwable;
        }
        Streams.close((Closeable[])new Closeable[]{is, out});
        return newFile;
    }

    private static final class FileManagementPropertyListener
    implements PropertyListener {
        private final AtomicReference<File> ttmpDirReference;

        FileManagementPropertyListener(AtomicReference<File> tmpDirReference) {
            this.ttmpDirReference = tmpDirReference;
        }

        public void onPropertyChange(PropertyEvent event) {
            if (PropertyEvent.Type.CHANGED.equals((Object)event.getType())) {
                this.ttmpDirReference.set(FileResponseRenderer.getTmpDirByPath(event.getValue()));
            }
        }
    }

    private static final class OffsetOutOfRangeIOException
    extends IOException {
        private static final long serialVersionUID = 8094333124726048736L;
        private final long off;
        private final long available;

        public OffsetOutOfRangeIOException(long off, long available) {
            super("Offset " + off + " out of range. Got only " + available);
            this.off = off;
            this.available = available;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public long getOff() {
            return this.off;
        }

        public long getAvailable() {
            return this.available;
        }
    }

    private static final class Range {
        final long start;
        final long end;
        final long length;
        final long total;

        Range(long start, long end, long total) {
            this.start = start;
            this.end = end;
            this.length = end - start + 1L;
            this.total = total;
        }
    }
}

