/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json.osgi;

import com.openexchange.ajax.osgi.AbstractSessionServletActivator;
import com.openexchange.config.ConfigurationService;
import com.openexchange.dispatcher.DispatcherPrefixService;
import com.openexchange.multiple.MultipleHandlerFactoryService;
import com.openexchange.publish.PublicationTargetDiscoveryService;
import com.openexchange.publish.json.PublicationMultipleHandlerFactory;
import com.openexchange.publish.json.PublicationServlet;
import com.openexchange.publish.json.PublicationTargetMultipleHandlerFactory;
import com.openexchange.publish.json.PublicationTargetServlet;
import com.openexchange.publish.json.types.EntityMap;
import javax.servlet.http.HttpServlet;

public class ServletActivator
extends AbstractSessionServletActivator {
    private static final String TARGET_ALIAS_APPENDIX = "publicationTargets";
    private static final String PUB_ALIAS_APPENDIX = "publications";

    protected void handleAvailability(Class<?> clazz) {
        this.register();
    }

    private void register() {
        PublicationTargetDiscoveryService discovery = (PublicationTargetDiscoveryService)this.getService(PublicationTargetDiscoveryService.class);
        if (discovery == null) {
            return;
        }
        ConfigurationService config = (ConfigurationService)this.getService(ConfigurationService.class);
        if (config == null) {
            return;
        }
        PublicationMultipleHandlerFactory publicationHandlerFactory = new PublicationMultipleHandlerFactory(discovery, new EntityMap(), config);
        PublicationTargetMultipleHandlerFactory publicationTargetHandlerFactory = new PublicationTargetMultipleHandlerFactory(discovery);
        this.registerService(MultipleHandlerFactoryService.class, publicationHandlerFactory, null);
        this.registerService(MultipleHandlerFactoryService.class, publicationTargetHandlerFactory, null);
        PublicationServlet.setFactory(publicationHandlerFactory);
        PublicationTargetServlet.setFactory(publicationTargetHandlerFactory);
        String prefix = ((DispatcherPrefixService)this.getService(DispatcherPrefixService.class)).getPrefix();
        this.registerSessionServlet(prefix + TARGET_ALIAS_APPENDIX, (HttpServlet)new PublicationTargetServlet(), new String[0]);
        this.registerSessionServlet(prefix + PUB_ALIAS_APPENDIX, (HttpServlet)new PublicationServlet(), new String[0]);
    }

    protected void handleUnavailability(Class<?> clazz) {
        this.unregister();
    }

    private void unregister() {
        PublicationServlet.setFactory(null);
        PublicationTargetServlet.setFactory(null);
        this.cleanUp();
    }

    protected void startBundle() throws Exception {
        this.register();
    }

    protected void stopBundle() throws Exception {
        this.unregister();
    }

    protected Class<?>[] getAdditionalNeededServices() {
        return new Class[]{PublicationTargetDiscoveryService.class, ConfigurationService.class, DispatcherPrefixService.class};
    }
}

