/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.publish.json;

import com.openexchange.datatypes.genericonf.DynamicFormDescription;
import com.openexchange.datatypes.genericonf.FormElement;
import com.openexchange.datatypes.genericonf.WidgetSwitcher;
import com.openexchange.datatypes.genericonf.json.FormContentWriter;
import com.openexchange.datatypes.genericonf.json.ValueWriterSwitch;
import com.openexchange.exception.OXException;
import com.openexchange.publish.Publication;
import com.openexchange.publish.json.EntityType;
import com.openexchange.publish.json.PublicationJSONErrorMessage;
import com.openexchange.publish.json.types.EntityMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PublicationWriter {
    private static final ValueWriterSwitch valueWrite = new ValueWriterSwitch();
    private final Map<String, EntityType> entityTypes = new EntityMap();

    public JSONObject write(Publication publication, String urlPrefix, TimeZone tz) throws JSONException, OXException {
        if (null == publication) {
            return null;
        }
        JSONObject object = new JSONObject();
        object.put("id", publication.getId());
        object.put("entity", (Object)this.writeEntity(publication));
        object.put("entityModule", (Object)publication.getModule());
        object.put("enabled", publication.isEnabled());
        object.put("displayName", (Object)publication.getDisplayName());
        object.put("created", publication.getCreated() + (long)tz.getOffset(publication.getCreated()));
        String targetId = publication.getTarget().getId();
        object.put("target", (Object)targetId);
        object.put(targetId, (Object)FormContentWriter.write((DynamicFormDescription)publication.getTarget().getFormDescription(), (Map)publication.getConfiguration(), (String)urlPrefix));
        return object;
    }

    public JSONArray writeArray(Publication publication, String[] basicCols, Map<String, String[]> specialCols, List<String> specialsList, DynamicFormDescription form, TimeZone tz) throws OXException, JSONException {
        JSONArray array = new JSONArray();
        this.writeBasicCols(array, publication, basicCols, tz);
        for (String identifier : specialsList) {
            this.writeSpecialCols(array, publication, specialCols.get(identifier), identifier, form);
        }
        return array;
    }

    private void writeSpecialCols(JSONArray array, Publication publication, String[] strings, String externalId, DynamicFormDescription form) {
        if (strings == null) {
            return;
        }
        boolean writeNulls = !publication.getTarget().getId().equals(externalId);
        Map configuration = publication.getConfiguration();
        for (String col : strings) {
            if (writeNulls) {
                array.put(JSONObject.NULL);
                continue;
            }
            Object value = configuration.get(col);
            FormElement field = form.getField(col);
            value = field.doSwitch((WidgetSwitcher)valueWrite, new Object[]{value});
            array.put(value);
        }
    }

    private void writeBasicCols(JSONArray array, Publication publication, String[] basicCols, TimeZone tz) throws OXException, JSONException {
        for (String basicCol : basicCols) {
            if ("id".equals(basicCol)) {
                array.put(publication.getId());
                continue;
            }
            if ("entity".equals(basicCol)) {
                array.put((Object)this.writeEntity(publication));
                continue;
            }
            if ("entityModule".equals(basicCol)) {
                array.put((Object)publication.getModule());
                continue;
            }
            if ("target".equals(basicCol)) {
                array.put((Object)publication.getTarget().getId());
                continue;
            }
            if ("displayName".equals(basicCol)) {
                array.put((Object)publication.getDisplayName());
                continue;
            }
            if ("enabled".equals(basicCol)) {
                array.put(publication.isEnabled());
                continue;
            }
            if ("created".equals(basicCol)) {
                array.put(publication.getCreated() + (long)tz.getOffset(publication.getCreated()));
                continue;
            }
            throw PublicationJSONErrorMessage.UNKNOWN_COLUMN.create(basicCol);
        }
    }

    private JSONObject writeEntity(Publication publication) throws OXException, JSONException {
        if (publication.getModule() == null) {
            return new JSONObject();
        }
        EntityType type = this.entityTypes.get(publication.getModule());
        if (type == null) {
            throw PublicationJSONErrorMessage.UNKOWN_ENTITY_MODULE.create(publication.getModule());
        }
        return type.toEntity(publication.getEntityId());
    }

    public void registerEntityType(String module, EntityType entityType) {
        this.entityTypes.put(module, entityType);
    }
}

