/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.messaging.generic.internal;

import com.openexchange.caching.Cache;
import com.openexchange.caching.CacheKey;
import com.openexchange.caching.CacheService;
import com.openexchange.exception.OXException;
import com.openexchange.messaging.MessagingAccount;
import com.openexchange.messaging.MessagingService;
import com.openexchange.messaging.generic.internal.MessagingAccountStorage;
import com.openexchange.messaging.generic.internal.Modifier;
import com.openexchange.messaging.generic.internal.RdbMessagingAccountStorage;
import com.openexchange.messaging.generic.services.MessagingGenericServiceRegistry;
import com.openexchange.session.Session;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.procedure.TIntProcedure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class CachingMessagingAccountStorage
implements MessagingAccountStorage {
    private static final CachingMessagingAccountStorage INSTANCE = new CachingMessagingAccountStorage();
    private static final String REGION_NAME = "MessagingAccount";
    private final RdbMessagingAccountStorage delegatee = RdbMessagingAccountStorage.getInstance();

    public static String getRegionName() {
        return REGION_NAME;
    }

    public static CachingMessagingAccountStorage getInstance() {
        return INSTANCE;
    }

    static CacheKey newCacheKey(CacheService cacheService, String serviceId, int id, int userId, int contextId) {
        return cacheService.newCacheKey(contextId, new String[]{serviceId, Integer.toString(id), Integer.toString(userId)});
    }

    private static void invalidateMessagingAccount(String serviceId, int id, int userId, int contextId) throws OXException {
        CacheService cacheService = MessagingGenericServiceRegistry.getService(CacheService.class);
        if (null != cacheService) {
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingMessagingAccountStorage.newCacheKey(cacheService, serviceId, id, userId, contextId));
            cache.remove((Serializable)CachingMessagingAccountStorage.accountIDsCacheKey(cacheService, serviceId, userId, contextId));
        }
    }

    static CacheKey accountIDsCacheKey(CacheService cacheService, String serviceId, int userId, int contextId) {
        return cacheService.newCacheKey(contextId, new String[]{serviceId, Integer.toString(userId)});
    }

    private static void invalidateAccounts(String serviceId, int userId, int contextId) throws OXException {
        CacheService cacheService = MessagingGenericServiceRegistry.getService(CacheService.class);
        if (null != cacheService) {
            Cache cache = cacheService.getCache(REGION_NAME);
            cache.remove((Serializable)CachingMessagingAccountStorage.accountIDsCacheKey(cacheService, serviceId, userId, contextId));
        }
    }

    private CachingMessagingAccountStorage() {
    }

    public void invalidate(String serviceId, int id, int user, int contextId) throws OXException {
        CachingMessagingAccountStorage.invalidateMessagingAccount(serviceId, id, user, contextId);
    }

    @Override
    public int addAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        int identifier = this.delegatee.addAccount(serviceId, account, session, modifier);
        CachingMessagingAccountStorage.invalidateAccounts(serviceId, session.getUserId(), session.getContextId());
        return identifier;
    }

    @Override
    public void deleteAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        this.delegatee.deleteAccount(serviceId, account, session, modifier);
        CachingMessagingAccountStorage.invalidateMessagingAccount(serviceId, account.getId(), session.getUserId(), session.getContextId());
    }

    @Override
    public MessagingAccount getAccount(String serviceId, int id, Session session, Modifier modifier) throws OXException {
        CacheKey cacheKey;
        CacheService cacheService = MessagingGenericServiceRegistry.getService(CacheService.class);
        if (cacheService == null) {
            return this.delegatee.getAccount(serviceId, id, session, modifier);
        }
        Cache cache = cacheService.getCache(REGION_NAME);
        Object object = cache.get((Serializable)(cacheKey = CachingMessagingAccountStorage.newCacheKey(cacheService, serviceId, id, session.getUserId(), session.getContextId())));
        if (object instanceof MessagingAccount) {
            return (MessagingAccount)object;
        }
        MessagingAccount messagingAccount = this.delegatee.getAccount(serviceId, id, session, modifier);
        cache.put((Serializable)cacheKey, (Serializable)messagingAccount, false);
        return messagingAccount;
    }

    @Override
    public List<MessagingAccount> getAccounts(final String serviceId, final Session session, final Modifier modifier) throws OXException {
        TIntArrayList ids;
        CacheService cacheService = MessagingGenericServiceRegistry.getService(CacheService.class);
        if (cacheService == null) {
            ids = this.delegatee.getAccountIDs(serviceId, session);
        } else {
            CacheKey accountsKey;
            Cache cache = cacheService.getCache(REGION_NAME);
            Object object = cache.get((Serializable)(accountsKey = CachingMessagingAccountStorage.accountIDsCacheKey(cacheService, serviceId, session.getUserId(), session.getContextId())));
            if (object instanceof TIntArrayList) {
                ids = (TIntArrayList)object;
            } else {
                ids = this.delegatee.getAccountIDs(serviceId, session);
                cache.put((Serializable)accountsKey, (Serializable)ids, false);
            }
        }
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        final ArrayList<MessagingAccount> accounts = new ArrayList<MessagingAccount>(ids.size());
        class AdderProcedure
        implements TIntProcedure {
            OXException me;

            AdderProcedure() {
            }

            public boolean execute(int id) {
                try {
                    accounts.add(CachingMessagingAccountStorage.this.getAccount(serviceId, id, session, modifier));
                    return true;
                }
                catch (OXException e) {
                    this.me = e;
                    return false;
                }
            }
        }
        AdderProcedure ap = new AdderProcedure();
        if (!ids.forEach((TIntProcedure)ap) && null != ap.me) {
            throw ap.me;
        }
        return accounts;
    }

    @Override
    public void updateAccount(String serviceId, MessagingAccount account, Session session, Modifier modifier) throws OXException {
        this.delegatee.updateAccount(serviceId, account, session, modifier);
        CachingMessagingAccountStorage.invalidateMessagingAccount(serviceId, account.getId(), session.getUserId(), session.getContextId());
    }

    public String checkSecretCanDecryptStrings(MessagingService parentService, Session session, String secret) throws OXException {
        return this.delegatee.checkSecretCanDecryptStrings(parentService, session, secret);
    }

    public void migrateToNewSecret(MessagingService parentService, String oldSecret, String newSecret, Session session) throws OXException {
        this.delegatee.migrateToNewSecret(parentService, oldSecret, newSecret, session);
    }

    public boolean hasAccount(MessagingService service, Session session) throws OXException {
        return this.delegatee.hasAccount(service, session);
    }

    public void cleanUp(MessagingService service, String secret, Session session) throws OXException {
        this.delegatee.cleanUp(service, secret, session);
    }

    public void removeUnrecoverableItems(MessagingService service, String secret, Session session) throws OXException {
        this.delegatee.removeUnrecoverableItems(service, secret, session);
    }
}

