/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.exception.interception;

public class Responsibility {
    private final String module;
    private final String action;
    private final int hash;

    public Responsibility(String module, String action) {
        if (module == null) {
            throw new IllegalArgumentException("Module might not be null");
        }
        if (action == null) {
            throw new IllegalArgumentException("Action might not be null");
        }
        this.module = module;
        this.action = action;
        this.hash = module.hashCode() ^ action.hashCode();
    }

    public String getModule() {
        return this.module;
    }

    public String getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Responsibility)) {
            return false;
        }
        Responsibility pairo = (Responsibility)o;
        return this.module.equals(pairo.getModule()) && this.action.equals(pairo.getAction());
    }

    public int hashCode() {
        return this.hash;
    }
}

