/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import java.util.Locale;

public class ListTest
extends FolderTest {
    public ListTest(String name) {
        super(name);
    }

    public void testPropFindWithModified() throws Exception {
        FolderObject folderObj = ListTest.createFolderObject(this.userId, "testPropFindWithModified1", 3, false);
        int objectId1 = ListTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj = ListTest.createFolderObject(this.userId, "testPropFindWithModified2", 1, false);
        ListTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject loadFolder = ListTest.loadFolder(this.webCon, objectId1, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadFolder.getLastModified();
        FolderObject[] folderArray = ListTest.listFolder(this.webCon, ListTest.decrementDate(modified), true, false, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"expected response size is >= 2", (folderArray.length >= 2 ? 1 : 0) != 0);
    }

    public void testPropFindWithDeleted() throws Exception {
        FolderObject folderObj = ListTest.createFolderObject(this.userId, "testPropFindWithDeleted1", 2, false);
        int objectId1 = ListTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        folderObj = ListTest.createFolderObject(this.userId, "testPropFindWithDeleted2", 3, false);
        int objectId2 = ListTest.insertFolder(this.webCon, folderObj, "http://" + this.hostName, this.login, this.password, this.context);
        Thread.sleep(1000L);
        FolderObject loadFolder = ListTest.loadFolder(this.webCon, objectId1, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadFolder.getLastModified();
        int[] id = new int[]{objectId1, objectId2};
        ListTest.deleteFolder(this.webCon, id, "http://" + this.hostName, this.login, this.password, this.context);
        FolderObject[] folderArray = ListTest.listFolder(this.webCon, ListTest.decrementDate(modified), false, true, "http://" + this.hostName, this.login, this.password, this.context);
        ListTest.assertTrue((String)"expected response size is < 2", (folderArray.length >= 2 ? 1 : 0) != 0);
    }

    public void testPropFindWithObjectIdOnPrivateFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testPropFindWithObjectIdOnPrivateFolder" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{ListTest.createPermission(this.userId, false, 0, 0, 0, 0)};
        folderObj.setPermissionsAsArray(permission);
        int objectId = ListTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        ListTest.loadFolder(this.getWebConversation(), objectId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        ListTest.deleteFolder(this.getWebConversation(), new int[]{objectId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testPropFindWithObjectIdOnPublicFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testPropFindWithObjectIdOnPublicFolder" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{ListTest.createPermission(this.userId, false, 0, 0, 0, 0)};
        folderObj.setPermissionsAsArray(permission);
        int objectId = ListTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        ListTest.loadFolder(this.getWebConversation(), objectId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        ListTest.deleteFolder(this.getWebConversation(), new int[]{objectId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testObjectNotFound() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testObjectNotFound" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{ListTest.createPermission(this.userId, false, 0, 0, 0, 0)};
        folderObj.setPermissionsAsArray(permission);
        int objectId = ListTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        try {
            ListTest.loadFolder(this.getWebConversation(), objectId + 10000, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            ListTest.fail((String)"object not found exception expected!");
        }
        catch (OXException exc) {
            ListTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        ListTest.deleteFolder(this.getWebConversation(), new int[]{objectId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testList() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testList" + System.currentTimeMillis());
        folderObj.setModule(1);
        folderObj.setType(1);
        folderObj.setParentFolderID(1);
        OCLPermission[] permission = new OCLPermission[]{ListTest.createPermission(this.userId, false, 0, 0, 0, 0)};
        folderObj.setPermissionsAsArray(permission);
        int objectId = ListTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        int[] idArray = ListTest.listFolder(this.getWebConversation(), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < idArray.length; ++a) {
            if (idArray[a] != objectId) continue;
            found = true;
            break;
        }
        ListTest.assertTrue((String)("id " + objectId + " not found in response"), (boolean)found);
        ListTest.deleteFolder(this.getWebConversation(), new int[]{objectId}, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }
}

