/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.contact;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.webdav.xml.ContactTest;
import java.util.Date;
import java.util.Locale;

public class UpdateTest
extends ContactTest {
    public static final String CONTENT_TYPE = "image/png";
    public static final byte[] image = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 1, 0, 0, 0, 1, 1, 3, 0, 0, 0, 37, -37, 86, -54, 0, 0, 0, 6, 80, 76, 84, 69, -1, -1, -1, -1, -1, -1, 85, 124, -11, 108, 0, 0, 0, 1, 116, 82, 78, 83, 0, 64, -26, -40, 102, 0, 0, 0, 1, 98, 75, 71, 68, 0, -120, 5, 29, 72, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 11, 18, 0, 0, 11, 18, 1, -46, -35, 126, -4, 0, 0, 0, 10, 73, 68, 65, 84, 120, -38, 99, 96, 0, 0, 0, 2, 0, 1, -27, 39, -34, -4, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};

    public UpdateTest(String name) {
        super(name);
    }

    public void testUpdateContact() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContact");
        int objectId = UpdateTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj = this.createContactObject("testUpdateContact");
        contactObj.setEmail1(null);
        UpdateTest.updateContact(this.webCon, contactObj, objectId, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Contact loadContact = UpdateTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        UpdateTest.compareObject(contactObj, loadContact);
        UpdateTest.deleteContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateContactWithImage() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContactWithImage");
        int objectId = UpdateTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj = this.createContactObject("testUpdateContactWithImage");
        contactObj.setEmail1(null);
        contactObj.setImageContentType(CONTENT_TYPE);
        contactObj.setImage1(image);
        UpdateTest.updateContact(this.webCon, contactObj, objectId, this.contactFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Contact loadContact = UpdateTest.loadContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        contactObj.removeImage1();
        UpdateTest.compareObject(contactObj, loadContact);
        UpdateTest.deleteContact(this.getWebConversation(), objectId, this.contactFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateConcurentConflict() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContactConcurentConflict");
        int objectId = UpdateTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj = this.createContactObject("testUpdateContactConcurentConflict2");
        try {
            UpdateTest.updateContact(this.webCon, contactObj, objectId, this.contactFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.contactFolderId}};
        UpdateTest.deleteContact(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateNotFound() throws Exception {
        Contact contactObj = this.createContactObject("testUpdateContactNotFound");
        int objectId = UpdateTest.insertContact(this.webCon, contactObj, "http://" + this.hostName, this.login, this.password, this.context);
        contactObj = this.createContactObject("testUpdateContactNotFound");
        try {
            UpdateTest.updateContact(this.webCon, contactObj, objectId + 1000, this.contactFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.contactFolderId}};
        UpdateTest.deleteContact(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

