/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.EntityLockManagerImpl;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockExpiryListener;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.session.Session;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionFactory;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class EntityLockManagerTest
extends TestCase {
    private EntityLockManager lockManager;
    private final List<Integer> clean = new ArrayList<Integer>();
    private final int entity = 23;
    private static final long MILLIS_WEEK = 604800000L;
    private static final long MILLIS_YEAR = 31449600000L;
    private static final long MILLIS_10_YEARS = 314496000000L;
    private Context ctx = new ContextImpl(1);
    private User user = null;
    private ServerSession session;
    private final UserConfiguration userConfig = null;

    public void setUp() throws Exception {
        super.setUp();
        Init.startServer();
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.user = UserStorage.getInstance().getUser(UserStorage.getInstance().getUserId(this.getUsername(), this.ctx), this.ctx);
        this.session = ServerSessionFactory.createServerSession(this.user.getId(), this.ctx, "blupp");
        this.lockManager = new EntityLockManagerImpl((DBProvider)new DBPoolProvider(), "infostore_lock");
        this.lockManager.startTransaction();
    }

    private String getUsername() {
        String userName = AjaxInit.getAJAXProperty("login");
        int pos = userName.indexOf(64);
        return pos == -1 ? userName : userName.substring(0, pos);
    }

    public void tearDown() throws Exception {
        for (int id : this.clean) {
            this.lockManager.unlock(id, (Session)this.session);
        }
        this.lockManager.commit();
        this.lockManager.finish();
        Init.stopServer();
        super.tearDown();
    }

    public void testExclusiveLock() throws Exception {
    }

    public void testSharedLock() throws Exception {
    }

    public void testFindLocks() throws Exception {
        int lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertEquals((int)1, (int)locks.size());
        Lock lock = (Lock)locks.get(0);
        EntityLockManagerTest.assertEquals((int)lockId, (int)lock.getId());
        EntityLockManagerTest.assertEquals((int)this.user.getId(), (int)lock.getOwner());
        EntityLockManagerTest.assertTrue((314496000000L - lock.getTimeout() - System.currentTimeMillis() < 1000L ? 1 : 0) != 0);
        EntityLockManagerTest.assertEquals((Object)LockManager.Scope.EXCLUSIVE, (Object)lock.getScope());
        EntityLockManagerTest.assertEquals((Object)LockManager.Type.WRITE, (Object)lock.getType());
    }

    public void testIsLocked() throws Exception {
        EntityLockManagerTest.assertFalse((String)"Should not be locked", (boolean)this.lockManager.isLocked(23, this.ctx, this.user));
        int lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        EntityLockManagerTest.assertTrue((String)"Should be locked", (boolean)this.lockManager.isLocked(23, this.ctx, this.user));
    }

    public void testUnlock() throws Exception {
        int lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        this.lockManager.unlock(lockId, (Session)this.session);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertTrue((boolean)locks.isEmpty());
    }

    public void testTimeout() throws Exception {
        int lockId = this.lockManager.lock(23, -23L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertEquals((int)0, (int)locks.size());
    }

    public void testTimeoutTriggersListener() throws Exception {
        int lockId = this.lockManager.lock(23, -23L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        LockExpirySpy spy = new LockExpirySpy();
        this.lockManager.addExpiryListener((LockExpiryListener)spy);
        this.clean.add(lockId);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertEquals((String)"A lock remained, though it should have timed out", (int)0, (int)locks.size());
        EntityLockManagerTest.assertEquals((String)"Expected notification about expired lock", (int)1, (int)spy.getExpired().size());
    }

    public void testRemoveAll() throws Exception {
        int lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        this.lockManager.removeAll(23, (Session)this.session);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertTrue((boolean)locks.isEmpty());
    }

    public void testTransferLocks() throws Exception {
        int lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        lockId = this.lockManager.lock(23, -1L, LockManager.Scope.EXCLUSIVE, LockManager.Type.WRITE, "Me", this.ctx, this.user);
        this.clean.add(lockId);
        this.lockManager.transferLocks(this.ctx, this.user.getId(), this.user.getId() + 1);
        List locks = this.lockManager.findLocks(23, (Session)this.session);
        EntityLockManagerTest.assertEquals((String)"locks are assigned to dest", (int)3, (int)locks.size());
        for (Lock lock : locks) {
            EntityLockManagerTest.assertEquals((int)(this.user.getId() + 1), (int)lock.getOwner());
        }
    }

    private static final class LockExpirySpy
    implements LockExpiryListener {
        private final List<Lock> expired = new ArrayList<Lock>();

        private LockExpirySpy() {
        }

        public void lockExpired(Lock lock) {
            this.expired.add(lock);
        }

        public List<Lock> getExpired() {
            return this.expired;
        }
    }
}

