/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.folder;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.server.impl.DBPool;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import com.openexchange.test.AjaxInit;
import com.openexchange.tools.oxfolder.OXFolderManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class FolderTestCase
extends TestCase {
    protected Context ctx = new ContextImpl(1);
    protected User user = null;
    protected UserConfiguration userConfig;
    protected SessionObject session;
    protected List<FolderObject> clean = new ArrayList<FolderObject>();

    public void setUp() throws Exception {
        Init.startServer();
        UserStorage userStorage = UserStorage.getInstance();
        UserConfigurationStorage userConfigStorage = UserConfigurationStorage.getInstance();
        TestConfig config = new TestConfig();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.session = SessionObjectWrapper.createSessionObject((int)userStorage.getUserId(this.getUsername(), this.ctx), (Context)this.ctx, (String)((Object)((Object)this)).getClass().getName());
        this.user = userStorage.getUser(this.session.getUserId(), this.ctx);
        this.userConfig = userConfigStorage.getUserConfiguration(this.session.getUserId(), this.ctx);
    }

    private String getUsername() {
        String userName = AjaxInit.getAJAXProperty("login");
        int pos = userName.indexOf(64);
        return pos == -1 ? userName : userName.substring(0, pos);
    }

    public void tearDown() throws Exception {
        for (FolderObject folderobject : this.clean) {
            this.rm(folderobject.getObjectID());
        }
        Init.stopServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FolderObject mkdir(int parent, String name) throws SQLException, OXException, Exception {
        Connection writecon = null;
        try {
            writecon = DBPool.pickupWriteable((Context)this.ctx);
            OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session, (Connection)writecon, (Connection)writecon);
            OCLPermission oclp = new OCLPermission();
            oclp.setEntity(this.user.getId());
            oclp.setAllPermission(128, 128, 128, 128);
            oclp.setFolderAdmin(true);
            FolderObject fo = new FolderObject();
            fo.setFolderName(name);
            fo.setParentFolderID(parent);
            fo.setModule(8);
            fo.setType(2);
            fo.setPermissionsAsArray(new OCLPermission[]{oclp});
            FolderObject folderObject = fo = oxma.createFolder(fo, true, System.currentTimeMillis());
            return folderObject;
        }
        finally {
            if (writecon != null) {
                DBPool.pushWrite((Context)this.ctx, (Connection)writecon);
            }
        }
    }

    protected void rm(int objectID) throws SQLException, OXException, OXException, Exception {
        OXFolderManager oxma = OXFolderManager.getInstance((Session)this.session);
        oxma.deleteFolder(new FolderObject(objectID), true, System.currentTimeMillis());
    }
}

