/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.caldav.CalDAVTest;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class Bug30359Test
extends CalDAVTest {
    public Bug30359Test(String name) {
        super(name);
    }

    public void testExternalEntities() throws Exception {
        String uri = Bug30359Test.getBaseUri() + "/caldav/" + this.getDefaultFolderID() + "/";
        EntityEnclosingMethod m = new EntityEnclosingMethod(uri){

            public String getName() {
                return "REPORT";
            }
        };
        String secret = "my-password-is-" + UUID.randomUUID().toString();
        File file = File.createTempFile("Bug30359Test", ".txt");
        file.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(secret);
        writer.close();
        String path = file.toURI().toURL().toExternalForm();
        final String body = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE C:calendar-multiget [<!ENTITY foo SYSTEM \"" + path + "\">]><C:calendar-multiget xmlns:D=\"DAV:\" xmlns:C=\"urn:ietf:params:xml:ns:caldav\"><D:prop><D:getetag/><C:calendar-d" + "ata/></D:prop><D:href>/caldav/" + this.getDefaultFolderID() + "/&foo;</D:href></C:calendar-multiget>";
        m.setRequestEntity(new RequestEntity(){

            public void writeRequest(OutputStream arg0) throws IOException {
                arg0.write(body.getBytes("UTF-8"));
            }

            public boolean isRepeatable() {
                return true;
            }

            public String getContentType() {
                return "text/xml; charst=\"utf-8\"";
            }

            public long getContentLength() {
                return body.length();
            }
        });
        int status = this.getWebDAVClient().getHttpClient().executeMethod((HttpMethod)m);
        Bug30359Test.assertEquals((int)207, (int)status);
        String response = m.getResponseBodyAsString();
        Bug30359Test.assertNotNull((Object)response);
        Bug30359Test.assertFalse((String)response, (boolean)response.contains(secret));
    }
}

