/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.GetRequest;
import com.openexchange.ajax.task.actions.GetResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.tasks.Create;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.java.Autoboxing;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class SmokeTest
extends AbstractTaskTest {
    public SmokeTest(String name) {
        super(name);
    }

    public void testCase1803() throws Throwable {
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateTaskFolder();
        Task task = Create.createWithDefaults();
        task.setParentFolderID(folderId);
        task.setTitle("Buy a birthday gift for Mr. K\u00e4rner");
        TimeZone timeZone = client.getValues().getTimeZone();
        SimpleDateFormat dateF = new SimpleDateFormat("dd.MM.yyyy", client.getValues().getLocale());
        dateF.setTimeZone(timeZone);
        task.setStartDate(dateF.parse("26.02.2007"));
        task.setEndDate(dateF.parse("27.02.2007"));
        task.setStatus(2);
        task.setPriority(3);
        task.setPercentComplete(75);
        task.setTargetDuration(Autoboxing.L((long)2L));
        task.setActualDuration(Autoboxing.L((long)2L));
        InsertResponse insertR = client.execute(new InsertRequest(task, timeZone));
        GetResponse getR = TaskTools.get(client, new GetRequest(insertR));
        Task reload = getR.getTask(timeZone);
        TaskTools.compareAttributes(task, reload);
        CommonAllResponse allR = TaskTools.all(client, new AllRequest(folderId, AbstractTaskRequest.GUI_COLUMNS, 202, AllRequest.GUI_ORDER));
        boolean foundObject = false;
        for (Object[] rowValues : allR) {
            if (!rowValues[0].equals(insertR.getId())) continue;
            foundObject = true;
        }
        SmokeTest.assertTrue((String)"All request on folder did not found created object.", (boolean)foundObject);
        client.execute(new DeleteRequest(reload));
    }
}

