/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.AbstractTaskRequest;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Date;

public final class Bug11075Test
extends AbstractTaskTest {
    public Bug11075Test(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug() throws Throwable {
        AJAXClient client = this.getClient();
        InsertRequest[] inserts = new InsertRequest[2];
        for (int i = 0; i < inserts.length; ++i) {
            inserts[i] = new InsertRequest(EnumAPI.OX_OLD, Bug11075Test.createFolder("Bug11075Test_" + i, client.getValues().getUserId()));
        }
        MultipleResponse mInsert = (MultipleResponse)client.execute(MultipleRequest.create(inserts));
        int[] folderIds = new int[inserts.length];
        Date timestamp = new Date(0L);
        for (int i = 0; i < folderIds.length; ++i) {
            CommonInsertResponse response = (CommonInsertResponse)((Object)mInsert.getResponse(i));
            folderIds[i] = response.getId();
            if (!response.getTimestamp().after(timestamp)) continue;
            timestamp = response.getTimestamp();
        }
        try {
            TaskSearchObject search = new TaskSearchObject();
            search.setPattern("");
            SearchRequest request = new SearchRequest(search, AbstractTaskRequest.GUI_COLUMNS);
            SearchResponse response = TaskTools.search(client, request);
            Bug11075Test.assertFalse((String)"Searching over all folders failed.", (boolean)response.hasError());
        }
        finally {
            client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, folderIds, timestamp));
        }
    }

    private static final FolderObject createFolder(String name, int userId) {
        FolderObject folder = new FolderObject();
        folder.setParentFolderID(2);
        folder.setFolderName(name);
        folder.setModule(1);
        folder.setType(2);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(userId);
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(4, 2, 2, 2);
        folder.setPermissionsAsArray(new OCLPermission[]{perm1});
        return folder;
    }
}

