/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.reminder.ReminderObject;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class RangeTest
extends AbstractAJAXSession {
    public RangeTest(String name) {
        super(name);
    }

    public void testRange() throws Exception {
        AJAXClient client = this.getClient();
        int userId = client.getValues().getUserId();
        TimeZone timeZone = client.getValues().getTimeZone();
        Calendar c = TimeTools.createCalendar(timeZone);
        int folderId = client.getValues().getPrivateAppointmentFolder();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testRange");
        appointmentObj.setStartDate(c.getTime());
        c.add(10, 1);
        appointmentObj.setEndDate(c.getTime());
        c.add(10, -1);
        appointmentObj.setShownAs(3);
        appointmentObj.setAlarm(45);
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(true);
        CommonInsertResponse aInsertR = Executor.execute(client, new InsertRequest(appointmentObj, timeZone));
        int targetId = aInsertR.getId();
        ReminderObject[] reminderObj = Executor.execute(client, new RangeRequest(c.getTime())).getReminder(timeZone);
        int pos = -1;
        for (int a = 0; a < reminderObj.length; ++a) {
            if (reminderObj[a].getTargetId() != targetId) continue;
            pos = a;
        }
        RangeTest.assertTrue((String)"reminder not found in response", (pos > -1 ? 1 : 0) != 0);
        RangeTest.assertTrue((String)"object id not found", (reminderObj[pos].getObjectId() > 0 ? 1 : 0) != 0);
        RangeTest.assertNotNull((String)"last modified is null", (Object)reminderObj[pos].getLastModified());
        RangeTest.assertEquals((String)"target id is not equals", (int)targetId, (int)reminderObj[pos].getTargetId());
        RangeTest.assertEquals((String)"folder id is not equals", (int)folderId, (int)reminderObj[pos].getFolder());
        RangeTest.assertEquals((String)"user id is not equals", (int)userId, (int)reminderObj[pos].getUser());
        c.add(12, -45);
        Date expected = c.getTime();
        RangeTest.assertEquals((String)"alarm is not equals", (Object)expected, (Object)reminderObj[pos].getDate());
        GetResponse aGetR = Executor.execute(client, new GetRequest(folderId, targetId));
        Executor.execute(client, new DeleteRequest(targetId, folderId, aGetR.getTimestamp()));
    }
}

