/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount.actions;

import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertParser;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MailAccountInsertRequest
implements AJAXRequest<MailAccountInsertResponse> {
    private final MailAccountDescription account;
    private final boolean failOnError;

    public MailAccountInsertRequest(MailAccountDescription account) {
        this(account, true);
    }

    public MailAccountInsertRequest(MailAccountDescription account, boolean failOnError) {
        this.account = account;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = MailAccountWriter.write((MailAccount)this.wrap(this.account));
        json.put("password", (Object)this.account.getPassword());
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "new")};
    }

    @Override
    public AbstractAJAXParser<MailAccountInsertResponse> getParser() {
        return new MailAccountInsertParser(this.failOnError);
    }

    @Override
    public String getServletPath() {
        return "/ajax/account";
    }

    private MailAccount wrap(final MailAccountDescription acc) {
        return new MailAccount(){

            public String getConfirmedHam() {
                return acc.getConfirmedHam();
            }

            public String getConfirmedSpam() {
                return acc.getConfirmedSpam();
            }

            public String getDrafts() {
                return acc.getDrafts();
            }

            public int getId() {
                return acc.getId();
            }

            public String getLogin() {
                return acc.getLogin();
            }

            public String generateMailServerURL() {
                try {
                    return acc.generateMailServerURL();
                }
                catch (OXException e) {
                    throw new IllegalStateException(e);
                }
            }

            public int getMailPort() {
                return acc.getMailPort();
            }

            public String getMailProtocol() {
                return acc.getMailProtocol();
            }

            public String getMailServer() {
                return acc.getMailServer();
            }

            public boolean isMailSecure() {
                return acc.isMailSecure();
            }

            public String getName() {
                return acc.getName();
            }

            public String getPassword() {
                return acc.getPassword();
            }

            public String getPersonal() {
                return acc.getPersonal();
            }

            public String getReplyTo() {
                return acc.getReplyTo();
            }

            public String getPrimaryAddress() {
                return acc.getPrimaryAddress();
            }

            public String getSent() {
                return acc.getSent();
            }

            public String getSpam() {
                return acc.getSpam();
            }

            public String getSpamHandler() {
                return acc.getSpamHandler();
            }

            public String generateTransportServerURL() {
                try {
                    return acc.generateTransportServerURL();
                }
                catch (OXException e) {
                    throw new IllegalStateException(e);
                }
            }

            public int getTransportPort() {
                return acc.getTransportPort();
            }

            public String getTransportProtocol() {
                return acc.getTransportProtocol();
            }

            public String getTransportServer() {
                return acc.getTransportServer();
            }

            public boolean isTransportSecure() {
                return acc.isTransportSecure();
            }

            public String getTrash() {
                return acc.getTrash();
            }

            public String getArchive() {
                return acc.getArchive();
            }

            public int getUserId() {
                return -1;
            }

            public boolean isDefaultAccount() {
                return false;
            }

            public String getTransportLogin() {
                return acc.getTransportLogin();
            }

            public String getTransportPassword() {
                return acc.getTransportPassword();
            }

            public boolean isUnifiedINBOXEnabled() {
                return acc.isUnifiedINBOXEnabled();
            }

            public String getConfirmedHamFullname() {
                return acc.getConfirmedHamFullname();
            }

            public String getConfirmedSpamFullname() {
                return acc.getConfirmedSpamFullname();
            }

            public String getDraftsFullname() {
                return acc.getDraftsFullname();
            }

            public String getSentFullname() {
                return acc.getSentFullname();
            }

            public String getSpamFullname() {
                return acc.getSpamFullname();
            }

            public String getTrashFullname() {
                return acc.getTrashFullname();
            }

            public String getArchiveFullname() {
                return acc.getArchiveFullname();
            }

            public void addProperty(String name, String value) {
                acc.addProperty(name, value);
            }

            public Map<String, String> getProperties() {
                return acc.getProperties();
            }

            public Map<String, String> getTransportProperties() {
                return acc.getTransportProperties();
            }

            public void addTransportProperty(String name, String value) {
                acc.addTransportProperty(name, value);
            }
        };
    }
}

