/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mailaccount;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.mailaccount.actions.MailAccountDeleteRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertRequest;
import com.openexchange.ajax.mailaccount.actions.MailAccountInsertResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.MailAccountDescription;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class AbstractMailAccountTest
extends AbstractAJAXSession {
    protected MailAccountDescription mailAccountDescription;

    protected AbstractMailAccountTest(String name) {
        super(name);
    }

    protected static MailAccountDescription createMailAccountObject() throws OXException {
        MailAccountDescription mailAccountDescription = new MailAccountDescription();
        mailAccountDescription.setConfirmedHam("confirmedHam");
        mailAccountDescription.setConfirmedSpam("confirmedSpam");
        mailAccountDescription.setDrafts("drafts");
        mailAccountDescription.setLogin("login");
        mailAccountDescription.parseMailServerURL("imap://mail.test.invalid");
        mailAccountDescription.setName("Test Mail Account");
        mailAccountDescription.setPassword("Password");
        mailAccountDescription.setPrimaryAddress("bob@test.invalid");
        mailAccountDescription.setSent("sent");
        mailAccountDescription.setSpam("Spam");
        mailAccountDescription.setSpamHandler("spamHandler");
        mailAccountDescription.parseTransportServerURL("localhost");
        mailAccountDescription.setTransportLogin("login");
        mailAccountDescription.setTransportPassword("Password");
        mailAccountDescription.setTrash("trash");
        return mailAccountDescription;
    }

    protected void createMailAccount() throws OXException, IOException, SAXException, JSONException, OXException {
        this.mailAccountDescription = AbstractMailAccountTest.createMailAccountObject();
        this.updateMailAccountDescription(this.mailAccountDescription, MailConfig.getProperty(MailConfig.Property.LOGIN2));
        MailAccountInsertResponse response = this.getClient().execute(new MailAccountInsertRequest(this.mailAccountDescription));
        response.fillObject(this.mailAccountDescription);
    }

    protected void updateMailAccountDescription(MailAccountDescription mailAccountDescription, String user) {
        mailAccountDescription.setMailServer(MailConfig.getProperty(MailConfig.Property.SERVER));
        mailAccountDescription.setMailPort(Integer.parseInt(MailConfig.getProperty(MailConfig.Property.PORT)));
        mailAccountDescription.setMailProtocol("imap");
        mailAccountDescription.setMailSecure(false);
        mailAccountDescription.setLogin(user);
        mailAccountDescription.setPassword(MailConfig.getProperty(MailConfig.Property.PASSWORD));
        mailAccountDescription.setTransportServer(MailConfig.getProperty(MailConfig.Property.SERVER));
        mailAccountDescription.setTransportPort(25);
        mailAccountDescription.setTransportProtocol("smtp");
        mailAccountDescription.setTransportLogin(user);
        mailAccountDescription.setTransportPassword(MailConfig.getProperty(MailConfig.Property.PASSWORD));
        mailAccountDescription.setTransportSecure(false);
    }

    protected void deleteMailAccount() throws OXException, IOException, SAXException, JSONException {
        this.getClient().execute(new MailAccountDeleteRequest(this.mailAccountDescription.getId()));
    }
}

