/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.jslob.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.jslob.actions.AbstractJSlobRequest;
import com.openexchange.ajax.jslob.actions.ListResponse;
import com.openexchange.jslob.DefaultJSlob;
import com.openexchange.jslob.JSlob;
import com.openexchange.jslob.JSlobId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ListRequest
extends AbstractJSlobRequest<ListResponse> {
    private final String[] identifiers;
    private final boolean failOnError;

    public ListRequest(String ... identifiers) {
        this(true, identifiers);
    }

    public ListRequest(boolean failOnError, String ... identifiers) {
        this.failOnError = failOnError;
        this.identifiers = identifiers;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.Parameter("action", "list"));
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends ListResponse> getParser() {
        return new ListParser(this.failOnError);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        int length = this.identifiers.length;
        JSONArray jArray = new JSONArray(length);
        for (int i = 0; i < length; ++i) {
            jArray.put((Object)this.identifiers[i]);
        }
        return jArray;
    }

    private static class ListParser
    extends AbstractAJAXParser<ListResponse> {
        protected ListParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ListResponse createResponse(Response response) throws JSONException {
            JSONArray jArray = (JSONArray)response.getData();
            int length = jArray.length();
            ArrayList<JSlob> jSlobs = new ArrayList<JSlob>(length);
            for (int i = 0; i < length; ++i) {
                JSONObject jObject = jArray.getJSONObject(i);
                DefaultJSlob jSlob = new DefaultJSlob(jObject.getJSONObject("tree"));
                jSlob.setMetaObject(jObject.optJSONObject("meta"));
                jSlob.setId(new JSlobId(null, jObject.getString("id"), 0, 0));
                jSlobs.add((JSlob)jSlob);
            }
            return new ListResponse(response, jSlobs);
        }
    }
}

